/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ws.axis2;

import java.util.List;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.binding.ws.WebServiceBinding;
import org.apache.tuscany.sca.binding.ws.axis2.Axis2ReferenceBindingProvider;
import org.apache.tuscany.sca.binding.ws.axis2.Axis2ServiceBindingProvider;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.databinding.DataBindingExtensionPoint;
import org.apache.tuscany.sca.host.http.ServletHost;
import org.apache.tuscany.sca.host.http.ServletHostExtensionPoint;
import org.apache.tuscany.sca.provider.BindingProviderFactory;
import org.apache.tuscany.sca.provider.ReferenceBindingProvider;
import org.apache.tuscany.sca.provider.ServiceBindingProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Axis2BindingProviderFactory
implements BindingProviderFactory<WebServiceBinding> {
    private FactoryExtensionPoint modelFactories;
    private ServletHost servletHost;
    private DataBindingExtensionPoint dataBindings;

    public Axis2BindingProviderFactory(ExtensionPointRegistry extensionPoints) {
        ServletHostExtensionPoint servletHosts = (ServletHostExtensionPoint)extensionPoints.getExtensionPoint(ServletHostExtensionPoint.class);
        List hosts = servletHosts.getServletHosts();
        if (!hosts.isEmpty()) {
            this.servletHost = (ServletHost)hosts.get(0);
        }
        this.modelFactories = (FactoryExtensionPoint)extensionPoints.getExtensionPoint(FactoryExtensionPoint.class);
        this.dataBindings = (DataBindingExtensionPoint)extensionPoints.getExtensionPoint(DataBindingExtensionPoint.class);
    }

    public ReferenceBindingProvider createReferenceBindingProvider(EndpointReference endpointReference) {
        return new Axis2ReferenceBindingProvider(endpointReference, this.modelFactories, this.dataBindings);
    }

    public ServiceBindingProvider createServiceBindingProvider(Endpoint endpoint) {
        return new Axis2ServiceBindingProvider(endpoint, this.servletHost, this.modelFactories, this.dataBindings);
    }

    public Class<WebServiceBinding> getModelType() {
        return WebServiceBinding.class;
    }
}

