/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.sca.xml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.Extension;
import org.apache.tuscany.sca.assembly.ExtensionFactory;
import org.apache.tuscany.sca.assembly.SCABinding;
import org.apache.tuscany.sca.assembly.SCABindingFactory;
import org.apache.tuscany.sca.assembly.xml.Constants;
import org.apache.tuscany.sca.assembly.xml.PolicyAttachPointProcessor;
import org.apache.tuscany.sca.contribution.ModelFactoryExtensionPoint;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXAttributeProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.contribution.service.ContributionWriteException;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.policy.IntentAttachPointType;
import org.apache.tuscany.sca.policy.IntentAttachPointTypeFactory;
import org.apache.tuscany.sca.policy.PolicyFactory;
import org.apache.tuscany.sca.policy.PolicySetAttachPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SCABindingProcessor
implements StAXArtifactProcessor<SCABinding>,
Constants {
    private SCABindingFactory scaBindingFactory;
    private ExtensionFactory extensionFactory;
    private PolicyFactory policyFactory;
    private IntentAttachPointTypeFactory intentAttachPointTypeFactory;
    private PolicyAttachPointProcessor policyProcessor;
    private StAXAttributeProcessor<Object> extensionAttributeProcessor;
    private Monitor monitor;
    protected static final String BINDING_SCA = "binding.sca";
    protected static final QName BINDING_SCA_QNAME = new QName("http://www.osoa.org/xmlns/sca/1.0", "binding.sca");

    public SCABindingProcessor(ModelFactoryExtensionPoint modelFactories, StAXArtifactProcessor extensionProcessor, StAXAttributeProcessor extensionAttributeProcessor, Monitor monitor) {
        this.scaBindingFactory = (SCABindingFactory)modelFactories.getFactory(SCABindingFactory.class);
        this.extensionFactory = (ExtensionFactory)modelFactories.getFactory(ExtensionFactory.class);
        this.policyFactory = (PolicyFactory)modelFactories.getFactory(PolicyFactory.class);
        this.intentAttachPointTypeFactory = (IntentAttachPointTypeFactory)modelFactories.getFactory(IntentAttachPointTypeFactory.class);
        this.policyProcessor = new PolicyAttachPointProcessor(this.policyFactory);
        this.extensionAttributeProcessor = extensionAttributeProcessor;
        this.monitor = monitor;
    }

    public QName getArtifactType() {
        return BINDING_SCA_QNAME;
    }

    public Class<SCABinding> getModelType() {
        return SCABinding.class;
    }

    public SCABinding read(XMLStreamReader reader) throws ContributionReadException, XMLStreamException {
        String uri;
        SCABinding scaBinding = this.scaBindingFactory.createSCABinding();
        IntentAttachPointType bindingType = this.intentAttachPointTypeFactory.createBindingType();
        bindingType.setName(this.getArtifactType());
        bindingType.setUnresolved(true);
        ((PolicySetAttachPoint)scaBinding).setType(bindingType);
        this.policyProcessor.readPolicies((Object)scaBinding, reader);
        String name = reader.getAttributeValue(null, "name");
        if (name != null) {
            scaBinding.setName(name);
        }
        if ((uri = reader.getAttributeValue(null, "uri")) != null) {
            scaBinding.setURI(uri);
        }
        for (int a = 0; a < reader.getAttributeCount(); ++a) {
            QName attributeName = reader.getAttributeName(a);
            if (attributeName.getNamespaceURI() == null || attributeName.getNamespaceURI().length() <= 0 || "http://www.osoa.org/xmlns/sca/1.0".equals(attributeName.getNamespaceURI()) || "http://tuscany.apache.org/xmlns/sca/1.0".equals(attributeName.getNamespaceURI())) continue;
            Object attributeValue = this.extensionAttributeProcessor.read(attributeName, reader);
            Extension attributeExtension = attributeValue instanceof Extension ? (Extension)attributeValue : this.extensionFactory.createExtension(attributeName, attributeValue, true);
            scaBinding.getAttributeExtensions().add(attributeExtension);
        }
        while (reader.hasNext() && (reader.next() != 2 || !BINDING_SCA_QNAME.equals(reader.getName()))) {
        }
        return scaBinding;
    }

    public void resolve(SCABinding model, ModelResolver resolver) throws ContributionResolveException {
        this.policyProcessor.resolvePolicies((Object)model, resolver);
    }

    public void write(SCABinding scaBinding, XMLStreamWriter writer) throws ContributionWriteException, XMLStreamException {
        this.policyProcessor.writePolicyPrefixes((Object)scaBinding, writer);
        writer.writeStartElement("http://www.osoa.org/xmlns/sca/1.0", BINDING_SCA);
        this.policyProcessor.writePolicyAttributes((Object)scaBinding, writer);
        if (scaBinding.getName() != null) {
            writer.writeAttribute("name", scaBinding.getName());
        }
        if (scaBinding.getURI() != null) {
            writer.writeAttribute("uri", scaBinding.getURI());
        }
        for (Extension extension : scaBinding.getAttributeExtensions()) {
            if (!extension.isAttribute()) continue;
            this.extensionAttributeProcessor.write((Object)extension, writer);
        }
        writer.writeEndElement();
    }
}

