/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.atom.provider;

import javax.servlet.Servlet;
import org.apache.tuscany.sca.binding.atom.AtomBinding;
import org.apache.tuscany.sca.binding.atom.provider.AtomBindingListenerServlet;
import org.apache.tuscany.sca.databinding.Mediator;
import org.apache.tuscany.sca.host.http.ServletHost;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.provider.ServiceBindingProvider;
import org.apache.tuscany.sca.runtime.Invocable;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;

class AtomServiceBindingProvider
implements ServiceBindingProvider {
    private MessageFactory messageFactory;
    private RuntimeEndpoint endpoint;
    private RuntimeComponent component;
    private RuntimeComponentService service;
    private InterfaceContract serviceContract;
    private AtomBinding binding;
    private ServletHost servletHost;
    private Mediator mediator;
    private String servletMapping;
    private String bindingURI;

    AtomServiceBindingProvider(RuntimeEndpoint endpoint, MessageFactory messageFactory, Mediator mediator, ServletHost servletHost) {
        this.endpoint = endpoint;
        this.component = (RuntimeComponent)endpoint.getComponent();
        this.service = (RuntimeComponentService)endpoint.getService();
        this.binding = (AtomBinding)endpoint.getBinding();
        this.servletHost = servletHost;
        this.messageFactory = messageFactory;
        this.mediator = mediator;
        this.serviceContract = endpoint.getComponentTypeServiceInterfaceContract();
    }

    public InterfaceContract getBindingInterfaceContract() {
        return this.serviceContract;
    }

    public boolean supportsOneWayInvocation() {
        return false;
    }

    public void start() {
        String mappedURI;
        String deployedURI;
        RuntimeEndpoint wire = this.endpoint;
        AtomBindingListenerServlet servlet = new AtomBindingListenerServlet((Invocable)wire, this.messageFactory, this.mediator, this.binding.getTitle(), this.binding.getDescription());
        this.servletMapping = this.binding.getURI();
        if (!this.servletMapping.endsWith("/")) {
            this.servletMapping = this.servletMapping + "/";
        }
        if (!this.servletMapping.endsWith("*")) {
            this.servletMapping = this.servletMapping + "*";
        }
        this.servletHost.addServletMapping(this.servletMapping, (Servlet)servlet);
        this.bindingURI = this.binding.getURI();
        if (!this.bindingURI.endsWith("/")) {
            this.bindingURI = this.bindingURI + "/";
        }
        if ((deployedURI = (mappedURI = this.servletHost.addServletMapping(this.bindingURI, (Servlet)servlet))).endsWith("*")) {
            deployedURI = deployedURI.substring(0, deployedURI.length() - 1);
        }
        if (deployedURI.endsWith("/")) {
            deployedURI = deployedURI.substring(0, deployedURI.length() - 1);
        }
        this.binding.setURI(deployedURI);
        this.endpoint.setDeployedURI(deployedURI);
    }

    public void stop() {
        this.servletHost.removeServletMapping(this.servletMapping);
        this.servletHost.removeServletMapping(this.bindingURI);
    }
}

