/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.atom.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import org.apache.abdera.Abdera;
import org.apache.abdera.factory.Factory;
import org.apache.abdera.model.Document;
import org.apache.abdera.model.Feed;
import org.apache.abdera.parser.Parser;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.tuscany.sca.binding.atom.collection.NotFoundException;
import org.apache.tuscany.sca.binding.atom.provider.AtomBindingUtil;
import org.apache.tuscany.sca.binding.atom.provider.AtomReferenceBindingProvider;
import org.apache.tuscany.sca.data.collection.Entry;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.oasisopen.sca.ServiceRuntimeException;

class AtomBindingInvoker
implements Invoker {
    private static final Factory abderaFactory = Abdera.getNewFactory();
    private static final Parser abderaParser = Abdera.getNewParser();
    Operation operation;
    String uri;
    HttpClient httpClient;
    String authorizationHeader;
    AtomReferenceBindingProvider provider;

    AtomBindingInvoker(Operation operation, String uri, HttpClient httpClient, String authorizationHeader, AtomReferenceBindingProvider bindingProvider) {
        this.operation = operation;
        this.uri = uri;
        this.httpClient = httpClient;
        this.authorizationHeader = authorizationHeader;
        this.provider = bindingProvider;
    }

    public Message invoke(Message msg) {
        throw new UnsupportedOperationException(this.operation.getName());
    }

    private static void release(HttpRequestBase request, HttpResponse response) {
        block3: {
            HttpEntity entity;
            if (response != null && (entity = response.getEntity()) != null) {
                try {
                    entity.consumeContent();
                }
                catch (IOException e) {
                    if (request == null) break block3;
                    request.abort();
                }
            }
        }
    }

    public static class PutMediaInvoker
    extends AtomBindingInvoker {
        public PutMediaInvoker(Operation operation, String uri, HttpClient httpClient, String authorizationHeader, AtomReferenceBindingProvider bindingProvider) {
            super(operation, uri, httpClient, authorizationHeader, bindingProvider);
        }

        @Override
        public Message invoke(Message msg) {
            return super.invoke(msg);
        }
    }

    public static class PostMediaInvoker
    extends AtomBindingInvoker {
        public PostMediaInvoker(Operation operation, String uri, HttpClient httpClient, String authorizationHeader, AtomReferenceBindingProvider bindingProvider) {
            super(operation, uri, httpClient, authorizationHeader, bindingProvider);
        }

        @Override
        public Message invoke(Message msg) {
            return super.invoke(msg);
        }
    }

    public static class QueryInvoker
    extends AtomBindingInvoker {
        public QueryInvoker(Operation operation, String uri, HttpClient httpClient, String authorizationHeader, AtomReferenceBindingProvider bindingProvider) {
            super(operation, uri, httpClient, authorizationHeader, bindingProvider);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Message invoke(Message msg) {
            String queryString = (String)((Object[])msg.getBody())[0];
            HttpGet getMethod = new HttpGet(this.uri + "?" + queryString);
            if (this.authorizationHeader != null) {
                getMethod.setHeader("Authorization", this.authorizationHeader);
            }
            boolean parsing = false;
            HttpResponse response = null;
            try {
                response = this.httpClient.execute((HttpUriRequest)getMethod);
                int status = response.getStatusLine().getStatusCode();
                if (status == 200) {
                    InputStream content = response.getEntity().getContent();
                    Document doc = abderaParser.parse(content);
                    content.close();
                    parsing = true;
                    Feed feed = (Feed)doc.getRoot();
                    if (this.provider.supportsFeedEntries()) {
                        msg.setBody((Object)feed);
                    } else {
                        ArrayList<Entry<Object, Object>> entries = new ArrayList<Entry<Object, Object>>();
                        for (org.apache.abdera.model.Entry feedEntry : feed.getEntries()) {
                            Entry<Object, Object> entry = AtomBindingUtil.entry(feedEntry, this.provider.getItemClassType(), this.provider.getItemXMLType(), this.provider.getMediator());
                            entries.add(entry);
                        }
                        msg.setBody((Object)entries.toArray(new Entry[entries.size()]));
                    }
                } else if (status == 404) {
                    if (this.provider.supportsFeedEntries()) {
                        msg.setFaultBody((Object)new NotFoundException());
                    } else {
                        msg.setFaultBody((Object)new org.apache.tuscany.sca.data.collection.NotFoundException());
                    }
                } else {
                    msg.setFaultBody((Object)new ServiceRuntimeException("HTTP status code: " + status));
                }
            }
            catch (Exception e) {
                msg.setFaultBody((Object)new ServiceRuntimeException((Throwable)e));
            }
            finally {
                AtomBindingInvoker.release((HttpRequestBase)getMethod, response);
            }
            return msg;
        }
    }

    public static class GetAllInvoker
    extends AtomBindingInvoker {
        public GetAllInvoker(Operation operation, String uri, HttpClient httpClient, String authorizationHeader, AtomReferenceBindingProvider bindingProvider) {
            super(operation, uri, httpClient, authorizationHeader, bindingProvider);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Message invoke(Message msg) {
            block16: {
                HttpGet getMethod = new HttpGet(this.uri);
                if (this.authorizationHeader != null) {
                    getMethod.setHeader("Authorization", this.authorizationHeader);
                }
                boolean parsing = false;
                HttpResponse response = null;
                try {
                    response = this.httpClient.execute((HttpUriRequest)getMethod);
                    int status = response.getStatusLine().getStatusCode();
                    if (status == 200) {
                        InputStream content = response.getEntity().getContent();
                        Document doc = abderaParser.parse(content);
                        content.close();
                        parsing = true;
                        Feed feed = null;
                        try {
                            feed = (Feed)doc.getRoot();
                        }
                        catch (Exception e) {
                            throw new IllegalArgumentException("Invalid feed format :" + this.uri);
                        }
                        if (this.provider.supportsFeedEntries()) {
                            msg.setBody((Object)feed);
                        } else {
                            ArrayList<Entry<Object, Object>> entries = new ArrayList<Entry<Object, Object>>();
                            for (org.apache.abdera.model.Entry feedEntry : feed.getEntries()) {
                                Entry<Object, Object> entry = AtomBindingUtil.entry(feedEntry, this.provider.getItemClassType(), this.provider.getItemXMLType(), this.provider.getMediator());
                                entries.add(entry);
                            }
                            msg.setBody((Object)entries.toArray(new Entry[entries.size()]));
                        }
                        break block16;
                    }
                    if (status == 404) {
                        if (this.provider.supportsFeedEntries()) {
                            msg.setFaultBody((Object)new NotFoundException());
                        } else {
                            msg.setFaultBody((Object)new org.apache.tuscany.sca.data.collection.NotFoundException());
                        }
                    } else {
                        msg.setFaultBody((Object)new ServiceRuntimeException("HTTP status code: " + status));
                    }
                }
                catch (Exception e) {
                    msg.setFaultBody((Object)new ServiceRuntimeException((Throwable)e));
                }
                finally {
                    AtomBindingInvoker.release((HttpRequestBase)getMethod, response);
                }
            }
            return msg;
        }
    }

    public static class DeleteInvoker
    extends AtomBindingInvoker {
        public DeleteInvoker(Operation operation, String uri, HttpClient httpClient, String authorizationHeader, AtomReferenceBindingProvider bindingProvider) {
            super(operation, uri, httpClient, authorizationHeader, bindingProvider);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Message invoke(Message msg) {
            String id = (String)((Object[])msg.getBody())[0];
            HttpDelete deleteMethod = new HttpDelete(this.uri + "/" + id);
            if (this.authorizationHeader != null) {
                deleteMethod.setHeader("Authorization", this.authorizationHeader);
            }
            HttpResponse response = null;
            try {
                response = this.httpClient.execute((HttpUriRequest)deleteMethod);
                int status = response.getStatusLine().getStatusCode();
                if (status == 200) {
                    msg.setBody(null);
                } else if (status == 404) {
                    if (this.provider.supportsFeedEntries()) {
                        msg.setFaultBody((Object)new NotFoundException());
                    } else {
                        msg.setFaultBody((Object)new org.apache.tuscany.sca.data.collection.NotFoundException());
                    }
                } else {
                    msg.setFaultBody((Object)new ServiceRuntimeException("HTTP status code: " + status));
                }
            }
            catch (Exception e) {
                msg.setFaultBody((Object)new ServiceRuntimeException((Throwable)e));
            }
            finally {
                AtomBindingInvoker.release((HttpRequestBase)deleteMethod, response);
            }
            return msg;
        }
    }

    public static class PutInvoker
    extends AtomBindingInvoker {
        public PutInvoker(Operation operation, String uri, HttpClient httpClient, String authorizationHeader, AtomReferenceBindingProvider bindingProvider) {
            super(operation, uri, httpClient, authorizationHeader, bindingProvider);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Message invoke(Message msg) {
            org.apache.abdera.model.Entry feedEntry;
            String id;
            Object[] args = (Object[])msg.getBody();
            if (this.provider.supportsFeedEntries()) {
                id = (String)args[0];
                feedEntry = (org.apache.abdera.model.Entry)args[1];
            } else {
                id = (String)args[0];
                Entry entry = new Entry((Object)id, args[1]);
                feedEntry = AtomBindingUtil.feedEntry((Entry<Object, Object>)entry, this.provider.getItemClassType(), this.provider.getItemXMLType(), this.provider.getMediator(), abderaFactory);
            }
            HttpPut putMethod = new HttpPut(this.uri + "/" + id);
            if (this.authorizationHeader != null) {
                putMethod.setHeader("Authorization", this.authorizationHeader);
            }
            HttpResponse response = null;
            try {
                StringWriter writer = new StringWriter();
                feedEntry.writeTo((Writer)writer);
                putMethod.setHeader("Content-type", "application/atom+xml");
                putMethod.setEntity((HttpEntity)new StringEntity(writer.toString()));
                response = this.httpClient.execute((HttpUriRequest)putMethod);
                int status = response.getStatusLine().getStatusCode();
                if (status == 200 || status == 201 || status == 412) {
                    msg.setBody(null);
                } else if (status == 404) {
                    if (this.provider.supportsFeedEntries()) {
                        msg.setFaultBody((Object)new NotFoundException());
                    } else {
                        msg.setFaultBody((Object)new org.apache.tuscany.sca.data.collection.NotFoundException());
                    }
                } else {
                    msg.setFaultBody((Object)new ServiceRuntimeException("HTTP status code: " + status));
                }
                AtomBindingInvoker.release((HttpRequestBase)putMethod, response);
            }
            catch (Exception e) {
                msg.setFaultBody((Object)new ServiceRuntimeException((Throwable)e));
            }
            finally {
                AtomBindingInvoker.release((HttpRequestBase)putMethod, response);
            }
            return msg;
        }
    }

    public static class PostInvoker
    extends AtomBindingInvoker {
        public PostInvoker(Operation operation, String uri, HttpClient httpClient, String authorizationHeader, AtomReferenceBindingProvider bindingProvider) {
            super(operation, uri, httpClient, authorizationHeader, bindingProvider);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Message invoke(Message msg) {
            org.apache.abdera.model.Entry feedEntry;
            Object[] args = (Object[])msg.getBody();
            if (this.provider.supportsFeedEntries()) {
                feedEntry = (org.apache.abdera.model.Entry)args[0];
            } else {
                Entry entry = new Entry(args[0], args[1]);
                feedEntry = AtomBindingUtil.feedEntry((Entry<Object, Object>)entry, this.provider.getItemClassType(), this.provider.getItemXMLType(), this.provider.getMediator(), abderaFactory);
            }
            HttpPost postMethod = new HttpPost(this.uri);
            if (this.authorizationHeader != null) {
                postMethod.setHeader("Authorization", this.authorizationHeader);
            }
            boolean parsing = false;
            HttpResponse response = null;
            try {
                StringWriter writer = new StringWriter();
                feedEntry.writeTo((Writer)writer);
                postMethod.setHeader("Content-type", "application/atom+xml");
                postMethod.setEntity((HttpEntity)new StringEntity(writer.toString()));
                response = this.httpClient.execute((HttpUriRequest)postMethod);
                int status = response.getStatusLine().getStatusCode();
                if (status == 200 || status == 201) {
                    InputStream content = postMethod.getEntity().getContent();
                    Document doc = abderaParser.parse(content);
                    content.close();
                    parsing = true;
                    org.apache.abdera.model.Entry createdEntry = (org.apache.abdera.model.Entry)doc.getRoot();
                    if (this.provider.supportsFeedEntries()) {
                        msg.setBody((Object)createdEntry);
                    } else {
                        msg.setBody((Object)createdEntry.getId().toString());
                    }
                } else if (status == 404) {
                    response.getEntity().consumeContent();
                    if (this.provider.supportsFeedEntries()) {
                        msg.setFaultBody((Object)new NotFoundException());
                    } else {
                        msg.setFaultBody((Object)new org.apache.tuscany.sca.data.collection.NotFoundException());
                    }
                } else {
                    response.getEntity().consumeContent();
                    msg.setFaultBody((Object)new ServiceRuntimeException("HTTP status code: " + status));
                }
                AtomBindingInvoker.release((HttpRequestBase)postMethod, response);
            }
            catch (Exception e) {
                msg.setFaultBody((Object)new ServiceRuntimeException((Throwable)e));
            }
            finally {
                AtomBindingInvoker.release((HttpRequestBase)postMethod, response);
            }
            return msg;
        }
    }

    public static class GetInvoker
    extends AtomBindingInvoker {
        public GetInvoker(Operation operation, String uri, HttpClient httpClient, String authorizationHeader, AtomReferenceBindingProvider bindingProvider) {
            super(operation, uri, httpClient, authorizationHeader, bindingProvider);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Message invoke(Message msg) {
            String id = (String)((Object[])msg.getBody())[0];
            HttpGet getMethod = new HttpGet(this.uri + "/" + id);
            if (this.authorizationHeader != null) {
                getMethod.setHeader("Authorization", this.authorizationHeader);
            }
            boolean parsing = false;
            HttpResponse response = null;
            try {
                response = this.httpClient.execute((HttpUriRequest)getMethod);
                int status = response.getStatusLine().getStatusCode();
                if (status == 200) {
                    InputStream content = response.getEntity().getContent();
                    Document doc = abderaParser.parse(content);
                    content.close();
                    parsing = true;
                    org.apache.abdera.model.Entry feedEntry = (org.apache.abdera.model.Entry)doc.getRoot();
                    if (this.provider.supportsFeedEntries()) {
                        msg.setBody((Object)feedEntry);
                    } else {
                        Entry<Object, Object> entry = AtomBindingUtil.entry(feedEntry, this.provider.getItemClassType(), this.provider.getItemXMLType(), this.provider.getMediator());
                        msg.setBody(entry.getData());
                    }
                } else if (status == 404) {
                    if (this.provider.supportsFeedEntries()) {
                        msg.setFaultBody((Object)new NotFoundException());
                    } else {
                        msg.setFaultBody((Object)new org.apache.tuscany.sca.data.collection.NotFoundException());
                    }
                } else {
                    msg.setFaultBody((Object)new ServiceRuntimeException("HTTP status code: " + status));
                }
            }
            catch (Exception e) {
                msg.setFaultBody((Object)new ServiceRuntimeException((Throwable)e));
            }
            finally {
                AtomBindingInvoker.release((HttpRequestBase)getMethod, response);
            }
            return msg;
        }
    }
}

