/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.wink;

import java.beans.Introspector;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import javax.servlet.ServletContext;
import org.apache.tuscany.sca.implementation.web.runtime.utils.ContextHelper;
import org.apache.wink.common.RuntimeContext;
import org.apache.wink.common.internal.registry.Injectable;
import org.oasisopen.sca.annotation.Property;

public class PropertyInjectable
extends Injectable {
    private String name;

    public PropertyInjectable(Property propertyAnnotation, Injectable.ParamType paramType, Class<?> type, Type genericType, Annotation[] annotations, Member member) {
        super(paramType, type, genericType, annotations, member);
        this.name = this.getPropertyName(propertyAnnotation.name(), member);
    }

    public Object getValue(RuntimeContext runtimeContext) throws IOException {
        return ContextHelper.getProperty(this.name, (ServletContext)runtimeContext.getAttribute(ServletContext.class));
    }

    private String getPropertyName(String annotationName, Member member) {
        String name;
        if (annotationName != null && !annotationName.equals("")) {
            name = annotationName;
        } else {
            name = this.getMember().getName();
            if (name.startsWith("set")) {
                name = Introspector.decapitalize(name.substring(3));
            }
        }
        return name;
    }
}

