/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.stripes;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.ServletContext;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.controller.StripesFilter;
import net.sourceforge.stripes.exception.StripesRuntimeException;
import net.sourceforge.stripes.util.Log;
import net.sourceforge.stripes.util.ReflectUtil;
import org.apache.tuscany.sca.implementation.web.runtime.utils.ContextHelper;
import org.oasisopen.sca.annotation.Reference;

public class TuscanyHelper {
    private static final Log log = Log.getInstance(TuscanyHelper.class);
    private static Map<Class<?>, Collection<Method>> methodMap = new ConcurrentHashMap();
    private static Map<Class<?>, Collection<Field>> fieldMap = new ConcurrentHashMap();

    public static void injectBeans(Object bean, ActionBeanContext context) {
        TuscanyHelper.injectBeans(bean, StripesFilter.getConfiguration().getServletContext());
    }

    public static void injectBeans(Object bean, ServletContext ctx) {
        String name;
        boolean nameSupplied;
        Reference scaReference;
        for (Method m : TuscanyHelper.getMethods(bean.getClass())) {
            try {
                scaReference = m.getAnnotation(Reference.class);
                nameSupplied = !"".equals(scaReference.name());
                name = nameSupplied ? scaReference.name() : TuscanyHelper.methodToPropertyName(m);
                Class<?> beanType = m.getParameterTypes()[0];
                Object managedBean = TuscanyHelper.findReference(ctx, name, beanType, !nameSupplied);
                m.invoke(bean, managedBean);
            }
            catch (Exception e) {
                throw new StripesRuntimeException("Exception while trying to lookup and inject an SCA Reference into a bean of type " + bean.getClass().getSimpleName() + " using method " + m.toString(), (Throwable)e);
            }
        }
        for (Field f : TuscanyHelper.getFields(bean.getClass())) {
            try {
                scaReference = f.getAnnotation(Reference.class);
                nameSupplied = !"".equals(scaReference.name());
                name = nameSupplied ? scaReference.name() : f.getName();
                Object managedBean = TuscanyHelper.findReference(ctx, name, f.getType(), !nameSupplied);
                f.set(bean, managedBean);
            }
            catch (Exception e) {
                throw new StripesRuntimeException("Exception while trying to lookup and inject an SCA Referenceinto a bean of type " + bean.getClass().getSimpleName() + " using field access on field " + f.toString(), (Throwable)e);
            }
        }
    }

    protected static Collection<Method> getMethods(Class<?> clazz) {
        Collection methods = methodMap.get(clazz);
        if (methods == null) {
            methods = ReflectUtil.getMethods(clazz);
            Iterator iterator = methods.iterator();
            while (iterator.hasNext()) {
                Method method = (Method)iterator.next();
                if (!method.isAnnotationPresent(Reference.class)) {
                    iterator.remove();
                    continue;
                }
                if (!method.isAccessible()) {
                    try {
                        method.setAccessible(true);
                    }
                    catch (SecurityException se) {
                        throw new StripesRuntimeException("Method " + clazz.getName() + "." + method.getName() + "is marked " + "with @Reference and is not public. An attempt to call " + "setAccessible(true) resulted in a SecurityException. Please " + "either make the method public or modify your JVM security " + "policy to allow Stripes to setAccessible(true).", (Throwable)se);
                    }
                }
                if (method.getParameterTypes().length == 1) continue;
                throw new StripesRuntimeException("A method marked with @Reference must have exactly one parameter: the bean to be injected. Method [" + method.toGenericString() + "] has " + method.getParameterTypes().length + " parameters.");
            }
            methodMap.put(clazz, methods);
        }
        return methods;
    }

    protected static Collection<Field> getFields(Class<?> clazz) {
        Collection fields = fieldMap.get(clazz);
        if (fields == null) {
            fields = ReflectUtil.getFields(clazz);
            Iterator iterator = fields.iterator();
            while (iterator.hasNext()) {
                Field field = (Field)iterator.next();
                if (!field.isAnnotationPresent(Reference.class)) {
                    iterator.remove();
                    continue;
                }
                if (field.isAccessible()) continue;
                try {
                    field.setAccessible(true);
                }
                catch (SecurityException se) {
                    throw new StripesRuntimeException("Field " + clazz.getName() + "." + field.getName() + "is marked " + "with @Reference and is not public. An attempt to call " + "setAccessible(true) resulted in a SecurityException. Please " + "either make the field public, annotate a public setter instead " + "or modify your JVM security policy to allow Stripes to " + "setAccessible(true).", (Throwable)se);
                }
            }
            fieldMap.put(clazz, fields);
        }
        return fields;
    }

    protected static Object findReference(ServletContext ctx, String name, Class<?> type, boolean allowFindByType) {
        Object bean = ContextHelper.getReference(name, type, ctx);
        if (bean == null) {
            throw new StripesRuntimeException("no reference defined:" + name);
        }
        log.debug(new Object[]{"Found sca reference with name [", name, "] and type [", bean.getClass().getName(), "]"});
        return bean;
    }

    protected static String methodToPropertyName(Method m) {
        String name = m.getName();
        if (name.startsWith("set") && name.length() > 3) {
            String ret = name.substring(3, 4).toLowerCase();
            if (name.length() > 4) {
                ret = ret + name.substring(4);
            }
            return ret;
        }
        return name;
    }
}

