/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.policy.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.definitions.Definitions;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.PolicyExpression;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.PolicySubject;

public class PolicyHelper {
    public static PolicySet getPolicySet(PolicySubject subject, QName policySetName) {
        for (PolicySet ps : subject.getPolicySets()) {
            if (!ps.getName().equals(policySetName)) continue;
            return ps;
        }
        return null;
    }

    public static Intent getIntent(Definitions subject, QName intentName) {
        for (Intent i : subject.getIntents()) {
            if (i.getName().equals(intentName)) {
                return i;
            }
            for (Intent qualifiedIntent : i.getQualifiedIntents()) {
                if (!qualifiedIntent.getName().equals(intentName)) continue;
                return qualifiedIntent;
            }
        }
        return null;
    }

    public static PolicySet getPolicySet(Definitions subject, QName policySetName) {
        for (PolicySet ps : subject.getPolicySets()) {
            if (!ps.getName().equals(policySetName)) continue;
            return ps;
        }
        return null;
    }

    public static Intent getIntent(PolicySubject subject, QName intentName) {
        for (Intent i : subject.getRequiredIntents()) {
            if (!i.getName().equals(intentName)) continue;
            return i;
        }
        return null;
    }

    public static Collection<PolicyExpression> getPolicyExpressions(PolicySubject subject, QName policyName) {
        ArrayList<PolicyExpression> policies = new ArrayList<PolicyExpression>();
        for (PolicySet ps : subject.getPolicySets()) {
            for (PolicyExpression exp : ps.getPolicies()) {
                if (!exp.getName().equals(policyName)) continue;
                policies.add(exp);
            }
        }
        return policies;
    }

    public static Collection<Object> getPolicies(PolicySubject subject, QName policyName) {
        ArrayList<Object> policies = new ArrayList<Object>();
        for (PolicySet ps : subject.getPolicySets()) {
            for (PolicyExpression exp : ps.getPolicies()) {
                if (!exp.getName().equals(policyName)) continue;
                policies.add(exp.getPolicy());
            }
        }
        return policies;
    }

    public static boolean isIntentRequired(PolicySubject subject, QName intent) {
        List<Intent> intents = subject.getRequiredIntents();
        for (Intent i : intents) {
            if (!intent.equals(i.getName())) continue;
            return true;
        }
        return PolicyHelper.getPolicySet(subject, intent) != null;
    }
}

