/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.interfacedef.java.jaxws;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.xml.namespace.QName;
import javax.xml.ws.WebFault;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.databinding.DataBindingExtensionPoint;
import org.apache.tuscany.sca.databinding.jaxb.XMLAdapterExtensionPoint;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.FaultExceptionMapper;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.impl.DataTypeImpl;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.jaxws.CodeGenerationHelper;
import org.apache.tuscany.sca.interfacedef.java.jaxws.GeneratedClassLoader;
import org.apache.tuscany.sca.interfacedef.java.jaxws.GeneratedDataTypeImpl;
import org.apache.tuscany.sca.interfacedef.util.FaultException;
import org.apache.tuscany.sca.interfacedef.util.XMLType;
import org.oasisopen.sca.ServiceRuntimeException;

public class JAXWSFaultExceptionMapper
implements FaultExceptionMapper {
    public static final String GETCAUSE = "getCause";
    public static final String GETLOCALIZEDMESSAGE = "getLocalizedMessage";
    public static final String GETSTACKTRACE = "getStackTrace";
    public static final String GETCLASS = "getClass";
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private DataBindingExtensionPoint dataBindingExtensionPoint;
    private XMLAdapterExtensionPoint xmlAdapterExtensionPoint;

    public JAXWSFaultExceptionMapper(DataBindingExtensionPoint dataBindingExtensionPoint, XMLAdapterExtensionPoint xmlAdapters) {
        this.dataBindingExtensionPoint = dataBindingExtensionPoint;
        this.xmlAdapterExtensionPoint = xmlAdapters;
    }

    public JAXWSFaultExceptionMapper(ExtensionPointRegistry registry) {
        this.dataBindingExtensionPoint = registry.getExtensionPoint(DataBindingExtensionPoint.class);
        this.xmlAdapterExtensionPoint = registry.getExtensionPoint(XMLAdapterExtensionPoint.class);
    }

    @Override
    public Throwable wrapFaultInfo(DataType<DataType> exceptionType, String message, Object faultInfo, Throwable cause, Operation operation) {
        Class<?> exceptionClass = exceptionType.getPhysical();
        if (exceptionClass.isInstance(faultInfo)) {
            return (Throwable)faultInfo;
        }
        DataType faultBeanType = exceptionType.getLogical();
        Class<?> faultBeanClass = faultBeanType.getPhysical();
        try {
            Throwable exc = this.newInstance(exceptionClass, message, faultBeanClass, faultInfo, cause);
            if (exc instanceof FaultException && faultBeanType.getLogical() instanceof XMLType) {
                FaultException faultExc = (FaultException)exc;
                DataType faultBeanXMLType = faultBeanType;
                XMLType faultLogical = (XMLType)faultBeanXMLType.getLogical();
                faultExc.setFaultName(faultLogical.getElementName());
            }
            return exc;
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    private Throwable newInstance(Class<? extends Throwable> exceptionClass, String message, Class<?> faultBeanClass, Object faultInfo, Throwable cause) throws Exception {
        Throwable ex = null;
        Constructor<? extends Throwable> ctor = null;
        try {
            Method getMessage = faultBeanClass.getMethod("getMessage", new Class[0]);
            message = (String)getMessage.invoke(faultInfo, new Object[0]);
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (faultInfo == null) {
            try {
                ctor = exceptionClass.getConstructor(String.class, Throwable.class);
                ex = ctor.newInstance(message, cause);
            }
            catch (NoSuchMethodException e1) {
                try {
                    ctor = exceptionClass.getConstructor(String.class);
                    ex = ctor.newInstance(message);
                }
                catch (NoSuchMethodException e2) {
                    try {
                        ctor = exceptionClass.getConstructor(Throwable.class);
                        ex = ctor.newInstance(cause);
                    }
                    catch (NoSuchMethodException e3) {
                        ctor = exceptionClass.getConstructor(new Class[0]);
                        ex = ctor.newInstance(new Object[0]);
                    }
                }
            }
        } else {
            try {
                ctor = exceptionClass.getConstructor(String.class, faultBeanClass, Throwable.class);
                ex = ctor.newInstance(message, faultInfo, cause);
            }
            catch (NoSuchMethodException e1) {
                try {
                    ctor = exceptionClass.getConstructor(String.class, faultInfo.getClass());
                    ex = ctor.newInstance(message, faultInfo);
                }
                catch (NoSuchMethodException e2) {
                    try {
                        ctor = exceptionClass.getConstructor(String.class, Throwable.class);
                        ex = ctor.newInstance(message, cause);
                        this.populateException(ex, faultInfo);
                    }
                    catch (NoSuchMethodException e3) {
                        try {
                            ctor = exceptionClass.getConstructor(String.class);
                            ex = ctor.newInstance(message);
                            this.populateException(ex, faultInfo);
                        }
                        catch (NoSuchMethodException e4) {
                            try {
                                ctor = exceptionClass.getConstructor(new Class[0]);
                                if (ctor != null) {
                                    ex = ctor.newInstance(new Object[0]);
                                    this.populateException(ex, faultInfo);
                                } else {
                                    ex = new FaultException(message, faultInfo, cause);
                                }
                            }
                            catch (NoSuchMethodException e5) {
                                try {
                                    ctor = exceptionClass.getConstructor(Throwable.class);
                                    ex = ctor.newInstance(cause);
                                    this.populateException(ex, faultInfo);
                                }
                                catch (NoSuchMethodException e6) {
                                    ctor = exceptionClass.getConstructor(new Class[0]);
                                    ex = ctor.newInstance(new Object[0]);
                                }
                            }
                        }
                    }
                }
            }
        }
        return ex;
    }

    private void populateException(Throwable ex, Object faultBean) throws Exception {
        PropertyDescriptor[] props;
        for (PropertyDescriptor p : props = Introspector.getBeanInfo(faultBean.getClass()).getPropertyDescriptors()) {
            Method getter = p.getReadMethod();
            Method setter = p.getWriteMethod();
            if (getter == null || setter == null) continue;
            try {
                Method m = ex.getClass().getMethod(setter.getName(), setter.getParameterTypes());
                Object pv = getter.invoke(faultBean, new Object[0]);
                m.invoke((Object)ex, pv);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    @Override
    public Object getFaultInfo(Throwable exception, Class<?> faultBeanClass, Operation operation) {
        if (exception == null) {
            return null;
        }
        if (exception instanceof FaultException) {
            return ((FaultException)exception).getFaultInfo();
        }
        try {
            Method method = exception.getClass().getMethod("getFaultInfo", EMPTY_CLASS_ARRAY);
            return method.invoke((Object)exception, (Object[])null);
        }
        catch (NoSuchMethodException e) {
            return this.createFaultBean(exception, faultBeanClass);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException(e);
        }
    }

    private Object createFaultBean(Throwable exception, Class<?> faultBeanClass) {
        if (faultBeanClass.isInstance(exception)) {
            return exception;
        }
        try {
            Object faultBean = null;
            for (Constructor<?> ctor : faultBeanClass.getConstructors()) {
                Class<?>[] params = ctor.getParameterTypes();
                if (params.length == 1 && String.class == params[0]) {
                    faultBean = ctor.newInstance(exception.getMessage());
                } else if (params.length == 2 && String.class == params[0] && Throwable.class.isAssignableFrom(params[1])) {
                    faultBean = ctor.newInstance(exception.getMessage(), exception);
                } else if (params.length == 0) {
                    faultBean = ctor.newInstance(new Object[0]);
                }
                if (faultBean != null) break;
            }
            if (faultBean == null) {
                return exception;
            }
            BeanInfo beanInfo = Introspector.getBeanInfo(exception.getClass());
            for (PropertyDescriptor pd : beanInfo.getPropertyDescriptors()) {
                Method getter = pd.getReadMethod();
                String name = getter.getName();
                if (!JAXWSFaultExceptionMapper.isMappedGetter(name)) continue;
                Method setter = null;
                try {
                    setter = faultBeanClass.getMethod("set" + JAXWSFaultExceptionMapper.capitalize(pd.getName()), getter.getReturnType());
                }
                catch (NoSuchMethodException e) {
                    continue;
                }
                Object prop = getter.invoke((Object)exception, new Object[0]);
                setter.invoke(faultBean, prop);
            }
            return faultBean;
        }
        catch (Throwable ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    @Override
    public boolean introspectFaultDataType(DataType<DataType> exceptionType, final Operation operation, final boolean generatingFaultBean) {
        boolean result = false;
        final Class<?> cls = exceptionType.getPhysical();
        if (cls == FaultException.class) {
            return true;
        }
        DataType<XMLType> faultType = exceptionType.getLogical();
        QName faultName = ((XMLType)faultType.getLogical()).getElementName();
        Class<?> faultBean = null;
        final WebFault fault = cls.getAnnotation(WebFault.class);
        if (fault != null) {
            if (!"".equals(fault.name()) || !"".equals(fault.targetNamespace())) {
                QName faultQName = ((XMLType)faultType.getLogical()).getElementName();
                String faultNS = "".equals(fault.targetNamespace()) ? faultQName.getNamespaceURI() : fault.targetNamespace();
                String faultLocal = "".equals(fault.name()) ? faultQName.getLocalPart() : fault.name();
                faultName = new QName(faultNS, faultLocal);
                XMLType xmlType = new XMLType(faultName, null);
                faultType.setLogical(xmlType);
            }
            if (!"".equals(fault.faultBean())) {
                faultBean = (Class<?>)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

                    @Override
                    public Class<?> run() {
                        try {
                            return Class.forName(fault.faultBean(), false, cls.getClassLoader());
                        }
                        catch (ClassNotFoundException e) {
                            throw new ServiceRuntimeException(e);
                        }
                    }
                });
            } else {
                try {
                    Method m = cls.getMethod("getFaultInfo", null);
                    faultBean = m.getReturnType();
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
            }
        }
        if (faultBean == null) {
            final String faultBeanClassName = CodeGenerationHelper.getPackagePrefix(cls) + cls.getSimpleName() + "Bean";
            final QName qname = faultName;
            faultType = AccessController.doPrivileged(new PrivilegedAction<DataType<XMLType>>(){

                @Override
                public DataType<XMLType> run() {
                    try {
                        Class<?> faultBean = Class.forName(faultBeanClassName, false, cls.getClassLoader());
                        return new DataTypeImpl<XMLType>(faultBean, new XMLType(qname, qname));
                    }
                    catch (ClassNotFoundException e) {
                        if (generatingFaultBean) {
                            Class t = cls;
                            ClassLoader parent = operation == null ? t.getClassLoader() : ((JavaInterface)operation.getInterface()).getJavaClass().getClassLoader();
                            GeneratedClassLoader cl = new GeneratedClassLoader(parent);
                            GeneratedDataTypeImpl dt = new GeneratedDataTypeImpl(JAXWSFaultExceptionMapper.this.xmlAdapterExtensionPoint, t, cl, operation);
                            return dt;
                        }
                        return new DataTypeImpl<XMLType>(cls, new XMLType(qname, qname));
                    }
                }
            });
        } else {
            faultType.setDataBinding(null);
            faultType.setGenericType(faultBean);
            faultType.setPhysical(faultBean);
        }
        if (faultType.getDataBinding() == null && this.dataBindingExtensionPoint != null) {
            faultBean = faultType.getPhysical();
            result = this.dataBindingExtensionPoint.introspectType(faultType, operation);
        }
        exceptionType.setLogical(faultType);
        if (faultName != null && faultType.getLogical() instanceof XMLType) {
            XMLType faultTypeXML = (XMLType)faultType.getLogical();
            faultTypeXML.setElementName(faultName);
        }
        return result;
    }

    public static boolean isMappedGetter(String methodName) {
        return !GETCAUSE.equals(methodName) && !GETLOCALIZEDMESSAGE.equals(methodName) && !GETSTACKTRACE.equals(methodName) && !GETCLASS.equals(methodName);
    }

    private static String capitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        return Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }
}

