/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.interfacedef.java.jaxws;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.xml.namespace.QName;
import javax.xml.ws.WebFault;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.impl.JavaInterfaceUtil;
import org.apache.tuscany.sca.interfacedef.java.jaxws.BaseBeanGenerator;
import org.apache.tuscany.sca.interfacedef.java.jaxws.GeneratedClassLoader;
import org.objectweb.asm.ClassWriter;

public class FaultBeanGenerator
extends BaseBeanGenerator {
    protected BaseBeanGenerator.BeanProperty[] getProperties(Class<? extends Throwable> exceptionClass) {
        BeanInfo beanInfo;
        try {
            beanInfo = Introspector.getBeanInfo(exceptionClass);
        }
        catch (IntrospectionException e) {
            throw new IllegalArgumentException(e);
        }
        ArrayList<BaseBeanGenerator.BeanProperty> props = new ArrayList<BaseBeanGenerator.BeanProperty>();
        for (PropertyDescriptor pd : beanInfo.getPropertyDescriptors()) {
            String name;
            if (pd.getReadMethod() == null || "getClass".equals(name = pd.getReadMethod().getName()) || "getStackTrace".equals(name) || "getSuppressed".equals(name) || "getCause".equals(name) || "getLocalizedMessage".equals(name)) continue;
            String field = pd.getName();
            Method getter = pd.getReadMethod();
            props.add(new BaseBeanGenerator.BeanProperty("", field, getter.getReturnType(), getter.getGenericReturnType(), false));
        }
        Collections.sort(props, new Comparator<BaseBeanGenerator.BeanProperty>(){

            @Override
            public int compare(BaseBeanGenerator.BeanProperty o1, BaseBeanGenerator.BeanProperty o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return props.toArray(new BaseBeanGenerator.BeanProperty[0]);
    }

    public byte[] generate(Class<? extends Throwable> exceptionClass, Operation operation) {
        ClassWriter cw;
        try {
            Constructor c = ClassWriter.class.getConstructor(Integer.TYPE);
            Field f = ClassWriter.class.getField("COMPUTE_MAXS");
            cw = (ClassWriter)c.newInstance(f.get(null));
        }
        catch (Exception ex) {
            try {
                Constructor c = ClassWriter.class.getConstructor(Boolean.TYPE);
                cw = (ClassWriter)c.newInstance(true);
            }
            catch (Exception ex2) {
                throw new IllegalArgumentException(ex2);
            }
        }
        QName element = FaultBeanGenerator.getElementName(exceptionClass, operation);
        String name = element.getLocalPart();
        String namespace = element.getNamespaceURI();
        String className = FaultBeanGenerator.getFaultBeanName(exceptionClass, operation);
        String classDescriptor = className.replace('.', '/');
        String classSignature = "L" + classDescriptor + ";";
        return this.defineClass(cw, classDescriptor, classSignature, namespace, name, this.getProperties(exceptionClass));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> generate(Class<? extends Throwable> exceptionClass, GeneratedClassLoader cl, Operation operation) {
        Class<? extends Throwable> clazz = exceptionClass;
        synchronized (clazz) {
            QName element = FaultBeanGenerator.getElementName(exceptionClass, operation);
            WeakReference wr = (WeakReference)generatedClasses.get(element);
            Class<?> faultBeanClass = null;
            if (wr != null) {
                faultBeanClass = (Class<?>)wr.get();
            }
            if (faultBeanClass == null) {
                String name = element.getLocalPart();
                String namespace = element.getNamespaceURI();
                String className = FaultBeanGenerator.getFaultBeanName(exceptionClass, operation);
                String classDescriptor = className.replace('.', '/');
                String classSignature = "L" + classDescriptor + ";";
                faultBeanClass = this.generate(classDescriptor, classSignature, namespace, name, this.getProperties(exceptionClass), cl);
                generatedClasses.put(element, new WeakReference(faultBeanClass));
            }
            return faultBeanClass;
        }
    }

    private static String getFaultBeanName(Class<?> exceptionClass, Operation operation) {
        String interfacePkg = null;
        if (operation != null && operation.getInterface() instanceof JavaInterface) {
            interfacePkg = ((JavaInterface)operation.getInterface()).getJavaClass().getPackage().getName();
        }
        String faultBeanName = null;
        WebFault webFault = exceptionClass.getAnnotation(WebFault.class);
        if (webFault != null && !"".equals(faultBeanName = webFault.faultBean())) {
            return faultBeanName;
        }
        String name = exceptionClass.getName();
        int index = name.lastIndexOf(46);
        String pkg = null;
        pkg = interfacePkg != null ? interfacePkg : name.substring(0, index);
        String clsName = name.substring(index + 1);
        if (pkg.startsWith("java.") || pkg.startsWith("javax.")) {
            pkg = "tuscany";
        }
        faultBeanName = pkg + ".jaxws." + clsName + "Bean";
        return faultBeanName;
    }

    public static QName getElementName(Class<? extends Throwable> exceptionClass, Operation operation) {
        WebFault webFault = exceptionClass.getAnnotation(WebFault.class);
        String namespace = null;
        if (operation != null && operation.getInterface() instanceof JavaInterface) {
            namespace = ((JavaInterface)operation.getInterface()).getQName().getNamespaceURI();
        }
        String name = null;
        if (webFault != null) {
            namespace = webFault.targetNamespace();
            name = webFault.name();
        }
        if (namespace == null) {
            namespace = JavaInterfaceUtil.getNamespace(exceptionClass);
        }
        if (name == null) {
            name = exceptionClass.getSimpleName();
        }
        return new QName(namespace, name);
    }

    public static Class<?> generateFaultBeanClass(Class<? extends Throwable> exceptionClass) {
        FaultBeanGenerator generator = new FaultBeanGenerator();
        GeneratedClassLoader cl = new GeneratedClassLoader(exceptionClass.getClassLoader());
        return generator.generate(exceptionClass, cl, null);
    }
}

