/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.web.xml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.ComponentType;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.implementation.web.WebImplementation;
import org.apache.tuscany.sca.implementation.web.WebImplementationFactory;
import org.apache.tuscany.sca.implementation.web.impl.WebImplementationFactoryImpl;

public class WebImplementationProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<WebImplementation> {
    private static final QName IMPLEMENTATION_WEB = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "implementation.web");
    private AssemblyFactory assemblyFactory;
    private WebImplementationFactory implementationFactory;

    public WebImplementationProcessor(ExtensionPointRegistry extensionPoints) {
        FactoryExtensionPoint modelFactories = extensionPoints.getExtensionPoint(FactoryExtensionPoint.class);
        this.assemblyFactory = modelFactories.getFactory(AssemblyFactory.class);
        this.implementationFactory = new WebImplementationFactoryImpl();
    }

    @Override
    public QName getArtifactType() {
        return IMPLEMENTATION_WEB;
    }

    @Override
    public Class<WebImplementation> getModelType() {
        return WebImplementation.class;
    }

    @Override
    public WebImplementation read(XMLStreamReader reader, ProcessorContext context) throws ContributionReadException, XMLStreamException {
        String jsClient;
        WebImplementation implementation = this.implementationFactory.createWebImplementation();
        implementation.setUnresolved(true);
        String webURI = this.getString(reader, "web-uri");
        if (webURI != null) {
            implementation.setWebURI(webURI);
            implementation.setURI(webURI);
        }
        if ((jsClient = reader.getAttributeValue("http://tuscany.apache.org/xmlns/sca/1.1", "jsClient")) != null) {
            implementation.setJSClient(Boolean.parseBoolean(jsClient));
        }
        while (reader.hasNext() && (reader.next() != 2 || !IMPLEMENTATION_WEB.equals(reader.getName()))) {
        }
        return implementation;
    }

    @Override
    public void resolve(WebImplementation implementation, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        String uri = implementation.getURI();
        if (uri != null) {
            ComponentType componentType = this.assemblyFactory.createComponentType();
            componentType.setURI("web.componentType");
            componentType = resolver.resolveModel(ComponentType.class, componentType, context);
            if (!componentType.isUnresolved()) {
                implementation.getServices().addAll(componentType.getServices());
                implementation.getReferences().addAll(componentType.getReferences());
                implementation.getProperties().addAll(componentType.getProperties());
            }
        }
        implementation.setUnresolved(false);
    }

    @Override
    public void write(WebImplementation implementation, XMLStreamWriter writer, ProcessorContext context) throws ContributionWriteException, XMLStreamException {
        this.writeStart(writer, IMPLEMENTATION_WEB.getNamespaceURI(), IMPLEMENTATION_WEB.getLocalPart(), new BaseStAXArtifactProcessor.XAttr("web-uri", implementation.getWebURI()));
        this.writeEnd(writer);
    }
}

