/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.introspect.impl;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Multiplicity;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.implementation.java.IntrospectionException;
import org.apache.tuscany.sca.implementation.java.JavaElementImpl;
import org.apache.tuscany.sca.implementation.java.JavaImplementation;
import org.apache.tuscany.sca.implementation.java.JavaParameterImpl;
import org.apache.tuscany.sca.implementation.java.introspect.BaseJavaClassVisitor;
import org.apache.tuscany.sca.implementation.java.introspect.JavaIntrospectionHelper;
import org.apache.tuscany.sca.implementation.java.introspect.impl.DuplicateReferenceException;
import org.apache.tuscany.sca.implementation.java.introspect.impl.IllegalPropertyException;
import org.apache.tuscany.sca.implementation.java.introspect.impl.IllegalReferenceException;
import org.apache.tuscany.sca.implementation.java.introspect.impl.InvalidConstructorException;
import org.apache.tuscany.sca.implementation.java.introspect.impl.InvalidReferenceException;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceContract;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceFactory;
import org.oasisopen.sca.ServiceReference;
import org.oasisopen.sca.annotation.AllowsPassByReference;
import org.oasisopen.sca.annotation.Remotable;

public class ReferenceProcessor
extends BaseJavaClassVisitor {
    public ReferenceProcessor(AssemblyFactory assemblyFactory, JavaInterfaceFactory javaFactory) {
        super(assemblyFactory);
        this.javaInterfaceFactory = javaFactory;
    }

    public ReferenceProcessor(ExtensionPointRegistry registry) {
        super(registry);
    }

    @Override
    public void visitMethod(Method method, JavaImplementation type) throws IntrospectionException {
        org.oasisopen.sca.annotation.Reference annotation = method.getAnnotation(org.oasisopen.sca.annotation.Reference.class);
        if (annotation != null) {
            JavaElementImpl ref;
            if (!JavaIntrospectionHelper.isSetter(method)) {
                throw new IllegalReferenceException("Annotated method is not a setter: " + method, method);
            }
            if (Modifier.isStatic(method.getModifiers())) {
                throw new IllegalPropertyException("Static method " + method.getName() + " in class " + method.getDeclaringClass().getName() + " can not be annotated as a Reference");
            }
            String name = annotation.name();
            if ("".equals(name)) {
                name = JavaIntrospectionHelper.toPropertyName(method.getName());
            }
            if ((ref = type.getReferenceMembers().get(name)) != null && ref.getElementType() != ElementType.FIELD) {
                throw new DuplicateReferenceException(name);
            }
            ReferenceProcessor.removeReference(ref, type);
            JavaElementImpl element = new JavaElementImpl(method, 0);
            Reference reference = this.createReference(type, element, name);
            type.getReferences().add(reference);
            type.getReferenceMembers().put(name, element);
        }
        Annotation[][] paramsAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < paramsAnnotations.length; ++i) {
            Annotation[] argAnnotations = paramsAnnotations[i];
            for (int j = 0; j < argAnnotations.length; ++j) {
                if (argAnnotations[j].annotationType() != org.oasisopen.sca.annotation.Reference.class) continue;
                throw new IllegalReferenceException("Argument " + (i + 1) + " of method " + method.getName() + " in class " + method.getDeclaringClass() + " can not be a Reference");
            }
        }
    }

    @Override
    public void visitField(Field field, JavaImplementation type) throws IntrospectionException {
        JavaElementImpl ref;
        org.oasisopen.sca.annotation.Reference annotation = field.getAnnotation(org.oasisopen.sca.annotation.Reference.class);
        if (annotation == null) {
            return;
        }
        if (Modifier.isStatic(field.getModifiers())) {
            throw new IllegalReferenceException("Static field " + field.getName() + " in class " + field.getDeclaringClass().getName() + " can not be annotated as Reference");
        }
        String name = annotation.name();
        if ("".equals(name)) {
            name = field.getName();
        }
        if ((ref = type.getReferenceMembers().get(name)) != null && ref.getElementType() == ElementType.FIELD) {
            throw new DuplicateReferenceException(name);
        }
        if (ref == null) {
            JavaElementImpl element = new JavaElementImpl(field);
            Reference reference = this.createReference(type, element, name);
            type.getReferences().add(reference);
            type.getReferenceMembers().put(name, element);
        }
    }

    @Override
    public void visitConstructorParameter(JavaParameterImpl parameter, JavaImplementation type) throws IntrospectionException {
        org.oasisopen.sca.annotation.Reference refAnnotation = parameter.getAnnotation(org.oasisopen.sca.annotation.Reference.class);
        if (refAnnotation == null) {
            return;
        }
        if (!refAnnotation.required()) {
            throw new InvalidReferenceException("[JCA90016] Constructor has @Reference with required=false: " + type.getName());
        }
        if (refAnnotation.name() == null || refAnnotation.name().length() < 1) {
            throw new InvalidReferenceException("[JCA90018] @Reference in a Constructor must have a name attribute" + type.getName());
        }
        String paramName = parameter.getName();
        String name = ReferenceProcessor.getReferenceName(paramName, parameter.getIndex(), refAnnotation.name());
        JavaElementImpl ref = type.getReferenceMembers().get(name);
        if (ref != null && ref.getElementType() != ElementType.FIELD) {
            throw new DuplicateReferenceException(name);
        }
        ReferenceProcessor.removeReference(ref, type);
        Reference reference = this.createReference(type, parameter, name);
        type.getReferences().add(reference);
        type.getReferenceMembers().put(name, parameter);
        parameter.setClassifer(org.oasisopen.sca.annotation.Reference.class);
        parameter.setName(name);
    }

    private Reference createReference(JavaImplementation implementation, JavaElementImpl element, String name) throws IntrospectionException {
        boolean forceRemotable;
        Reference reference = this.assemblyFactory.createReference();
        JavaInterfaceContract interfaceContract = this.javaInterfaceFactory.createJavaInterfaceContract();
        reference.setInterfaceContract(interfaceContract);
        AllowsPassByReference pbr = element.getAnnotation(AllowsPassByReference.class);
        if (pbr != null) {
            reference.setAllowsPassByReference(true);
        } else {
            reference.setAllowsPassByReference(implementation.isAllowsPassByReference());
        }
        boolean required = true;
        org.oasisopen.sca.annotation.Reference ref = element.getAnnotation(org.oasisopen.sca.annotation.Reference.class);
        if (ref != null) {
            required = ref.required();
        }
        reference.setName(name);
        Class<?> rawType = element.getType();
        if (rawType.isArray() || Collection.class.isAssignableFrom(rawType)) {
            if (required) {
                reference.setMultiplicity(Multiplicity.ONE_N);
            } else {
                reference.setMultiplicity(Multiplicity.ZERO_N);
            }
        } else if (required) {
            reference.setMultiplicity(Multiplicity.ONE_ONE);
        } else {
            reference.setMultiplicity(Multiplicity.ZERO_ONE);
        }
        Type genericType = element.getGenericType();
        Class<?> baseType = JavaIntrospectionHelper.getBaseType(rawType, genericType);
        if (ServiceReference.class.isAssignableFrom(baseType)) {
            if (Collection.class.isAssignableFrom(rawType)) {
                genericType = JavaIntrospectionHelper.getParameterType(genericType);
            }
            baseType = JavaIntrospectionHelper.getBusinessInterface(baseType, genericType);
        }
        boolean bl = forceRemotable = element.getAnnotation(Remotable.class) != null;
        if (!forceRemotable && element.getElementType() == ElementType.PARAMETER && element.getAnchor() instanceof Method) {
            Annotation[] argAnnotations = ((Method)element.getAnchor()).getParameterAnnotations()[0];
            for (int j = 0; j < argAnnotations.length; ++j) {
                if (argAnnotations[j].annotationType() != Remotable.class) continue;
                forceRemotable = true;
                break;
            }
        }
        try {
            JavaInterface callInterface = this.javaInterfaceFactory.createJavaInterface(baseType, forceRemotable);
            reference.getInterfaceContract().setInterface(callInterface);
            if (callInterface.getCallbackClass() != null) {
                JavaInterface callbackInterface = this.javaInterfaceFactory.createJavaInterface(callInterface.getCallbackClass(), forceRemotable);
                reference.getInterfaceContract().setCallbackInterface(callbackInterface);
            }
        }
        catch (InvalidInterfaceException e) {
            throw new IntrospectionException(e);
        }
        return reference;
    }

    private static String getReferenceName(String paramName, int pos, String name) throws InvalidConstructorException {
        if ("".equals(name)) {
            name = paramName;
        }
        if ("".equals(name)) {
            return "_ref" + pos;
        }
        if (!"".equals(paramName) && !name.equals(paramName)) {
            throw new InvalidConstructorException("Mismatching names specified for reference parameter " + pos);
        }
        return name;
    }

    private static boolean removeReference(JavaElementImpl ref, JavaImplementation type) {
        if (ref == null) {
            return false;
        }
        List<Reference> refs = type.getReferences();
        for (int i = 0; i < refs.size(); ++i) {
            if (!refs.get(i).getName().equals(ref.getName())) continue;
            refs.remove(i);
            return true;
        }
        return false;
    }
}

