/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.java.impl;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.extensibility.ServiceDeclaration;
import org.apache.tuscany.sca.implementation.java.IntrospectionException;
import org.apache.tuscany.sca.implementation.java.JavaImplementation;
import org.apache.tuscany.sca.implementation.java.JavaImplementationFactory;
import org.apache.tuscany.sca.implementation.java.impl.JavaClassIntrospectorImpl;
import org.apache.tuscany.sca.implementation.java.impl.JavaImplementationImpl;
import org.apache.tuscany.sca.implementation.java.introspect.JavaClassVisitor;

public abstract class JavaImplementationFactoryImpl
implements JavaImplementationFactory {
    private List<JavaClassVisitor> visitors = new ArrayList<JavaClassVisitor>();
    private JavaClassIntrospectorImpl introspector;
    private boolean loaded;
    protected ExtensionPointRegistry registry;

    public JavaImplementationFactoryImpl(ExtensionPointRegistry registry) {
        this.registry = registry;
    }

    @Override
    public JavaImplementation createJavaImplementation() {
        JavaImplementationImpl javaImplementation = new JavaImplementationImpl();
        return javaImplementation;
    }

    @Override
    public JavaImplementation createJavaImplementation(Class<?> implementationClass) throws IntrospectionException {
        JavaImplementation javaImplementation = this.createJavaImplementation();
        this.getIntrospector().introspectClass(javaImplementation, implementationClass);
        return javaImplementation;
    }

    @Override
    public void createJavaImplementation(JavaImplementation javaImplementation, Class<?> implementationClass) throws IntrospectionException {
        this.getIntrospector().introspectClass(javaImplementation, implementationClass);
    }

    @Override
    public void addClassVisitor(JavaClassVisitor visitor) {
        for (JavaClassVisitor tmpVisitor : this.visitors) {
            if (tmpVisitor.getClass() != visitor.getClass()) continue;
            return;
        }
        this.visitors.add(visitor);
    }

    @Override
    public void removeClassVisitor(JavaClassVisitor visitor) {
        this.visitors.remove(visitor);
    }

    @Override
    public List<JavaClassVisitor> getClassVisitors() {
        this.loadVisitors();
        return this.visitors;
    }

    private synchronized void loadVisitors() {
        Collection<ServiceDeclaration> visitorDeclarations;
        if (this.loaded) {
            return;
        }
        try {
            visitorDeclarations = this.registry.getServiceDiscovery().getServiceDeclarations(JavaClassVisitor.class, true);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        for (ServiceDeclaration visitorDeclaration : visitorDeclarations) {
            JavaClassVisitor visitor = null;
            try {
                Class<?> visitorClass = visitorDeclaration.loadClass();
                try {
                    Constructor<?> constructor = visitorClass.getConstructor(ExtensionPointRegistry.class);
                    visitor = (JavaClassVisitor)constructor.newInstance(this.registry);
                }
                catch (NoSuchMethodException e) {
                    visitor = (JavaClassVisitor)visitorClass.newInstance();
                }
            }
            catch (Exception e) {
                IllegalStateException ie = new IllegalStateException(e);
                throw ie;
            }
            this.addClassVisitor(visitor);
        }
        this.loaded = true;
    }

    private synchronized JavaClassIntrospectorImpl getIntrospector() {
        if (this.introspector != null) {
            return this.introspector;
        }
        this.introspector = new JavaClassIntrospectorImpl(this.getClassVisitors());
        return this.introspector;
    }
}

