/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.bpel.xml;

import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.implementation.bpel.xml.BPELPartnerLinkTypeElement;

public class BPELPartnerLinkElement {
    private String REFERENCE_TYPE = "reference";
    private String SERVICE_TYPE = "service";
    private String name;
    private QName partnerLinkType;
    private BPELPartnerLinkTypeElement pLinkType = null;
    private String myRole;
    private String partnerRole;
    private String scaName;
    private String scaType = null;

    public BPELPartnerLinkElement(String name, QName partnerLinkType, String myRole, String partnerRole) {
        this.name = name;
        this.partnerLinkType = partnerLinkType;
        this.myRole = myRole;
        this.partnerRole = partnerRole;
        this.scaName = null;
    }

    public QName getPartnerLinkType() {
        return this.partnerLinkType;
    }

    public void setPartnerLinkType(BPELPartnerLinkTypeElement pLinkType) {
        this.pLinkType = pLinkType;
    }

    public PortType getMyRolePortType() {
        return this.getRolePortType(this.myRole);
    }

    public PortType getPartnerRolePortType() {
        return this.getRolePortType(this.partnerRole);
    }

    private PortType getRolePortType(String theRole) {
        if (theRole == null || theRole.length() == 0) {
            return null;
        }
        if (this.pLinkType == null) {
            throw new IllegalStateException("BPELPartnerLinkElement: " + this.name + " has no Partner Link type object set");
        }
        if (theRole.equals(this.pLinkType.getRole1Name())) {
            return this.pLinkType.getRole1pType();
        }
        if (theRole.equals(this.pLinkType.getRole2Name())) {
            return this.pLinkType.getRole2pType();
        }
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getMyRole() {
        return this.myRole;
    }

    public String getPartnerRole() {
        return this.partnerRole;
    }

    public void setSCAName(String name) {
        this.scaName = name;
    }

    public String getSCAName() {
        return this.scaName;
    }

    public boolean isSCATyped() {
        return this.scaType != null;
    }

    public void setAsReference(String name) {
        this.scaType = this.REFERENCE_TYPE;
        this.scaName = name;
    }

    public void setAsService(String name) {
        this.scaType = this.SERVICE_TYPE;
        this.scaName = name;
    }

    public String querySCAType() {
        return this.scaType;
    }
}

