/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.implementation.bpel.xml;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import javax.wsdl.PortType;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.ComponentType;
import org.apache.tuscany.sca.assembly.Multiplicity;
import org.apache.tuscany.sca.assembly.Property;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.implementation.bpel.BPELFactory;
import org.apache.tuscany.sca.implementation.bpel.BPELImplementation;
import org.apache.tuscany.sca.implementation.bpel.BPELProcessDefinition;
import org.apache.tuscany.sca.implementation.bpel.xml.BPELImportElement;
import org.apache.tuscany.sca.implementation.bpel.xml.BPELPartnerLinkElement;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLDefinition;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLFactory;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLInterface;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLInterfaceContract;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;

public class BPELImplementationProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<BPELImplementation> {
    private static final String SCA11_NS = "http://docs.oasis-open.org/ns/opencsa/sca/200912";
    private static final String PROCESS = "process";
    private static final String IMPLEMENTATION_BPEL = "implementation.bpel";
    private static final QName IMPLEMENTATION_BPEL_QNAME = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "implementation.bpel");
    private AssemblyFactory assemblyFactory;
    private BPELFactory bpelFactory;
    private WSDLFactory wsdlFactory;

    public BPELImplementationProcessor(FactoryExtensionPoint modelFactories) {
        this.assemblyFactory = modelFactories.getFactory(AssemblyFactory.class);
        this.wsdlFactory = modelFactories.getFactory(WSDLFactory.class);
        this.bpelFactory = modelFactories.getFactory(BPELFactory.class);
    }

    @Override
    public QName getArtifactType() {
        return IMPLEMENTATION_BPEL_QNAME;
    }

    @Override
    public Class<BPELImplementation> getModelType() {
        return BPELImplementation.class;
    }

    @Override
    public BPELImplementation read(XMLStreamReader reader, ProcessorContext context) throws ContributionReadException, XMLStreamException {
        assert (IMPLEMENTATION_BPEL_QNAME.equals(reader.getName()));
        BPELImplementation implementation = null;
        QName process = this.getAttributeValueNS(reader, PROCESS, context.getMonitor());
        if (process == null) {
            return implementation;
        }
        implementation = this.bpelFactory.createBPELImplementation();
        implementation.setProcess(process);
        implementation.setUnresolved(true);
        while (reader.hasNext() && (reader.next() != 2 || !IMPLEMENTATION_BPEL_QNAME.equals(reader.getName()))) {
        }
        return implementation;
    }

    @Override
    public void resolve(BPELImplementation implementation, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        if (implementation != null && implementation.isUnresolved()) {
            implementation.setModelResolver(resolver);
            BPELProcessDefinition processDefinition = this.resolveBPELProcessDefinition(implementation, resolver, context);
            if (processDefinition.isUnresolved()) {
                this.error(context.getMonitor(), "BPELProcessNotFound", implementation, processDefinition.getName());
            } else {
                implementation.setProcessDefinition(processDefinition);
                this.generateComponentType(implementation, context.getMonitor());
                implementation.setUnresolved(false);
            }
        }
    }

    @Override
    public void write(BPELImplementation bpelImplementation, XMLStreamWriter writer, ProcessorContext context) throws ContributionWriteException, XMLStreamException {
        writer.writeStartElement(SCA11_NS, IMPLEMENTATION_BPEL);
        if (bpelImplementation.getProcess() != null) {
            writer.writeAttribute(PROCESS, bpelImplementation.getProcess().toString());
        }
        writer.writeEndElement();
    }

    private BPELProcessDefinition resolveBPELProcessDefinition(BPELImplementation impl, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        QName processName = impl.getProcess();
        BPELProcessDefinition processDefinition = this.bpelFactory.createBPELProcessDefinition();
        processDefinition.setName(processName);
        processDefinition.setUnresolved(true);
        return resolver.resolveModel(BPELProcessDefinition.class, processDefinition, context);
    }

    private void resolveBPELImports(BPELProcessDefinition processDefinition, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        for (BPELImportElement bpelImport : processDefinition.getImports()) {
            String namespace = bpelImport.getNamespace();
            String location = bpelImport.getLocation();
            WSDLDefinition wsdl = bpelImport.getWSDLDefinition();
            if (wsdl != null) continue;
            try {
                wsdl = this.wsdlFactory.createWSDLDefinition();
                wsdl.setUnresolved(true);
                wsdl.setNamespace(bpelImport.getNamespace());
                wsdl.setLocation(new URI(null, bpelImport.getLocation(), null));
                if ((wsdl = resolver.resolveModel(WSDLDefinition.class, wsdl, context)).isUnresolved()) continue;
                bpelImport.setWSDLDefinition(wsdl);
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
    }

    private void generateComponentType(BPELImplementation impl, Monitor monitor) throws ContributionResolveException {
        ComponentType componentType = this.assemblyFactory.createComponentType();
        componentType.setUnresolved(true);
        impl.setComponentType(componentType);
        BPELProcessDefinition theProcess = impl.getProcessDefinition();
        List<BPELPartnerLinkElement> partnerLinks = theProcess.getPartnerLinks();
        for (BPELPartnerLinkElement pLink : partnerLinks) {
            if (!pLink.isSCATyped()) continue;
            String scaName = pLink.getSCAName();
            if (pLink.querySCAType().equals("reference")) {
                componentType.getReferences().add(this.generateReference(scaName, pLink.getMyRolePortType(), pLink.getPartnerRolePortType(), theProcess.getInterfaces(), monitor));
                continue;
            }
            componentType.getServices().add(this.generateService(scaName, pLink.getMyRolePortType(), pLink.getPartnerRolePortType(), theProcess.getInterfaces(), monitor));
        }
        for (Property property : theProcess.getProperties()) {
            componentType.getProperties().add(property);
        }
    }

    private Reference generateReference(String name, PortType myRolePT, PortType partnerRolePT, Collection<WSDLInterface> theInterfaces, Monitor monitor) throws ContributionResolveException {
        Reference reference = this.assemblyFactory.createReference();
        WSDLInterfaceContract interfaceContract = this.wsdlFactory.createWSDLInterfaceContract();
        reference.setInterfaceContract(interfaceContract);
        PortType callPT = null;
        PortType callbackPT = null;
        if (partnerRolePT != null) {
            callPT = partnerRolePT;
            if (myRolePT != null && !myRolePT.getQName().equals(partnerRolePT.getQName())) {
                callbackPT = myRolePT;
            }
        } else if (myRolePT != null) {
            callPT = myRolePT;
        }
        if (callPT == null && callbackPT == null) {
            this.error(monitor, "MyRolePartnerRoleNull", theInterfaces, new Object[0]);
        }
        reference.setName(name);
        reference.setMultiplicity(Multiplicity.ONE_ONE);
        if (callPT != null) {
            WSDLInterface callInterface = null;
            for (WSDLInterface anInterface : theInterfaces) {
                if (!anInterface.getPortType().getQName().equals(callPT.getQName())) continue;
                callInterface = anInterface;
            }
            if (callInterface == null) {
                this.error(monitor, "NoInterfaceForPortType", theInterfaces, callPT.getQName().toString());
            } else {
                reference.getInterfaceContract().setInterface(callInterface);
            }
        }
        if (callbackPT != null) {
            WSDLInterface callbackInterface = null;
            for (WSDLInterface anInterface : theInterfaces) {
                if (!anInterface.getPortType().getQName().equals(callbackPT.getQName())) continue;
                callbackInterface = anInterface;
            }
            if (callbackInterface == null) {
                this.error(monitor, "NoInterfaceForPortType", theInterfaces, callbackPT.getQName().toString());
            } else {
                reference.getInterfaceContract().setCallbackInterface(callbackInterface);
            }
        }
        return reference;
    }

    private Service generateService(String name, PortType myRolePT, PortType partnerRolePT, Collection<WSDLInterface> theInterfaces, Monitor monitor) throws ContributionResolveException {
        Service service = this.assemblyFactory.createService();
        WSDLInterfaceContract interfaceContract = this.wsdlFactory.createWSDLInterfaceContract();
        service.setInterfaceContract(interfaceContract);
        service.setName(name);
        PortType callPT = null;
        PortType callbackPT = null;
        if (myRolePT != null) {
            callPT = myRolePT;
            if (partnerRolePT != null && !myRolePT.getQName().equals(partnerRolePT.getQName())) {
                callbackPT = partnerRolePT;
            }
        } else if (partnerRolePT != null) {
            callPT = partnerRolePT;
        }
        if (callPT == null && callbackPT == null) {
            this.error(monitor, "MyRolePartnerRoleNull", theInterfaces, new Object[0]);
        }
        if (callPT != null) {
            WSDLInterface callInterface = null;
            for (WSDLInterface anInterface : theInterfaces) {
                if (!anInterface.getPortType().getQName().equals(callPT.getQName())) continue;
                callInterface = anInterface;
            }
            if (callInterface == null) {
                this.error(monitor, "NoInterfaceForPortType", theInterfaces, callPT.getQName().toString());
            } else {
                service.getInterfaceContract().setInterface(callInterface);
            }
        }
        if (callbackPT != null) {
            WSDLInterface callbackInterface = null;
            for (WSDLInterface anInterface : theInterfaces) {
                if (!anInterface.getPortType().getQName().equals(callbackPT.getQName())) continue;
                callbackInterface = anInterface;
            }
            if (callbackInterface == null) {
                this.error(monitor, "NoInterfaceForPortType", theInterfaces, callbackPT.getQName().toString());
            } else {
                service.getInterfaceContract().setCallbackInterface(callbackInterface);
            }
        }
        return service;
    }

    private QName getAttributeValueNS(XMLStreamReader reader, String attribute, Monitor monitor) {
        String fullValue = reader.getAttributeValue(null, attribute);
        if (fullValue == null) {
            this.error(monitor, "AttributeProcessMissing", reader, new Object[0]);
            return null;
        }
        if (fullValue.trim().charAt(0) == '{') {
            try {
                QName theProcess = QName.valueOf(fullValue);
                return theProcess;
            }
            catch (IllegalArgumentException e) {
                this.error(monitor, "AttributeWithoutNamespace", reader, attribute, fullValue);
                return null;
            }
        }
        if (fullValue.indexOf(":") < 0) {
            this.error(monitor, "AttributeWithoutPrefix", reader, attribute, fullValue);
            return null;
        }
        String prefix = fullValue.substring(0, fullValue.indexOf(":"));
        String name = fullValue.substring(fullValue.indexOf(":") + 1);
        String nsUri = reader.getNamespaceContext().getNamespaceURI(prefix);
        if (nsUri == null) {
            this.error(monitor, "AttributeUnrecognizedNamespace", reader, attribute, fullValue);
            return null;
        }
        return new QName(nsUri, name, prefix);
    }

    private void error(Monitor monitor, String message, Object model, Object ... messageParameters) {
        if (monitor != null) {
            Problem problem = monitor.createProblem(this.getClass().getName(), "impl-bpel-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            monitor.problem(problem);
        }
    }
}

