/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.impl.hotupdate;

import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.tuscany.sca.Node;
import org.apache.tuscany.sca.impl.NodeImpl;
import org.apache.tuscany.sca.impl.hotupdate.LastModifiedTracker;

public class HotUpdater {
    private final Node node;
    private final File domainDir;
    private final Map<String, LastModifiedTracker> contributions = new HashMap<String, LastModifiedTracker>();
    private final ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);

    public HotUpdater(Node node, File domainDir) {
        this.node = node;
        this.domainDir = domainDir;
        Runnable checker = new Runnable(){

            @Override
            public void run() {
                HotUpdater.this.check();
            }
        };
        this.scheduler.scheduleAtFixedRate(checker, 10L, 10L, TimeUnit.SECONDS);
    }

    private void check() {
        HashSet<String> found = new HashSet<String>();
        for (File f : this.domainDir.listFiles()) {
            if (!f.isDirectory() || f.getName().startsWith(".")) continue;
            found.add(f.getName());
            LastModifiedTracker scanner = this.contributions.get(f.getName());
            if (scanner == null) {
                this.contributions.put(f.getName(), new LastModifiedTracker(f));
                continue;
            }
            if (!scanner.checkModified()) continue;
            this.updatedContribution(f);
        }
        HashSet<String> removed = new HashSet<String>(this.contributions.keySet());
        removed.removeAll(found);
        for (String curi : removed) {
            this.removedContribution(curi);
        }
    }

    private void removedContribution(String curi) {
        try {
            ((NodeImpl)this.node).uninstallContribution(curi, true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.contributions.remove(curi);
    }

    private void updatedContribution(File f) {
        try {
            ((NodeImpl)this.node).updateContribution(f.getName(), f.toURI().toURL().toString(), null, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void newContribution(File f) {
        try {
            this.node.installContribution(f.getName(), f.toURI().toURL().toString(), null, null);
            this.node.startDeployables(f.getName());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

