/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.definitions.xml;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessorExtensionPoint;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.definitions.Definitions;
import org.apache.tuscany.sca.definitions.DefinitionsFactory;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.policy.BindingType;
import org.apache.tuscany.sca.policy.ExternalAttachment;
import org.apache.tuscany.sca.policy.ImplementationType;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.IntentMap;
import org.apache.tuscany.sca.policy.PolicyFactory;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.Qualifier;

public class DefinitionsProcessor
extends BaseStAXArtifactProcessor
implements StAXArtifactProcessor<Definitions> {
    private ExtensionPointRegistry registry;
    private StAXArtifactProcessorExtensionPoint processors;
    private StAXArtifactProcessor<Object> extensionProcessor;
    private DefinitionsFactory definitionsFactory;
    private PolicyFactory policyFactory;
    public static final String SCA11_NS = "http://docs.oasis-open.org/ns/opencsa/sca/200912";
    public static final String BINDING = "binding";
    public static final String IMPLEMENTATION = "implementation";
    public static final String DEFINITIONS = "definitions";
    public static final QName DEFINITIONS_QNAME = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "definitions");
    public static final String TARGET_NAMESPACE = "targetNamespace";
    public static final String NAME = "name";

    public DefinitionsProcessor(ExtensionPointRegistry registry, StAXArtifactProcessor<Object> extensionProcessor) {
        this.registry = registry;
        this.extensionProcessor = extensionProcessor;
        this.processors = registry.getExtensionPoint(StAXArtifactProcessorExtensionPoint.class);
        FactoryExtensionPoint factoryExtensionPoint = registry.getExtensionPoint(FactoryExtensionPoint.class);
        this.definitionsFactory = factoryExtensionPoint.getFactory(DefinitionsFactory.class);
        this.policyFactory = factoryExtensionPoint.getFactory(PolicyFactory.class);
    }

    @Override
    public Definitions read(XMLStreamReader reader, ProcessorContext context) throws ContributionReadException, XMLStreamException {
        QName name = null;
        Definitions definitions = null;
        String targetNamespace = null;
        while (reader.hasNext()) {
            int event = reader.getEventType();
            switch (event) {
                case 1: {
                    name = reader.getName();
                    if (DEFINITIONS_QNAME.equals(name)) {
                        definitions = this.definitionsFactory.createDefinitions();
                        targetNamespace = this.getURIString(reader, TARGET_NAMESPACE);
                        definitions.setTargetNamespace(targetNamespace);
                        break;
                    }
                    Object extension = this.extensionProcessor.read(reader, context);
                    if (extension == null) break;
                    if (extension instanceof Intent) {
                        Intent intent = (Intent)extension;
                        intent.setName(new QName(targetNamespace, intent.getName().getLocalPart()));
                        definitions.getIntents().add(intent);
                        for (Intent i : intent.getQualifiedIntents()) {
                            i.setName(new QName(targetNamespace, i.getName().getLocalPart()));
                        }
                        break;
                    }
                    if (extension instanceof PolicySet) {
                        PolicySet policySet = (PolicySet)extension;
                        policySet.setName(new QName(targetNamespace, policySet.getName().getLocalPart()));
                        definitions.getPolicySets().add(policySet);
                        break;
                    }
                    if (extension instanceof Binding) {
                        Binding binding = (Binding)extension;
                        definitions.getBindings().add(binding);
                        break;
                    }
                    if (extension instanceof BindingType) {
                        definitions.getBindingTypes().add((BindingType)extension);
                        break;
                    }
                    if (extension instanceof ImplementationType) {
                        definitions.getImplementationTypes().add((ImplementationType)extension);
                        break;
                    }
                    if (!(extension instanceof ExternalAttachment)) break;
                    definitions.getExternalAttachments().add((ExternalAttachment)extension);
                    break;
                }
                case 4: {
                    break;
                }
                case 2: {
                    name = reader.getName();
                    if (!DEFINITIONS_QNAME.equals(name)) break;
                    return definitions;
                }
            }
            if (!reader.hasNext()) continue;
            reader.next();
        }
        return definitions;
    }

    @Override
    public void write(Definitions definitions, XMLStreamWriter writer, ProcessorContext context) throws ContributionWriteException, XMLStreamException {
        this.writeStartDocument(writer, SCA11_NS, DEFINITIONS, new BaseStAXArtifactProcessor.XAttr(TARGET_NAMESPACE, definitions.getTargetNamespace()));
        for (Intent policyIntent : definitions.getIntents()) {
            this.extensionProcessor.write(policyIntent, writer, context);
        }
        for (PolicySet policySet : definitions.getPolicySets()) {
            this.extensionProcessor.write(policySet, writer, context);
        }
        for (Binding binding : definitions.getBindings()) {
            this.extensionProcessor.write(binding, writer, context);
        }
        for (BindingType bindingType : definitions.getBindingTypes()) {
            this.extensionProcessor.write(bindingType, writer, context);
        }
        for (ImplementationType implType : definitions.getImplementationTypes()) {
            this.extensionProcessor.write(implType, writer, context);
        }
        this.writeEndDocument(writer);
    }

    @Override
    public void resolve(Definitions scaDefns, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        ArrayList<Intent> intents = new ArrayList<Intent>();
        ArrayList<PolicySet> policySets = new ArrayList<PolicySet>();
        ArrayList<PolicySet> referredPolicySets = new ArrayList<PolicySet>();
        for (Intent intent : scaDefns.getIntents()) {
            intents.add(intent);
            resolver.addModel(intent, context);
            for (Intent i : intent.getQualifiedIntents()) {
                intents.add(i);
                resolver.addModel(i, context);
            }
        }
        for (PolicySet policySet : scaDefns.getPolicySets()) {
            if (policySet.getReferencedPolicySets().isEmpty()) {
                policySets.add(policySet);
            } else {
                referredPolicySets.add(policySet);
            }
            resolver.addModel(policySet, context);
        }
        for (BindingType bindingType : scaDefns.getBindingTypes()) {
            resolver.addModel(bindingType, context);
        }
        for (ImplementationType implType : scaDefns.getImplementationTypes()) {
            resolver.addModel(implType, context);
        }
        for (Intent policyIntent : intents) {
            this.extensionProcessor.resolve(policyIntent, resolver, context);
        }
        for (PolicySet policySet : policySets) {
            this.extensionProcessor.resolve(policySet, resolver, context);
        }
        for (PolicySet policySet : referredPolicySets) {
            this.extensionProcessor.resolve(policySet, resolver, context);
        }
        for (Binding binding : scaDefns.getBindings()) {
            this.extensionProcessor.resolve(binding, resolver, context);
        }
        for (BindingType bindingType : scaDefns.getBindingTypes()) {
            this.extensionProcessor.resolve(bindingType, resolver, context);
            if (this.processors.getProcessor(bindingType.getType()) != null) continue;
            Monitor.error(context.getMonitor(), (Object)this, "org.apache.tuscany.sca.definitions.xml.definitions-xml-validation-messages", "BindingTypeNotFound", bindingType.getType().toString());
        }
        for (ImplementationType implementationType : scaDefns.getImplementationTypes()) {
            this.extensionProcessor.resolve(implementationType, resolver, context);
            if (this.processors.getProcessor(implementationType.getType()) != null) continue;
            Monitor.error(context.getMonitor(), (Object)this, "org.apache.tuscany.sca.definitions.xml.definitions-xml-validation-messages", "ImplementationTypeNotFound", implementationType.getType().toString());
        }
        ArrayList<PolicySet> copy = new ArrayList<PolicySet>(scaDefns.getPolicySets());
        for (PolicySet policySet : copy) {
            for (IntentMap intentMap : policySet.getIntentMaps()) {
                for (Qualifier qualifier : intentMap.getQualifiers()) {
                    PolicySet qualifiedPolicySet = this.policyFactory.createPolicySet();
                    qualifiedPolicySet.setAppliesTo(policySet.getAppliesTo());
                    qualifiedPolicySet.setAppliesToXPathExpression(policySet.getAttachToXPathExpression());
                    qualifiedPolicySet.setAttachTo(policySet.getAttachTo());
                    qualifiedPolicySet.setAttachToXPathExpression(policySet.getAttachToXPathExpression());
                    String qualifiedLocalName = policySet.getName().getLocalPart() + "." + qualifier.getIntent().getName().getLocalPart();
                    qualifiedPolicySet.setName(new QName(policySet.getName().getNamespaceURI(), qualifiedLocalName));
                    qualifiedPolicySet.getProvidedIntents().clear();
                    qualifiedPolicySet.getProvidedIntents().add(qualifier.getIntent());
                    qualifiedPolicySet.getPolicies().clear();
                    qualifiedPolicySet.getPolicies().addAll(qualifier.getPolicies());
                    scaDefns.getPolicySets().add(qualifiedPolicySet);
                }
            }
        }
    }

    @Override
    public QName getArtifactType() {
        return DEFINITIONS_QNAME;
    }

    @Override
    public Class<Definitions> getModelType() {
        return Definitions.class;
    }
}

