/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.definitions.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.definitions.Definitions;
import org.apache.tuscany.sca.definitions.DefinitionsBuilder;
import org.apache.tuscany.sca.definitions.DefinitionsBuilderException;
import org.apache.tuscany.sca.policy.BindingType;
import org.apache.tuscany.sca.policy.ExtensionType;
import org.apache.tuscany.sca.policy.ImplementationType;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.IntentMap;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.Qualifier;

public class DefinitionsBuilderImpl
implements DefinitionsBuilder {
    @Override
    public void build(Definitions scaDefns) throws DefinitionsBuilderException {
        HashMap<QName, Intent> definedIntents = new HashMap<QName, Intent>();
        for (Intent intent : scaDefns.getIntents()) {
            definedIntents.put(intent.getName(), intent);
        }
        HashMap<QName, PolicySet> definedPolicySets = new HashMap<QName, PolicySet>();
        for (PolicySet policySet : scaDefns.getPolicySets()) {
            definedPolicySets.put(policySet.getName(), policySet);
        }
        HashMap<QName, BindingType> definedBindingTypes = new HashMap<QName, BindingType>();
        for (BindingType bindingType : scaDefns.getBindingTypes()) {
            definedBindingTypes.put(bindingType.getType(), bindingType);
        }
        HashMap<QName, ImplementationType> definedImplTypes = new HashMap<QName, ImplementationType>();
        for (ImplementationType implType : scaDefns.getImplementationTypes()) {
            definedImplTypes.put(implType.getType(), implType);
        }
        scaDefns.getIntents().clear();
        scaDefns.getPolicySets().clear();
        scaDefns.getBindingTypes().clear();
        scaDefns.getImplementationTypes().clear();
        scaDefns.getIntents().addAll(definedIntents.values());
        scaDefns.getPolicySets().addAll(definedPolicySets.values());
        scaDefns.getBindingTypes().addAll(definedBindingTypes.values());
        scaDefns.getImplementationTypes().addAll(definedImplTypes.values());
        this.buildPolicyIntents(scaDefns, definedIntents);
        this.buildPolicySets(scaDefns, definedPolicySets, definedIntents);
        this.buildBindingTypes(scaDefns, definedBindingTypes, definedIntents);
        this.buildImplementationTypes(scaDefns, definedImplTypes, definedIntents);
    }

    private void buildBindingTypes(Definitions scaDefns, Map<QName, BindingType> definedBindingTypes, Map<QName, Intent> definedIntents) throws DefinitionsBuilderException {
        for (BindingType bindingType : scaDefns.getBindingTypes()) {
            this.buildAlwaysProvidedIntents(bindingType, definedIntents);
            this.buildMayProvideIntents(bindingType, definedIntents);
        }
    }

    private void buildImplementationTypes(Definitions scaDefns, Map<QName, ImplementationType> definedImplTypes, Map<QName, Intent> definedIntents) throws DefinitionsBuilderException {
        for (ImplementationType implType : scaDefns.getImplementationTypes()) {
            this.buildAlwaysProvidedIntents(implType, definedIntents);
            this.buildMayProvideIntents(implType, definedIntents);
        }
    }

    private void buildPolicyIntents(Definitions scaDefns, Map<QName, Intent> definedIntents) throws DefinitionsBuilderException {
        for (Intent policyIntent : scaDefns.getIntents()) {
            if (!policyIntent.getRequiredIntents().isEmpty()) {
                this.buildProfileIntent(policyIntent, definedIntents);
            }
            if (policyIntent.getQualifiedIntents().isEmpty()) continue;
            this.buildQualifiedIntent(policyIntent, definedIntents);
        }
    }

    private void buildPolicySets(Definitions scaDefns, Map<QName, PolicySet> definedPolicySets, Map<QName, Intent> definedIntents) throws DefinitionsBuilderException {
        for (PolicySet policySet : scaDefns.getPolicySets()) {
            this.buildProvidedIntents(policySet, definedIntents);
            this.buildIntentsInMappedPolicies(policySet, definedIntents);
            this.buildReferredPolicySets(policySet, definedPolicySets);
        }
        for (PolicySet policySet : scaDefns.getPolicySets()) {
            for (PolicySet referredPolicySet : policySet.getReferencedPolicySets()) {
                this.includeReferredPolicySets(policySet, referredPolicySet);
            }
        }
    }

    private void buildProfileIntent(Intent policyIntent, Map<QName, Intent> definedIntents) throws DefinitionsBuilderException {
        if (policyIntent != null) {
            ArrayList<Intent> requiredIntents = new ArrayList<Intent>();
            for (Intent requiredIntent : policyIntent.getRequiredIntents()) {
                if (requiredIntent.isUnresolved()) {
                    Intent resolvedRequiredIntent = definedIntents.get(requiredIntent.getName());
                    if (resolvedRequiredIntent != null) {
                        requiredIntents.add(resolvedRequiredIntent);
                        continue;
                    }
                    throw new DefinitionsBuilderException("Required Intent - " + requiredIntent + " not found for ProfileIntent " + policyIntent);
                }
                requiredIntents.add(requiredIntent);
            }
            policyIntent.getRequiredIntents().clear();
            policyIntent.getRequiredIntents().addAll(requiredIntents);
        }
    }

    private void buildQualifiedIntent(Intent policyIntent, Map<QName, Intent> definedIntents) throws DefinitionsBuilderException {
    }

    private void buildAlwaysProvidedIntents(ExtensionType extensionType, Map<QName, Intent> definedIntents) throws DefinitionsBuilderException {
        if (extensionType != null) {
            ArrayList<Intent> alwaysProvided = new ArrayList<Intent>();
            for (Intent providedIntent : extensionType.getAlwaysProvidedIntents()) {
                if (providedIntent.isUnresolved()) {
                    Intent resolvedProvidedIntent = definedIntents.get(providedIntent.getName());
                    if (resolvedProvidedIntent != null) {
                        alwaysProvided.add(resolvedProvidedIntent);
                        continue;
                    }
                    throw new DefinitionsBuilderException("Always Provided Intent - " + providedIntent + " not found for ExtensionType " + extensionType);
                }
                alwaysProvided.add(providedIntent);
            }
            extensionType.getAlwaysProvidedIntents().clear();
            extensionType.getAlwaysProvidedIntents().addAll(alwaysProvided);
        }
    }

    private void buildMayProvideIntents(ExtensionType extensionType, Map<QName, Intent> definedIntents) throws DefinitionsBuilderException {
        if (extensionType != null) {
            ArrayList<Intent> mayProvide = new ArrayList<Intent>();
            for (Intent providedIntent : extensionType.getMayProvidedIntents()) {
                if (providedIntent.isUnresolved()) {
                    Intent resolvedProvidedIntent = definedIntents.get(providedIntent.getName());
                    if (resolvedProvidedIntent != null) {
                        mayProvide.add(resolvedProvidedIntent);
                        continue;
                    }
                    throw new DefinitionsBuilderException("May Provide Intent - " + providedIntent + " not found for ExtensionType " + extensionType);
                }
                mayProvide.add(providedIntent);
            }
            extensionType.getMayProvidedIntents().clear();
            extensionType.getMayProvidedIntents().addAll(mayProvide);
        }
    }

    private void buildProvidedIntents(PolicySet policySet, Map<QName, Intent> definedIntents) throws DefinitionsBuilderException {
        if (policySet != null) {
            ArrayList<Intent> providedIntents = new ArrayList<Intent>();
            for (Intent providedIntent : policySet.getProvidedIntents()) {
                if (providedIntent.isUnresolved()) {
                    Intent resolvedProvidedIntent = definedIntents.get(providedIntent.getName());
                    if (resolvedProvidedIntent != null) {
                        providedIntents.add(resolvedProvidedIntent);
                        continue;
                    }
                    throw new DefinitionsBuilderException("Provided Intent - " + providedIntent + " not found for PolicySet " + policySet);
                }
                providedIntents.add(providedIntent);
            }
            policySet.getProvidedIntents().clear();
            policySet.getProvidedIntents().addAll(providedIntents);
        }
    }

    private void buildIntentsInMappedPolicies(PolicySet policySet, Map<QName, Intent> definedIntents) throws DefinitionsBuilderException {
        for (IntentMap intentMap : policySet.getIntentMaps()) {
            for (Qualifier qualifier : intentMap.getQualifiers()) {
                Intent mappedIntent = qualifier.getIntent();
                if (!mappedIntent.isUnresolved()) continue;
                Intent resolvedMappedIntent = definedIntents.get(mappedIntent.getName());
                if (resolvedMappedIntent != null) {
                    qualifier.setIntent(resolvedMappedIntent);
                    continue;
                }
                throw new DefinitionsBuilderException("Mapped Intent - " + mappedIntent + " not found for PolicySet " + policySet);
            }
        }
    }

    private void buildReferredPolicySets(PolicySet policySet, Map<QName, PolicySet> definedPolicySets) throws DefinitionsBuilderException {
        ArrayList<PolicySet> referredPolicySets = new ArrayList<PolicySet>();
        for (PolicySet referredPolicySet : policySet.getReferencedPolicySets()) {
            if (referredPolicySet.isUnresolved()) {
                PolicySet resolvedReferredPolicySet = definedPolicySets.get(referredPolicySet.getName());
                if (resolvedReferredPolicySet != null) {
                    referredPolicySets.add(resolvedReferredPolicySet);
                    continue;
                }
                throw new DefinitionsBuilderException("Referred PolicySet - " + referredPolicySet + "not found for PolicySet - " + policySet);
            }
            referredPolicySets.add(referredPolicySet);
        }
        policySet.getReferencedPolicySets().clear();
        policySet.getReferencedPolicySets().addAll(referredPolicySets);
    }

    private void includeReferredPolicySets(PolicySet policySet, PolicySet referredPolicySet) {
        for (PolicySet furtherReferredPolicySet : referredPolicySet.getReferencedPolicySets()) {
            this.includeReferredPolicySets(referredPolicySet, furtherReferredPolicySet);
        }
        policySet.getPolicies().addAll(referredPolicySet.getPolicies());
        policySet.getIntentMaps().addAll(referredPolicySet.getIntentMaps());
    }
}

