/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.xml;

import javax.xml.stream.XMLStreamReader;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.databinding.BaseTransformer;
import org.apache.tuscany.sca.databinding.DataPipe;
import org.apache.tuscany.sca.databinding.PullTransformer;
import org.apache.tuscany.sca.databinding.TransformationContext;
import org.apache.tuscany.sca.databinding.TransformationException;
import org.apache.tuscany.sca.databinding.xml.DOMDataBinding;
import org.apache.tuscany.sca.databinding.xml.SAX2DOMPipe;
import org.apache.tuscany.sca.databinding.xml.XMLStreamReader2SAX;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;

public class XMLStreamReader2Node
extends BaseTransformer<XMLStreamReader, Node>
implements PullTransformer<XMLStreamReader, Node> {
    private XMLStreamReader2SAX stax2sax;
    private SAX2DOMPipe sax2domPipe;

    public XMLStreamReader2Node(ExtensionPointRegistry registry) {
        this.stax2sax = new XMLStreamReader2SAX(registry);
        this.sax2domPipe = new SAX2DOMPipe(registry);
    }

    @Override
    public Node transform(XMLStreamReader source, TransformationContext context) {
        try {
            if (source == null) {
                return null;
            }
            DataPipe<ContentHandler, Node> pipe = this.sax2domPipe.newInstance();
            this.stax2sax.transform(source, pipe.getSink(), context);
            Node node = pipe.getResult();
            source.close();
            if (node instanceof Document) {
                Document doc = (Document)node;
                return DOMDataBinding.adjustElementName(context, doc.getDocumentElement());
            }
            return node;
        }
        catch (Exception e) {
            throw new TransformationException(e);
        }
    }

    @Override
    protected Class<XMLStreamReader> getSourceType() {
        return XMLStreamReader.class;
    }

    @Override
    protected Class<Node> getTargetType() {
        return Node.class;
    }

    @Override
    public int getWeight() {
        return 40;
    }
}

