/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.xml;

import javax.xml.namespace.QName;
import org.apache.tuscany.sca.common.xml.dom.DOMHelper;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.databinding.BaseDataBinding;
import org.apache.tuscany.sca.databinding.TransformationContext;
import org.apache.tuscany.sca.databinding.WrapperHandler;
import org.apache.tuscany.sca.databinding.xml.DOMWrapperHandler;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.util.XMLType;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class DOMDataBinding
extends BaseDataBinding {
    public static final String NAME = Node.class.getName();
    public static final String ROOT_NAMESPACE = "http://tuscany.apache.org/xmlns/sca/databinding/dom/1.0";
    public static final QName ROOT_ELEMENT = new QName("http://tuscany.apache.org/xmlns/sca/databinding/dom/1.0", "root");
    private DOMHelper domHelper;

    public DOMDataBinding(ExtensionPointRegistry registry) {
        super(NAME, Node.class);
        this.domHelper = DOMHelper.getInstance(registry);
    }

    @Override
    public WrapperHandler getWrapperHandler() {
        return new DOMWrapperHandler(this.domHelper);
    }

    @Override
    public Object copy(Object source, DataType dataType, DataType targetDataType, Operation operation, Operation targetOperation) {
        if (Node.class.isAssignableFrom(source.getClass())) {
            Node nodeSource = (Node)source;
            return nodeSource.cloneNode(true);
        }
        return super.copy(source, dataType, targetDataType, operation, targetOperation);
    }

    @Override
    public boolean introspect(DataType type, Operation operation) {
        if (Node.class.isAssignableFrom(type.getPhysical())) {
            if (type.getLogical() == null) {
                type.setLogical(new XMLType(ROOT_ELEMENT, null));
            }
            type.setDataBinding(NAME);
            return true;
        }
        return false;
    }

    public static Element adjustElementName(TransformationContext context, Element element) {
        if (context != null) {
            Object logical;
            DataType dataType = context.getTargetDataType();
            Object v0 = logical = dataType == null ? null : dataType.getLogical();
            if (!(logical instanceof XMLType)) {
                return element;
            }
            XMLType xmlType = logical;
            QName name = new QName(element.getNamespaceURI(), element.getLocalName());
            if (xmlType.isElement() && !xmlType.getElementName().equals(name)) {
                QName newName = xmlType.getElementName();
                String prefix = newName.getPrefix();
                String qname = newName.getLocalPart();
                if (prefix != null && !prefix.equals("")) {
                    qname = prefix + ":" + qname;
                }
                Document doc = element.getOwnerDocument();
                Element newElement = doc.createElementNS(newName.getNamespaceURI(), qname);
                NamedNodeMap attrs = element.getAttributes();
                for (int i = 0; i < attrs.getLength(); ++i) {
                    Attr attr = (Attr)doc.importNode(attrs.item(i), true);
                    newElement.getAttributes().setNamedItem(attr);
                }
                while (element.hasChildNodes()) {
                    newElement.appendChild(element.getFirstChild());
                }
                if (element.getParentNode() != null) {
                    element.getParentNode().replaceChild(newElement, element);
                }
                return newElement;
            }
        }
        return element;
    }
}

