/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.impl;

import java.util.HashMap;
import java.util.Map;
import org.apache.tuscany.sca.databinding.TransformationContext;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Operation;

public class TransformationContextImpl
implements TransformationContext {
    private DataType sourceDataType;
    private DataType targetDataType;
    private final Map<String, Object> metadata = new HashMap<String, Object>();

    public TransformationContextImpl() {
    }

    public TransformationContextImpl(DataType sourceDataType, DataType targetDataType, Map<String, Object> metadata) {
        this.sourceDataType = sourceDataType;
        this.targetDataType = targetDataType;
        if (metadata != null) {
            this.metadata.putAll(metadata);
        }
    }

    @Override
    public DataType getSourceDataType() {
        return this.sourceDataType;
    }

    @Override
    public DataType getTargetDataType() {
        return this.targetDataType;
    }

    @Override
    public void setSourceDataType(DataType sourceDataType) {
        this.sourceDataType = sourceDataType;
    }

    @Override
    public void setTargetDataType(DataType targetDataType) {
        this.targetDataType = targetDataType;
    }

    @Override
    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    @Override
    public Operation getSourceOperation() {
        return (Operation)this.metadata.get("source.operation");
    }

    @Override
    public void setSourceOperation(Operation sourceOperation) {
        this.metadata.put("source.operation", sourceOperation);
    }

    @Override
    public Operation getTargetOperation() {
        return (Operation)this.metadata.get("target.operation");
    }

    @Override
    public void setTargetOperation(Operation targetOperation) {
        this.metadata.put("target.operation", targetOperation);
    }
}

