/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.databinding.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;

public class DirectedGraph<V, E>
implements Cloneable {
    private static final Logger logger = Logger.getLogger(DirectedGraph.class.getName());
    private final Map<V, Vertex> vertices = new HashMap<V, Vertex>();
    private final Map<VertexPair, Path> paths = new ConcurrentHashMap<VertexPair, Path>();
    private final Path NULL_PATH = new Path();

    public void addEdge(V source, V target, E edgeValue, int weight, boolean publicEdge) {
        Vertex t;
        Vertex s;
        Edge edge = this.getEdge(source, target);
        if (edge != null) {
            if (edge.weight > weight) {
                logger.fine("An edge exists with higher weight: " + edge);
                this.removeEdge(edge);
            } else {
                logger.fine("An edge exists with lower weight: " + edge);
                return;
            }
        }
        if ((s = this.getVertex(source)) == null) {
            s = new Vertex(source);
            this.vertices.put((Vertex)source, s);
        }
        if ((t = this.getVertex(target)) == null) {
            t = new Vertex(target);
            this.vertices.put((Vertex)target, t);
        }
        edge = new Edge(s, t, edgeValue, weight, publicEdge);
        s.outEdges.put(t, edge);
        t.inEdges.put(s, edge);
    }

    public void addEdge(V soure, V target) {
        this.addEdge(soure, target, null, 0, true);
    }

    public Vertex getVertex(V source) {
        Vertex s = this.vertices.get(source);
        return s;
    }

    public boolean removeEdge(V source, V target) {
        Vertex s = this.getVertex(source);
        if (s == null) {
            return false;
        }
        Vertex t = this.getVertex(target);
        if (t == null) {
            return false;
        }
        return s.outEdges.remove(t) != null && t.inEdges.remove(s) != null;
    }

    public void removeEdge(Edge edge) {
        edge.sourceVertex.outEdges.remove(edge.targetVertex);
        edge.targetVertex.inEdges.remove(edge.sourceVertex);
    }

    public void removeVertex(Vertex vertex) {
        this.vertices.remove(vertex.getValue());
        for (Edge e : new ArrayList(vertex.outEdges.values())) {
            this.removeEdge(e);
        }
        for (Edge e : new ArrayList(vertex.inEdges.values())) {
            this.removeEdge(e);
        }
    }

    public Edge getEdge(Vertex source, Vertex target) {
        return (Edge)source.outEdges.get(target);
    }

    public Edge getEdge(V source, V target) {
        Vertex sv = this.getVertex(source);
        if (sv == null) {
            return null;
        }
        Vertex tv = this.getVertex(target);
        if (tv == null) {
            return null;
        }
        return this.getEdge(this.getVertex(source), this.getVertex(target));
    }

    public Path getShortestPath(V sourceValue, V targetValue) {
        Vertex source = this.getVertex(sourceValue);
        if (source == null) {
            return null;
        }
        Vertex target = this.getVertex(targetValue);
        if (target == null) {
            return null;
        }
        VertexPair pair = new VertexPair(source, target);
        Path path = null;
        if (this.paths.containsKey(pair)) {
            path = this.paths.get(pair);
            return path == this.NULL_PATH ? null : path;
        }
        Edge direct = this.getEdge(source, target);
        path = new Path();
        if (direct != null) {
            path.addEdge(direct);
            this.paths.put(pair, path);
            return path;
        }
        HashMap<Vertex, Node> nodes = new HashMap<Vertex, Node>();
        for (Vertex v : this.vertices.values()) {
            Node node = new Node(v);
            if (v == source) {
                node.distance = 0L;
            }
            nodes.put(v, node);
        }
        HashSet<Node> otherNodes = new HashSet<Node>(nodes.values());
        HashSet<Node> nodesOnPath = new HashSet<Node>();
        Node nextNode = null;
        while (!otherNodes.isEmpty()) {
            nextNode = this.extractMin(otherNodes);
            if (nextNode.vertex == target) {
                path = this.getPath(nextNode);
                this.paths.put(pair, path);
                return path == this.NULL_PATH ? null : path;
            }
            nodesOnPath.add(nextNode);
            for (Edge edge : nextNode.vertex.outEdges.values()) {
                Node adjacentNode = (Node)nodes.get(edge.targetVertex);
                if (!edge.isPublic() && edge.getTargetVertex() != target || nextNode.distance + (long)edge.weight >= adjacentNode.distance) continue;
                adjacentNode.distance = nextNode.distance + (long)edge.weight;
                adjacentNode.previous = nextNode;
            }
        }
        this.paths.put(pair, this.NULL_PATH);
        return null;
    }

    private Node extractMin(Set<Node> nodes) {
        Node node = Collections.min(nodes);
        nodes.remove(node);
        return node;
    }

    private Path getPath(Node t) {
        if (t.distance == Integer.MAX_VALUE) {
            return this.NULL_PATH;
        }
        Path path = new Path();
        Node u = t;
        while (u.previous != null) {
            Edge edge = this.getEdge(u.previous.vertex, u.vertex);
            path.addEdge(edge);
            u = u.previous;
        }
        return path;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (Vertex v : this.vertices.values()) {
            sb.append(v.outEdges.values()).append("\n");
        }
        return sb.toString();
    }

    public Map<V, Vertex> getVertices() {
        return this.vertices;
    }

    public void addGraph(DirectedGraph<V, E> otherGraph) {
        for (Vertex v : otherGraph.vertices.values()) {
            for (Edge e : v.outEdges.values()) {
                this.addEdge(e.sourceVertex.value, e.targetVertex.value, e.value, e.weight, true);
            }
        }
    }

    private Vertex getFirst() {
        for (Vertex v : this.vertices.values()) {
            if (!v.inEdges.isEmpty()) continue;
            return v;
        }
        if (!this.vertices.isEmpty()) {
            throw new IllegalArgumentException("Circular ordering has been detected: " + this.toString());
        }
        return null;
    }

    public List<V> topologicalSort(boolean readOnly) {
        Vertex v;
        DirectedGraph graph = !readOnly ? this : (DirectedGraph)this.clone();
        ArrayList list = new ArrayList();
        while ((v = graph.getFirst()) != null) {
            list.add(v.getValue());
            graph.removeVertex(v);
        }
        return list;
    }

    public Object clone() {
        DirectedGraph<V, E> copy = new DirectedGraph<V, E>();
        copy.addGraph(this);
        return copy;
    }

    public final class Path {
        private List<Edge> edges = new LinkedList<Edge>();
        private int weight;

        public int getWeight() {
            return this.weight;
        }

        public List<Edge> getEdges() {
            return this.edges;
        }

        public void addEdge(Edge edge) {
            this.edges.add(0, edge);
            this.weight += edge.weight;
        }

        public String toString() {
            return this.edges + ", " + this.weight;
        }
    }

    private final class Node
    implements Comparable<Node> {
        private long distance = Integer.MAX_VALUE;
        private Node previous;
        private Vertex vertex;

        private Node(Vertex vertex) {
            this.vertex = vertex;
        }

        @Override
        public int compareTo(Node o) {
            return this.distance > o.distance ? 1 : (this.distance == o.distance ? 0 : -1);
        }
    }

    public final class Edge {
        private Vertex sourceVertex;
        private Vertex targetVertex;
        private E value;
        private int weight;
        private boolean pub = true;

        public Edge(Vertex source, Vertex target, E value, int weight, boolean pub) {
            this.sourceVertex = source;
            this.targetVertex = target;
            this.value = value;
            this.weight = weight;
            this.pub = pub;
        }

        public String toString() {
            return this.sourceVertex + "->" + this.targetVertex + "[" + this.value + "," + this.weight + "]";
        }

        public E getValue() {
            return this.value;
        }

        public void setValue(E value) {
            this.value = value;
        }

        public Vertex getTargetVertex() {
            return this.targetVertex;
        }

        public void setTargetVertex(Vertex vertex) {
            this.targetVertex = vertex;
        }

        public int getWeight() {
            return this.weight;
        }

        public void setWeight(int weight) {
            this.weight = weight;
        }

        public Vertex getSourceVertex() {
            return this.sourceVertex;
        }

        public void setSourceVertex(Vertex sourceVertex) {
            this.sourceVertex = sourceVertex;
        }

        public boolean isPublic() {
            return this.pub;
        }

        public void setPublic(boolean pub) {
            this.pub = pub;
        }
    }

    public final class Vertex {
        private V value;
        private Map<Vertex, Edge> outEdges = new HashMap<Vertex, Edge>();
        private Map<Vertex, Edge> inEdges = new HashMap<Vertex, Edge>();

        private Vertex(V value) {
            this.value = value;
        }

        public String toString() {
            return "(" + this.value + ")";
        }

        public V getValue() {
            return this.value;
        }

        public Map<Vertex, Edge> getOutEdges() {
            return this.outEdges;
        }

        public Map<Vertex, Edge> getInEdges() {
            return this.inEdges;
        }
    }

    private final class VertexPair {
        private Vertex source;
        private Vertex target;

        private VertexPair(Vertex source, Vertex target) {
            this.source = source;
            this.target = target;
        }

        public boolean equals(Object object) {
            if (!VertexPair.class.isInstance(object)) {
                return false;
            }
            VertexPair pair = (VertexPair)object;
            return this.source == pair.source && this.target == pair.target;
        }

        public int hashCode() {
            int x = this.source == null ? 0 : this.source.hashCode();
            int y = this.target == null ? 0 : this.target.hashCode();
            return x ^ y;
        }
    }
}

