/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.scope.impl;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.tuscany.sca.core.scope.Scope;
import org.apache.tuscany.sca.core.scope.ScopeContainer;
import org.apache.tuscany.sca.core.scope.ScopeContainerFactory;
import org.apache.tuscany.sca.core.scope.ScopeRegistry;
import org.apache.tuscany.sca.core.scope.ScopedImplementationProvider;
import org.apache.tuscany.sca.core.scope.ScopedRuntimeComponent;
import org.apache.tuscany.sca.provider.ImplementationProvider;
import org.apache.tuscany.sca.runtime.RuntimeComponent;

public class ScopeRegistryImpl
implements ScopeRegistry {
    private final Map<Scope, ScopeContainerFactory> scopeCache = new ConcurrentHashMap<Scope, ScopeContainerFactory>();

    @Override
    public void register(ScopeContainerFactory factory) {
        this.scopeCache.put(factory.getScope(), factory);
    }

    @Override
    public ScopeContainer getScopeContainer(RuntimeComponent runtimeComponent) {
        if (!(runtimeComponent instanceof ScopedRuntimeComponent)) {
            return null;
        }
        ScopedRuntimeComponent component = (ScopedRuntimeComponent)runtimeComponent;
        if (component.getScopeContainer() != null) {
            return component.getScopeContainer();
        }
        ImplementationProvider implementationProvider = component.getImplementationProvider();
        if (implementationProvider instanceof ScopedImplementationProvider) {
            ScopedImplementationProvider provider = (ScopedImplementationProvider)implementationProvider;
            Scope scope = provider.getScope();
            if (scope == null) {
                scope = Scope.STATELESS;
            } else if (scope.equals(Scope.INVALID)) {
                return null;
            }
            ScopeContainerFactory factory = this.scopeCache.get(scope);
            ScopeContainer container = factory.createScopeContainer(component);
            component.setScopeContainer(container);
            return container;
        }
        return null;
    }
}

