/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.invocation.impl;

import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.ws.Holder;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.context.ThreadMessageContext;
import org.apache.tuscany.sca.core.context.ServiceReferenceExt;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.ParameterMode;
import org.apache.tuscany.sca.interfacedef.java.JavaOperation;
import org.apache.tuscany.sca.invocation.InvocationChain;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.invocation.MessageFactory;
import org.apache.tuscany.sca.runtime.Invocable;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;
import org.apache.tuscany.sca.runtime.RuntimeEndpointReference;
import org.oasisopen.sca.ServiceReference;
import org.oasisopen.sca.ServiceRuntimeException;

public class JDKInvocationHandler
implements InvocationHandler,
Serializable {
    private static final long serialVersionUID = -3366410500152201371L;
    protected MessageFactory messageFactory;
    protected Endpoint target;
    protected Invocable source;
    protected ServiceReferenceExt<?> callableReference;
    protected Class<?> businessInterface;
    protected boolean fixedWire = true;
    protected transient Map<Method, InvocationChain> chains = new IdentityHashMap<Method, InvocationChain>();

    public JDKInvocationHandler(MessageFactory messageFactory, Class<?> businessInterface, Invocable source) {
        this.messageFactory = messageFactory;
        this.source = source;
        this.businessInterface = businessInterface;
    }

    public JDKInvocationHandler(MessageFactory messageFactory, ServiceReference<?> callableReference) {
        this.messageFactory = messageFactory;
        this.callableReference = (ServiceReferenceExt)callableReference;
        if (callableReference != null) {
            this.businessInterface = callableReference.getBusinessInterface();
            this.source = this.callableReference.getEndpointReference();
        }
    }

    public Class<?> getBusinessInterface() {
        return this.businessInterface;
    }

    protected Object getCallbackID() {
        return null;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        InvocationChain chain;
        RuntimeEndpointReference epr;
        if (Object.class == method.getDeclaringClass()) {
            return this.invokeObjectMethod(method, args);
        }
        if (this.source == null) {
            throw new ServiceRuntimeException("No runtime source is available");
        }
        if (this.source instanceof RuntimeEndpointReference && (epr = (RuntimeEndpointReference)this.source).isOutOfDate()) {
            epr.rebuild();
            this.chains.clear();
        }
        if ((chain = this.getInvocationChain(method, this.source)) == null) {
            throw new IllegalArgumentException("No matching operation is found: " + method);
        }
        Object[] promotedArgs = JDKInvocationHandler.promoteHolderArgs(args);
        Operation sourceOp = chain.getSourceOperation();
        if (sourceOp != null) {
            promotedArgs = this.removeOutOnlyArgs(sourceOp, promotedArgs);
        }
        Object result = this.invoke(method, chain, promotedArgs, this.source);
        boolean voidReturnType = Void.TYPE == method.getReturnType();
        boolean holderPattern = false;
        Class<?>[] parameters = method.getParameterTypes();
        if (parameters != null) {
            int resultIdx = voidReturnType ? 0 : 1;
            for (int i = 0; i < parameters.length; ++i) {
                Class<?> parameterType = parameters[i];
                if (!JDKInvocationHandler.isHolder(parameterType)) continue;
                holderPattern = true;
                Holder holder = (Holder)args[i];
                Object[] results = (Object[])result;
                if (result == null) continue;
                holder.value = results[resultIdx++];
            }
        }
        if (holderPattern && result != null) {
            if (voidReturnType) {
                return null;
            }
            return ((Object[])result)[0];
        }
        return result;
    }

    protected Object invokeObjectMethod(Method method, Object[] args) throws Throwable {
        String name = method.getName();
        if ("toString".equals(name)) {
            return "[Proxy - " + this.toString() + "]";
        }
        if ("equals".equals(name)) {
            Object obj = args[0];
            if (obj == null) {
                return false;
            }
            if (!Proxy.isProxyClass(obj.getClass())) {
                return false;
            }
            return this.equals(Proxy.getInvocationHandler(obj));
        }
        if ("hashCode".equals(name)) {
            return this.hashCode();
        }
        return method.invoke((Object)this, new Object[0]);
    }

    private static boolean match(Operation operation, Method method) {
        if (operation instanceof JavaOperation) {
            JavaOperation javaOp = (JavaOperation)operation;
            Method m = javaOp.getJavaMethod();
            if (!method.getName().equals(m.getName())) {
                return false;
            }
            if (method.equals(m)) {
                return true;
            }
        } else if (!method.getName().equals(operation.getName())) {
            return false;
        }
        if (operation.getInterface().isRemotable()) {
            return true;
        }
        Class<?>[] params = method.getParameterTypes();
        DataType<List<DataType>> inputType = null;
        inputType = operation.isInputWrapperStyle() ? operation.getInputWrapper().getUnwrappedType() : operation.getInputType();
        List<DataType> types = inputType.getLogical();
        boolean matched = true;
        if (types.size() == params.length && method.getName().equals(operation.getName())) {
            for (int i = 0; i < params.length; ++i) {
                Class<?> clazz = params[i];
                Class<?> type = types.get(i).getPhysical();
                if (type == Object.class || type.isAssignableFrom(clazz)) continue;
                matched = false;
            }
        } else {
            matched = false;
        }
        return matched;
    }

    protected synchronized InvocationChain getInvocationChain(Method method, Invocable source) {
        if (source instanceof RuntimeEndpoint) {
            return source.getBindingInvocationChain();
        }
        if (this.fixedWire && this.chains.containsKey(method)) {
            return this.chains.get(method);
        }
        InvocationChain found = null;
        for (InvocationChain chain : source.getInvocationChains()) {
            Operation operation = chain.getSourceOperation();
            if (operation.isDynamic()) {
                operation.setName(method.getName());
                found = chain;
                break;
            }
            if (!JDKInvocationHandler.match(operation, method)) continue;
            found = chain;
            break;
        }
        if (this.fixedWire) {
            this.chains.put(method, found);
        }
        return found;
    }

    protected void setEndpoint(Endpoint endpoint) {
        this.target = endpoint;
    }

    protected Object invoke(Method method, InvocationChain chain, Object[] args, Invocable source) throws Throwable {
        return this.invoke(method, chain, args, source, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object invoke(Method method, InvocationChain chain, Object[] args, Invocable source, String msgID) throws Throwable {
        Message msg = this.messageFactory.createMessage();
        if (source instanceof RuntimeEndpointReference) {
            msg.setFrom((RuntimeEndpointReference)source);
        }
        if (this.target != null) {
            msg.setTo(this.target);
        } else if (source instanceof RuntimeEndpointReference) {
            msg.setTo(((RuntimeEndpointReference)source).getTargetEndpoint());
        }
        Invoker headInvoker = chain.getHeadInvoker();
        Operation operation = null;
        if (source instanceof RuntimeEndpoint) {
            for (InvocationChain c : source.getInvocationChains()) {
                Operation op = c.getTargetOperation();
                if (!method.getName().equals(op.getName())) continue;
                operation = op;
                break;
            }
        } else {
            operation = chain.getTargetOperation();
        }
        msg.setOperation(operation);
        msg.setBody(args);
        Message msgContext = ThreadMessageContext.getMessageContext();
        this.transferMessageHeaders(msg, msgContext);
        ThreadMessageContext.setMessageContext(msg);
        if (msgID != null) {
            msg.getHeaders().put("MESSAGE_ID", msgID);
        }
        try {
            Message resp = headInvoker.invoke(msg);
            Object body = resp.getBody();
            if (resp.isFault()) {
                throw (Throwable)body;
            }
            Object t = body;
            return t;
        }
        finally {
            ThreadMessageContext.setMessageContext(msgContext);
        }
    }

    protected void transferMessageHeaders(Message newMsg, Message oldMsg) {
        if (oldMsg == null) {
            return;
        }
        if (!oldMsg.getHeaders().isEmpty()) {
            newMsg.getHeaders().putAll(oldMsg.getHeaders());
        }
    }

    public ServiceReference<?> getCallableReference() {
        return this.callableReference;
    }

    public void setCallableReference(ServiceReference<?> callableReference) {
        this.callableReference = (ServiceReferenceExt)callableReference;
    }

    protected static Object[] promoteHolderArgs(Object[] args) {
        if (args == null) {
            return args;
        }
        Object[] promotedArgs = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            Object argument = args[i];
            if (argument == null) continue;
            promotedArgs[i] = JDKInvocationHandler.isHolder(argument) ? ((Holder)argument).value : args[i];
        }
        return promotedArgs;
    }

    Object[] removeOutOnlyArgs(Operation sourceOp, Object[] args) {
        if (args == null) {
            return args;
        }
        ArrayList<Object> retValList = new ArrayList<Object>();
        List<ParameterMode> parmList = sourceOp.getParameterModes();
        for (int i = 0; i < args.length; ++i) {
            if (parmList.get(i) == ParameterMode.OUT) continue;
            retValList.add(args[i]);
        }
        return retValList.toArray();
    }

    protected static boolean isHolder(Class testClass) {
        return testClass.getName().startsWith("javax.xml.ws.Holder");
    }

    protected static boolean isHolder(Object object) {
        String objectName = object.getClass().getName();
        return object instanceof Holder;
    }
}

