/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.context.impl;

import java.util.List;
import javax.security.auth.Subject;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.context.ThreadMessageContext;
import org.apache.tuscany.sca.core.context.impl.CallbackServiceReferenceImpl;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;
import org.oasisopen.sca.RequestContext;
import org.oasisopen.sca.ServiceReference;

public class RequestContextImpl
implements RequestContext {
    public RequestContextImpl(RuntimeComponent component) {
    }

    @Override
    public Subject getSecuritySubject() {
        Message msgContext = ThreadMessageContext.getMessageContext();
        if (msgContext == null) {
            return null;
        }
        Subject subject = null;
        for (Object header : msgContext.getHeaders().values()) {
            if (!(header instanceof Subject)) continue;
            subject = (Subject)header;
            break;
        }
        return subject;
    }

    @Override
    public String getServiceName() {
        Message msgContext = ThreadMessageContext.getMessageContext();
        if (msgContext != null && msgContext.getTo() != null) {
            return msgContext.getTo().getService().getName();
        }
        return null;
    }

    @Override
    public <B> ServiceReference<B> getServiceReference() {
        Message msgContext = ThreadMessageContext.getMessageContext();
        if (msgContext == null || msgContext.getTo() == null) {
            return null;
        }
        RuntimeEndpoint to = (RuntimeEndpoint)msgContext.getTo();
        RuntimeComponent component = (RuntimeComponent)to.getComponent();
        ServiceReference callableReference = component.getComponentContext().getServiceReference(null, to);
        return callableReference;
    }

    @Override
    public <CB> CB getCallback() {
        ServiceReference<CB> cb = this.getCallbackReference();
        if (cb == null) {
            return null;
        }
        return cb.getService();
    }

    @Override
    public <CB> ServiceReference<CB> getCallbackReference() {
        Message msgContext = ThreadMessageContext.getMessageContext();
        if (msgContext == null || msgContext.getTo() == null) {
            return null;
        }
        Endpoint to = msgContext.getTo();
        RuntimeComponentService service = (RuntimeComponentService)to.getService();
        RuntimeComponentReference callbackReference = (RuntimeComponentReference)service.getCallbackReference();
        if (callbackReference == null) {
            return null;
        }
        JavaInterface javaInterface = (JavaInterface)callbackReference.getInterfaceContract().getInterface();
        Class<?> javaClass = javaInterface.getJavaClass();
        List<EndpointReference> wires = callbackReference.getEndpointReferences();
        CallbackServiceReferenceImpl ref = new CallbackServiceReferenceImpl(javaClass, wires);
        return ref;
    }
}

