/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.core.assembly.impl;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.context.CompositeContext;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.core.scope.ScopeContainer;
import org.apache.tuscany.sca.core.scope.ScopeRegistry;
import org.apache.tuscany.sca.core.scope.ScopedRuntimeComponent;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.MonitorFactory;
import org.apache.tuscany.sca.provider.EndpointReferenceAsyncProvider;
import org.apache.tuscany.sca.provider.ImplementationProvider;
import org.apache.tuscany.sca.provider.ImplementationProviderFactory;
import org.apache.tuscany.sca.provider.PolicyProvider;
import org.apache.tuscany.sca.provider.PolicyProviderFactory;
import org.apache.tuscany.sca.provider.ProviderFactoryExtensionPoint;
import org.apache.tuscany.sca.provider.ReferenceBindingProvider;
import org.apache.tuscany.sca.provider.RuntimeProvider;
import org.apache.tuscany.sca.provider.ServiceBindingProvider;
import org.apache.tuscany.sca.runtime.ActivationException;
import org.apache.tuscany.sca.runtime.CompositeActivator;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;
import org.apache.tuscany.sca.runtime.RuntimeComponentService;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;
import org.apache.tuscany.sca.runtime.RuntimeEndpointReference;

public class CompositeActivatorImpl
implements CompositeActivator {
    final Logger logger = Logger.getLogger(CompositeActivatorImpl.class.getName());
    private final ScopeRegistry scopeRegistry;
    private final ProviderFactoryExtensionPoint providerFactories;
    private Monitor monitor;

    public CompositeActivatorImpl(ExtensionPointRegistry extensionPoints) {
        UtilityExtensionPoint utilities = extensionPoints.getExtensionPoint(UtilityExtensionPoint.class);
        this.scopeRegistry = utilities.getUtility(ScopeRegistry.class);
        this.providerFactories = extensionPoints.getExtensionPoint(ProviderFactoryExtensionPoint.class);
        this.monitor = utilities.getUtility(MonitorFactory.class).createMonitor();
    }

    @Override
    public void activate(CompositeContext compositeContext, Composite composite) throws ActivationException {
        try {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Activating composite: " + composite.getName());
            }
            for (Component component : composite.getComponents()) {
                this.activateComponent(compositeContext, component);
            }
        }
        catch (Exception e) {
            throw new ActivationException(e);
        }
    }

    @Override
    public void deactivate(Composite composite) throws ActivationException {
        try {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Deactivating composite: " + composite.getName());
            }
            for (Component component : composite.getComponents()) {
                this.deactivateComponent(component);
            }
        }
        catch (Exception e) {
            throw new ActivationException(e);
        }
    }

    public void activateComponent(CompositeContext compositeContext, Component component) throws ActivationException {
        try {
            Implementation implementation;
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Activating component: " + component.getURI());
            }
            if ((implementation = component.getImplementation()) instanceof Composite) {
                this.activate(compositeContext, (Composite)implementation);
            } else if (implementation != null) {
                this.addImplementationProvider((RuntimeComponent)component, implementation);
                this.addScopeContainer(component);
            }
            for (ComponentService service : component.getServices()) {
                this.activate(compositeContext, (RuntimeComponent)component, (RuntimeComponentService)service);
            }
            for (ComponentReference reference : component.getReferences()) {
                this.activate(compositeContext, (RuntimeComponent)component, (RuntimeComponentReference)reference);
            }
        }
        catch (Exception e) {
            throw new ActivationException(e);
        }
    }

    public void deactivateComponent(Component component) throws ActivationException {
        try {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Deactivating component: " + component.getURI());
            }
            for (ComponentService service : component.getServices()) {
                this.deactivate((RuntimeComponent)component, (RuntimeComponentService)service);
            }
            for (ComponentReference reference : component.getReferences()) {
                this.deactivate((RuntimeComponent)component, (RuntimeComponentReference)reference);
            }
            Implementation implementation = component.getImplementation();
            if (implementation instanceof Composite) {
                this.deactivate((Composite)implementation);
            } else if (implementation != null) {
                this.removeImplementationProvider((RuntimeComponent)component);
                this.removeScopeContainer(component);
            }
        }
        catch (Exception e) {
            throw new ActivationException(e);
        }
    }

    private void addImplementationProvider(RuntimeComponent component, Implementation implementation) {
        ImplementationProviderFactory providerFactory = (ImplementationProviderFactory)this.providerFactories.getProviderFactory(implementation.getClass());
        if (providerFactory != null) {
            ImplementationProvider implementationProvider = providerFactory.createImplementationProvider(component, implementation);
            if (implementationProvider != null) {
                component.setImplementationProvider(implementationProvider);
            }
        } else {
            throw new IllegalStateException("Provider factory not found for class: " + implementation.getClass().getName());
        }
        for (PolicyProviderFactory f : this.providerFactories.getPolicyProviderFactories()) {
            PolicyProvider policyProvider = f.createImplementationPolicyProvider(component);
            if (policyProvider == null) continue;
            component.addPolicyProvider(policyProvider);
        }
    }

    private void removeImplementationProvider(RuntimeComponent component) {
        component.setImplementationProvider(null);
        component.getPolicyProviders().clear();
    }

    private void addScopeContainer(Component component) {
        if (!(component instanceof ScopedRuntimeComponent)) {
            return;
        }
        ScopedRuntimeComponent runtimeComponent = (ScopedRuntimeComponent)component;
        ScopeContainer scopeContainer = this.scopeRegistry.getScopeContainer(runtimeComponent);
        runtimeComponent.setScopeContainer(scopeContainer);
    }

    private void removeScopeContainer(Component component) {
        if (!(component instanceof ScopedRuntimeComponent)) {
            return;
        }
        ScopedRuntimeComponent runtimeComponent = (ScopedRuntimeComponent)component;
        ScopeContainer scopeContainer = runtimeComponent.getScopeContainer();
        runtimeComponent.setScopeContainer(null);
    }

    @Override
    public void activate(CompositeContext compositeContext, RuntimeComponent component, RuntimeComponentService service) {
        if (service.getService() == null) {
            if (this.logger.isLoggable(Level.WARNING)) {
                this.logger.warning("Skipping component service not defined in the component type: " + component.getURI() + "#" + service.getName());
            }
            return;
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Activating component service: " + component.getURI() + "#" + service.getName());
        }
        for (Endpoint endpoint : service.getEndpoints()) {
            RuntimeEndpoint ep = (RuntimeEndpoint)endpoint;
            this.activate(compositeContext, ep);
            Service targetService = service.getService();
            if (targetService != null) continue;
            targetService = service;
        }
    }

    @Override
    public void activate(CompositeContext compositeContext, RuntimeEndpoint ep) {
        ep.bind(compositeContext);
        ep.validateServiceInterfaceCompatibility();
    }

    @Override
    public void deactivate(RuntimeComponent component, RuntimeComponentService service) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Deactivating component service: " + component.getURI() + "#" + service.getName());
        }
        for (Endpoint ep : service.getEndpoints()) {
            if (!(ep instanceof RuntimeEndpoint)) continue;
            this.deactivate((RuntimeEndpoint)ep);
        }
    }

    @Override
    public void deactivate(RuntimeEndpoint ep) {
        ep.unbind();
    }

    @Override
    public void activate(CompositeContext compositeContext, RuntimeComponent component, RuntimeComponentReference reference) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Activating component reference: " + component.getURI() + "#" + reference.getName());
        }
        reference.setComponent(component);
        for (EndpointReference epr : reference.getEndpointReferences()) {
            this.activate(compositeContext, (RuntimeEndpointReference)epr);
        }
    }

    @Override
    public void deactivate(RuntimeComponent component, RuntimeComponentReference reference) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Deactivating component reference: " + component.getURI() + "#" + reference.getName());
        }
        for (EndpointReference endpointReference : reference.getEndpointReferences()) {
            this.deactivate((RuntimeEndpointReference)endpointReference);
        }
    }

    @Override
    public void activate(CompositeContext compositeContext, RuntimeEndpointReference epr) {
        epr.bind(compositeContext);
        ComponentReference reference = epr.getReference();
        InterfaceContract sourceContract = epr.getComponentTypeReferenceInterfaceContract();
        if (sourceContract == null) {
            sourceContract = ((RuntimeEndpoint)epr.getTargetEndpoint()).getComponentTypeServiceInterfaceContract();
            reference.setInterfaceContract(sourceContract);
        }
        if (epr.getStatus() == EndpointReference.Status.RESOLVED_BINDING) {
            epr.validateReferenceInterfaceCompatibility();
        }
    }

    @Override
    public void deactivate(RuntimeEndpointReference endpointReference) {
        endpointReference.unbind();
    }

    @Override
    public void start(CompositeContext compositeContext, Composite composite) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Starting composite: " + composite.getName());
        }
        for (Component component : composite.getComponents()) {
            this.start(compositeContext, component);
        }
        for (Component component : composite.getComponents()) {
            if (!(component instanceof ScopedRuntimeComponent)) continue;
            this.start(compositeContext, (ScopedRuntimeComponent)component);
        }
        for (Component component : composite.getComponents()) {
            for (ComponentReference reference : component.getReferences()) {
                this.start(compositeContext, (RuntimeComponent)component, (RuntimeComponentReference)reference);
            }
        }
    }

    @Override
    public void stop(CompositeContext compositeContext, Composite composite) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Stopping composite: " + composite.getName());
        }
        for (Component component : composite.getComponents()) {
            this.stop(compositeContext, component);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(CompositeContext compositeContext, Component component) {
        RuntimeComponent runtimeComponent;
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Starting component: " + component.getURI());
        }
        if ((runtimeComponent = (RuntimeComponent)component).isStarted()) {
            return;
        }
        compositeContext.bindComponent(runtimeComponent);
        Implementation implementation = component.getImplementation();
        ArrayList<RuntimeProvider> providers = new ArrayList<RuntimeProvider>();
        try {
            if (implementation instanceof Composite) {
                try {
                    this.start(compositeContext, (Composite)implementation);
                }
                catch (Throwable e) {
                    try {
                        this.stop(compositeContext, (Composite)implementation);
                    }
                    catch (Throwable e1) {
                        Monitor.error(this.monitor, (Object)this, "core-messages", "StopException", e1);
                    }
                    this.rethrow(e);
                }
            } else {
                for (PolicyProvider policyProvider : runtimeComponent.getPolicyProviders()) {
                    policyProvider.start();
                    providers.add(policyProvider);
                }
                ImplementationProvider implementationProvider = runtimeComponent.getImplementationProvider();
                if (implementationProvider != null) {
                    implementationProvider.start();
                    providers.add(implementationProvider);
                }
            }
            for (ComponentService service : component.getServices()) {
                if (this.logger.isLoggable(Level.FINE)) {
                    this.logger.fine("Starting component service: " + component.getURI() + "#" + service.getName());
                }
                for (Endpoint endpoint : service.getEndpoints()) {
                    RuntimeEndpoint ep = (RuntimeEndpoint)endpoint;
                    this.startEndpoint(compositeContext, ep, providers);
                }
            }
        }
        catch (Throwable e) {
            for (int i = providers.size() - 1; i >= 0; --i) {
                try {
                    ((RuntimeProvider)providers.get(i)).stop();
                    continue;
                }
                catch (Throwable e1) {
                    Monitor.error(this.monitor, (Object)this, "core-messages", "StopException", e1);
                }
            }
            this.rethrow(e);
        }
        finally {
            providers.clear();
        }
        runtimeComponent.setStarted(true);
    }

    private void rethrow(Throwable e) throws Error {
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
    }

    @Override
    public void stop(CompositeContext compositeContext, Component component) {
        ScopedRuntimeComponent runtimeComponent;
        if (!((RuntimeComponent)component).isStarted()) {
            return;
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Stopping component: " + component.getURI());
        }
        for (ComponentService service : component.getServices()) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Stopping component service: " + component.getURI() + "#" + service.getName());
            }
            for (Endpoint endpoint : service.getEndpoints()) {
                RuntimeEndpoint ep = (RuntimeEndpoint)endpoint;
                this.stop(ep);
            }
        }
        for (ComponentReference reference : component.getReferences()) {
            if (this.logger.isLoggable(Level.FINE)) {
                this.logger.fine("Stopping component reference: " + component.getURI() + "#" + reference.getName());
            }
            for (EndpointReference endpointReference : reference.getEndpointReferences()) {
                RuntimeEndpointReference epr = (RuntimeEndpointReference)endpointReference;
                this.stop(epr);
            }
        }
        Implementation implementation = component.getImplementation();
        if (implementation instanceof Composite) {
            this.stop(compositeContext, (Composite)implementation);
        } else {
            final ImplementationProvider implementationProvider = ((RuntimeComponent)component).getImplementationProvider();
            if (implementationProvider != null) {
                try {
                    AccessController.doPrivileged(new PrivilegedAction<Object>(){

                        @Override
                        public Object run() {
                            implementationProvider.stop();
                            return null;
                        }
                    });
                }
                catch (Throwable ex) {
                    Monitor.error(this.monitor, (Object)this, "core-messages", "StopException", ex);
                }
            }
            for (PolicyProvider policyProvider : ((RuntimeComponent)component).getPolicyProviders()) {
                try {
                    policyProvider.stop();
                }
                catch (Throwable ex) {
                    Monitor.error(this.monitor, (Object)this, "core-messages", "StopException", ex);
                }
            }
        }
        if (component instanceof ScopedRuntimeComponent && (runtimeComponent = (ScopedRuntimeComponent)component).getScopeContainer() != null && runtimeComponent.getScopeContainer().getLifecycleState() != 6) {
            try {
                runtimeComponent.getScopeContainer().stop();
            }
            catch (Throwable ex) {
                Monitor.error(this.monitor, (Object)this, "core-messages", "StopException", ex);
            }
        }
        ((RuntimeComponent)component).setStarted(false);
    }

    public void start(CompositeContext compositeContext, ScopedRuntimeComponent scopedRuntimeComponent) {
        if (scopedRuntimeComponent.getScopeContainer() != null) {
            try {
                scopedRuntimeComponent.getScopeContainer().start();
            }
            catch (Throwable ex) {
                Monitor.error(this.monitor, (Object)this, "core-messages", "StartException", ex);
                this.rethrow(ex);
            }
        }
    }

    @Override
    public void start(CompositeContext compositeContext, RuntimeEndpoint ep) {
        this.startEndpoint(compositeContext, ep, null);
    }

    private void startEndpoint(CompositeContext compositeContext, RuntimeEndpoint ep, final List<RuntimeProvider> providers) {
        for (PolicyProvider policyProvider : ep.getPolicyProviders()) {
            policyProvider.start();
            if (providers == null) continue;
            try {
                providers.add(policyProvider);
            }
            catch (Throwable ex) {
                Monitor.error(this.monitor, (Object)this, "core-messages", "StartException", ex);
                this.rethrow(ex);
            }
        }
        final ServiceBindingProvider bindingProvider = ep.getBindingProvider();
        if (bindingProvider != null) {
            try {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        bindingProvider.start();
                        if (providers != null) {
                            providers.add(bindingProvider);
                        }
                        return null;
                    }
                });
                compositeContext.getEndpointRegistry().addEndpoint(ep);
            }
            catch (Throwable ex) {
                Monitor.error(this.monitor, (Object)this, "core-messages", "StartException", ex);
                this.rethrow(ex);
            }
        }
    }

    @Override
    public void stop(RuntimeEndpoint ep) {
        ep.getCompositeContext().getEndpointRegistry().removeEndpoint(ep);
        final ServiceBindingProvider bindingProvider = ep.getBindingProvider();
        if (bindingProvider != null) {
            try {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        bindingProvider.stop();
                        return null;
                    }
                });
            }
            catch (Throwable ex) {
                Monitor.error(this.monitor, (Object)this, "core-messages", "StopException", ex);
            }
        }
        for (PolicyProvider policyProvider : ep.getPolicyProviders()) {
            try {
                policyProvider.stop();
            }
            catch (Throwable ex) {
                Monitor.error(this.monitor, (Object)this, "core-messages", "StopException", ex);
            }
        }
    }

    @Override
    public void start(CompositeContext compositeContext, RuntimeComponent component, RuntimeComponentReference reference) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Starting component reference: " + component.getURI() + "#" + reference.getName());
        }
        for (EndpointReference endpointReference : reference.getEndpointReferences()) {
            ReferenceBindingProvider bindingProvider;
            RuntimeEndpointReference epr = (RuntimeEndpointReference)endpointReference;
            if (epr.getStatus() != EndpointReference.Status.WIRED_TARGET_FOUND_AND_MATCHED && epr.getStatus() != EndpointReference.Status.RESOLVED_BINDING || !((bindingProvider = epr.getBindingProvider()) instanceof EndpointReferenceAsyncProvider) || !((EndpointReferenceAsyncProvider)bindingProvider).supportsNativeAsync() || !epr.isAsyncInvocation()) continue;
            try {
                epr.getInvocationChains();
            }
            catch (Throwable ex) {
                Monitor.error(this.monitor, (Object)this, "core-messages", "StartException", ex);
                this.rethrow(ex);
            }
        }
    }

    public void stop(Component component, ComponentReference reference) {
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Stopping component reference: " + component.getURI() + "#" + reference.getName());
        }
        RuntimeComponentReference runtimeRef = (RuntimeComponentReference)reference;
        for (EndpointReference endpointReference : runtimeRef.getEndpointReferences()) {
            RuntimeEndpointReference epr = (RuntimeEndpointReference)endpointReference;
            this.stop(epr);
        }
    }

    @Override
    @Deprecated
    public void start(CompositeContext compositeContext, RuntimeEndpointReference endpointReference) {
        compositeContext.getEndpointRegistry().addEndpointReference(endpointReference);
        endpointReference.getInvocationChains();
    }

    @Override
    public void stop(RuntimeEndpointReference epr) {
        if (epr.isStarted()) {
            CompositeContext compositeContext = epr.getCompositeContext();
            if (compositeContext == null) {
                throw new IllegalStateException("The endpoint reference is not bound");
            }
            compositeContext.getEndpointRegistry().removeEndpointReference(epr);
            ReferenceBindingProvider bindingProvider = epr.getBindingProvider();
            if (bindingProvider != null) {
                try {
                    bindingProvider.stop();
                }
                catch (Throwable ex) {
                    Monitor.error(this.monitor, (Object)this, "core-messages", "StopException", ex);
                }
            }
            for (PolicyProvider policyProvider : epr.getPolicyProviders()) {
                try {
                    policyProvider.stop();
                }
                catch (Throwable ex) {
                    Monitor.error(this.monitor, (Object)this, "core-messages", "StopException", ex);
                }
            }
        }
    }
}

