/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.contribution.processor;

import org.apache.tuscany.sca.contribution.Artifact;
import org.apache.tuscany.sca.contribution.Contribution;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.monitor.DefaultMonitorFactory;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.MonitorFactory;

public class ProcessorContext {
    protected Contribution contribution;
    protected Artifact artifact;
    protected Monitor monitor;
    protected Object parentModel;

    public ProcessorContext(Contribution contribution, Monitor monitor) {
        this.contribution = contribution;
        this.monitor = monitor;
    }

    public ProcessorContext(Monitor monitor) {
        this.monitor = monitor;
    }

    public ProcessorContext(ExtensionPointRegistry registry) {
        MonitorFactory monitorFactory = registry.getExtensionPoint(UtilityExtensionPoint.class).getUtility(MonitorFactory.class);
        this.monitor = monitorFactory.createMonitor();
    }

    public ProcessorContext() {
        this.monitor = new DefaultMonitorFactory().createMonitor();
    }

    public Contribution getContribution() {
        return this.contribution;
    }

    public Contribution setContribution(Contribution contribution) {
        Contribution old = this.contribution;
        this.contribution = contribution;
        return old;
    }

    public Monitor getMonitor() {
        return this.monitor;
    }

    public Monitor setMonitor(Monitor monitor) {
        Monitor old = this.monitor;
        this.monitor = monitor;
        return old;
    }

    public Object getParentModel() {
        return this.parentModel;
    }

    public Object setParentModel(Object parentMObject) {
        Object old = this.parentModel;
        this.parentModel = parentMObject;
        return old;
    }

    public Artifact getArtifact() {
        return this.artifact;
    }

    public Artifact setArtifact(Artifact artifact) {
        Artifact old = this.artifact;
        this.artifact = artifact;
        return old;
    }
}

