/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.context;

import java.util.HashMap;
import java.util.Map;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.context.ComponentContextFactory;
import org.apache.tuscany.sca.context.ContextFactoryExtensionPoint;
import org.apache.tuscany.sca.context.ThreadMessageContext;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.definitions.Definitions;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.DomainRegistry;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentContext;

public class CompositeContext {
    protected ExtensionPointRegistry extensionPointRegistry;
    protected DomainRegistry domainRegistry;
    protected ComponentContextFactory componentContextFactory;
    protected Composite domainComposite;
    protected String nodeURI;
    protected String domainURI;
    protected Definitions systemDefinitions;
    protected Map<String, Object> attributes = new HashMap<String, Object>();

    public CompositeContext(ExtensionPointRegistry registry, DomainRegistry domainRegistry, Composite domainComposite, String domainURI, String nodeURI, Definitions systemDefinitions) {
        this.extensionPointRegistry = registry;
        this.domainRegistry = domainRegistry;
        ContextFactoryExtensionPoint contextFactories = registry.getExtensionPoint(ContextFactoryExtensionPoint.class);
        this.componentContextFactory = contextFactories.getFactory(ComponentContextFactory.class);
        this.domainComposite = domainComposite;
        this.domainURI = domainURI;
        this.nodeURI = nodeURI;
        this.systemDefinitions = systemDefinitions;
    }

    public CompositeContext(ExtensionPointRegistry registry, DomainRegistry domainRegistry) {
        this(registry, domainRegistry, null, "default", "default", null);
    }

    public static RuntimeComponent getCurrentComponent() {
        Message message = ThreadMessageContext.getMessageContext();
        if (message != null) {
            Endpoint to = message.getTo();
            if (to == null) {
                return null;
            }
            RuntimeComponent component = (RuntimeComponent)message.getTo().getComponent();
            return component;
        }
        return null;
    }

    public static CompositeContext getCurrentCompositeContext() {
        RuntimeComponent component = CompositeContext.getCurrentComponent();
        if (component != null) {
            RuntimeComponentContext componentContext = component.getComponentContext();
            return componentContext.getCompositeContext();
        }
        return null;
    }

    public void bindComponent(RuntimeComponent runtimeComponent) {
        RuntimeComponentContext componentContext = (RuntimeComponentContext)this.componentContextFactory.createComponentContext(this, runtimeComponent);
        runtimeComponent.setComponentContext(componentContext);
    }

    public void bindEndpointReference(EndpointReference endpointReference) {
    }

    public ExtensionPointRegistry getExtensionPointRegistry() {
        return this.extensionPointRegistry;
    }

    public DomainRegistry getEndpointRegistry() {
        return this.domainRegistry;
    }

    public Composite getDomainComposite() {
        return this.domainComposite;
    }

    public String getNodeURI() {
        return this.nodeURI;
    }

    public String getDomainURI() {
        return this.domainURI;
    }

    public Definitions getSystemDefinitions() {
        return this.systemDefinitions;
    }

    public <T> T getAttribute(String name) {
        return (T)this.attributes.get(name);
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }
}

