/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.common.xml.stax.reader;

import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import org.apache.tuscany.sca.common.xml.stax.reader.NamespaceContextImpl;
import org.apache.tuscany.sca.common.xml.stax.reader.XmlNode;

public class XmlNodeIterator
implements Iterator<XmlNode> {
    public static final int START = 0;
    public static final int END = 1;
    protected FastStack<ElementHolder> stack;
    protected int state;
    protected NamespaceContextImpl nsContext;

    public XmlNodeIterator(XmlNode rootNode) {
        ArrayList<XmlNode> v = new ArrayList<XmlNode>(1);
        v.add(rootNode);
        this.stack = new FastStack();
        Iterator<XmlNode> i = v.iterator();
        this.stack.push(new ElementHolder(null, i));
        this.state = 0;
        this.nsContext = new NamespaceContextImpl(null);
    }

    @Override
    public boolean hasNext() {
        return !this.stack.empty() && (this.state != 1 || this.stack.peek().parent != null);
    }

    @Override
    public XmlNode next() {
        this.state = 0;
        ElementHolder element = this.stack.peek();
        Iterator it = element.children;
        if (it == null || !it.hasNext()) {
            this.stack.pop();
            this.state = 1;
            this.nsContext = (NamespaceContextImpl)this.nsContext.getParent();
            return element.parent;
        }
        XmlNode node = (XmlNode)it.next();
        this.stack.push(new ElementHolder(node, node.children()));
        this.nsContext = new NamespaceContextImpl(this.nsContext);
        this.populateNamespaces(node);
        return node;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public int getState() {
        return this.state;
    }

    public NamespaceContext getNamespaceContext() {
        return this.nsContext;
    }

    private void populateNamespaces(XmlNode element) {
        if (element.getName() != null && element.namespaces() != null) {
            for (Map.Entry<String, String> e : element.namespaces().entrySet()) {
                this.nsContext.register(e.getKey(), e.getValue());
            }
        }
    }

    public static class FastStack<T>
    extends ArrayList<T> {
        private static final long serialVersionUID = 2130079159931574599L;

        public FastStack() {
        }

        public FastStack(int initialSize) {
            super(initialSize);
        }

        public boolean empty() {
            return this.isEmpty();
        }

        public T peek() throws EmptyStackException {
            int n = this.size();
            if (n <= 0) {
                throw new EmptyStackException();
            }
            return (T)this.get(n - 1);
        }

        public T peek(int n) throws EmptyStackException {
            int m = this.size() - n - 1;
            if (m < 0) {
                throw new EmptyStackException();
            }
            return (T)this.get(m);
        }

        public T pop() throws EmptyStackException {
            int n = this.size();
            if (n <= 0) {
                throw new EmptyStackException();
            }
            return (T)this.remove(n - 1);
        }

        public Object push(T item) {
            this.add(item);
            return item;
        }

        public int search(T object) {
            for (int i = this.size() - 1; i >= 0; --i) {
                Object current = this.get(i);
                if ((object != null || current != null) && (object == null || !object.equals(current))) continue;
                return i;
            }
            return -1;
        }

        public T get() {
            int size = this.size();
            if (size == 0) {
                throw new EmptyStackException();
            }
            return (T)this.get(size - 1);
        }

        public T remove() {
            int size = this.size();
            if (size == 0) {
                throw new EmptyStackException();
            }
            return (T)this.remove(size - 1);
        }
    }

    private static class ElementHolder {
        private XmlNode parent;
        private Iterator<XmlNode> children;

        public ElementHolder(XmlNode parent, Iterator<XmlNode> children) {
            this.parent = parent;
            this.children = children;
        }
    }
}

