/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.common.xml.stax.reader;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.common.xml.dom.DOMHelper;
import org.apache.tuscany.sca.common.xml.stax.reader.SimpleXmlNodeImpl;
import org.apache.tuscany.sca.common.xml.stax.reader.XmlNode;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMXmlNodeImpl
implements XmlNode {
    private Node node;
    private Map<String, String> namespaces;
    private XmlNode.Type type;

    public DOMXmlNodeImpl(Node element) {
        this.node = element.getNodeType() == 9 ? ((Document)element).getDocumentElement() : element;
        switch (this.node.getNodeType()) {
            case 4: {
                this.type = XmlNode.Type.CHARACTERS;
                break;
            }
            case 1: {
                this.type = XmlNode.Type.ELEMENT;
                break;
            }
            case 3: {
                this.type = XmlNode.Type.CHARACTERS;
            }
        }
    }

    @Override
    public List<XmlNode> attributes() {
        if (this.type != XmlNode.Type.ELEMENT) {
            return null;
        }
        NamedNodeMap attrs = this.node.getAttributes();
        ArrayList<XmlNode> xmlAttrs = new ArrayList<XmlNode>();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            if (attr.getName().equals("xmlns") || attr.getName().startsWith("xmlns:")) continue;
            xmlAttrs.add(new SimpleXmlNodeImpl(DOMXmlNodeImpl.getQName(attr), attr.getValue(), XmlNode.Type.ATTRIBUTE));
        }
        return xmlAttrs;
    }

    @Override
    public Iterator<XmlNode> children() {
        if (this.type != XmlNode.Type.ELEMENT) {
            return null;
        }
        NodeList nodes = this.node.getChildNodes();
        ArrayList<DOMXmlNodeImpl> xmlNodes = new ArrayList<DOMXmlNodeImpl>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node child = nodes.item(i);
            short nodeType = child.getNodeType();
            if (nodeType != 1 && nodeType != 3 && nodeType != 4) continue;
            xmlNodes.add(new DOMXmlNodeImpl(child));
        }
        return xmlNodes.iterator();
    }

    @Override
    public QName getName() {
        return DOMXmlNodeImpl.getQName(this.node);
    }

    private static QName getQName(Node node) {
        return DOMHelper.getQName(node);
    }

    public String getValue() {
        return this.node.getNodeValue();
    }

    @Override
    public Map<String, String> namespaces() {
        if (this.type != XmlNode.Type.ELEMENT) {
            return null;
        }
        if (this.namespaces == null) {
            this.namespaces = new HashMap<String, String>();
            NamedNodeMap attrs = this.node.getAttributes();
            for (int i = 0; i < attrs.getLength(); ++i) {
                Attr attr = (Attr)attrs.item(i);
                if ("xmlns".equals(attr.getPrefix())) {
                    this.namespaces.put(attr.getLocalName(), attr.getValue());
                }
                if (!"xmlns".equals(attr.getName())) continue;
                this.namespaces.put("", attr.getValue());
            }
        }
        return this.namespaces;
    }

    @Override
    public XmlNode.Type getType() {
        return this.type;
    }
}

