/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.client.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.assembly.Multiplicity;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.client.impl.EndpointFinder;
import org.apache.tuscany.sca.client.impl.RuntimeUtils;
import org.apache.tuscany.sca.context.CompositeContext;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.core.invocation.ExtensibleProxyFactory;
import org.apache.tuscany.sca.core.invocation.ProxyFactoryExtensionPoint;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.InvalidInterfaceException;
import org.apache.tuscany.sca.interfacedef.java.JavaInterface;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceFactory;
import org.apache.tuscany.sca.runtime.ContributionDescription;
import org.apache.tuscany.sca.runtime.DomainRegistry;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.apache.tuscany.sca.runtime.RuntimeComponentReference;
import org.apache.tuscany.sca.runtime.RuntimeEndpointReference;
import org.oasisopen.sca.NoSuchDomainException;
import org.oasisopen.sca.NoSuchServiceException;
import org.oasisopen.sca.ServiceRuntimeException;

public class RemoteServiceInvocationHandler
implements InvocationHandler {
    private String domainURI;
    private String serviceName;
    public Class<?> serviceInterface;
    private ExtensionPointRegistry extensionsRegistry;
    private DomainRegistry domainRegistry;
    private InvocationHandler handler;
    private boolean reuse;

    public RemoteServiceInvocationHandler(ExtensionPointRegistry extensionsRegistry, DomainRegistry domainRegistry, String serviceName, Class<?> serviceInterface) {
        this.extensionsRegistry = extensionsRegistry;
        this.domainRegistry = domainRegistry;
        this.domainURI = domainRegistry.getDomainURI();
        this.serviceName = serviceName;
        this.serviceInterface = serviceInterface;
        this.reuse = true;
    }

    public RemoteServiceInvocationHandler(ExtensionPointRegistry extensionsRegistry, DomainRegistry domainRegistry, String domainURI, String serviceName, Class<?> serviceInterface) throws NoSuchDomainException, NoSuchServiceException {
        this.extensionsRegistry = extensionsRegistry;
        this.domainRegistry = domainRegistry;
        this.domainURI = domainURI;
        this.serviceName = serviceName;
        this.serviceInterface = serviceInterface;
        this.reuse = false;
        if (serviceInterface == null) {
            this.getHandler();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try {
            Object object = this.getHandler().invoke(proxy, method, args);
            return object;
        }
        finally {
            if (!this.reuse) {
                this.extensionsRegistry.stop();
                this.extensionsRegistry = null;
                this.handler = null;
            }
        }
    }

    private InvocationHandler getHandler() throws NoSuchDomainException, NoSuchServiceException {
        if (this.handler == null) {
            RuntimeEndpointReference epr;
            if (this.extensionsRegistry == null) {
                this.extensionsRegistry = RuntimeUtils.createExtensionPointRegistry();
            }
            if (this.domainRegistry == null) {
                this.domainRegistry = RuntimeUtils.getClientEndpointRegistry(this.extensionsRegistry, this.domainURI);
            }
            FactoryExtensionPoint factories = this.extensionsRegistry.getExtensionPoint(FactoryExtensionPoint.class);
            AssemblyFactory assemblyFactory = factories.getFactory(AssemblyFactory.class);
            JavaInterfaceFactory javaInterfaceFactory = factories.getFactory(JavaInterfaceFactory.class);
            ExtensibleProxyFactory proxyFactory = new ExtensibleProxyFactory(this.extensionsRegistry.getExtensionPoint(ProxyFactoryExtensionPoint.class));
            CompositeContext compositeContext = new CompositeContext(this.extensionsRegistry, this.domainRegistry, null, this.domainURI, null, null);
            EndpointFinder endpointFinder = RuntimeUtils.getEndpointFinder(this.extensionsRegistry);
            Endpoint endpoint = endpointFinder.findEndpoint(this.domainRegistry, this.serviceName);
            if (this.serviceInterface == null) {
                try {
                    this.findInterface(endpoint);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                epr = this.createEndpointReference(javaInterfaceFactory, compositeContext, assemblyFactory, endpoint, this.serviceInterface);
            }
            catch (Exception e) {
                throw new ServiceRuntimeException(e);
            }
            this.handler = Proxy.getInvocationHandler(proxyFactory.createProxy(this.serviceInterface, epr));
        }
        return this.handler;
    }

    private void findInterface(Endpoint endpoint) throws MalformedURLException, ClassNotFoundException {
        String curi;
        Interface iface = endpoint.getService().getInterfaceContract().getInterface();
        if (iface instanceof JavaInterface && (curi = this.domainRegistry.getContainingCompositesContributionURI(endpoint.getComponent().getName())) != null) {
            ContributionDescription ic = this.domainRegistry.getInstalledContribution(curi);
            URLClassLoader cl = new URLClassLoader(new URL[]{new URL(ic.getURL())});
            this.serviceInterface = cl.loadClass(((JavaInterface)iface).getName());
        }
    }

    private RuntimeEndpointReference createEndpointReference(JavaInterfaceFactory javaInterfaceFactory, CompositeContext compositeContext, AssemblyFactory assemblyFactory, Endpoint endpoint, Class<?> businessInterface) throws CloneNotSupportedException, InvalidInterfaceException {
        Component component = endpoint.getComponent();
        ComponentService service = endpoint.getService();
        ComponentReference componentReference = assemblyFactory.createComponentReference();
        componentReference.setName("$sca.client$." + service.getName());
        componentReference.setCallback(service.getCallback());
        componentReference.getTargets().add(service);
        componentReference.getPolicySets().addAll(service.getPolicySets());
        componentReference.getRequiredIntents().addAll(service.getRequiredIntents());
        componentReference.getBindings().add(endpoint.getBinding());
        InterfaceContract interfaceContract = service.getInterfaceContract();
        Service componentTypeService = service.getService();
        if (componentTypeService != null && componentTypeService.getInterfaceContract() != null) {
            interfaceContract = componentTypeService.getInterfaceContract();
        }
        interfaceContract = this.getInterfaceContract(javaInterfaceFactory, interfaceContract, businessInterface);
        componentReference.setInterfaceContract(interfaceContract);
        componentReference.setMultiplicity(Multiplicity.ONE_ONE);
        EndpointReference endpointReference = assemblyFactory.createEndpointReference();
        endpointReference.setComponent(component);
        endpointReference.setReference(componentReference);
        endpointReference.setBinding(endpoint.getBinding());
        endpointReference.setUnresolved(false);
        endpointReference.setStatus(EndpointReference.Status.WIRED_TARGET_FOUND_AND_MATCHED);
        endpointReference.setTargetEndpoint(endpoint);
        componentReference.getEndpointReferences().add(endpointReference);
        ((RuntimeComponentReference)componentReference).setComponent((RuntimeComponent)component);
        ((RuntimeEndpointReference)endpointReference).bind(compositeContext);
        return (RuntimeEndpointReference)endpointReference;
    }

    private InterfaceContract getInterfaceContract(JavaInterfaceFactory javaInterfaceFactory, InterfaceContract interfaceContract, Class<?> businessInterface) throws CloneNotSupportedException, InvalidInterfaceException {
        Class<?> cls;
        Interface interfaze;
        if (businessInterface == null) {
            return interfaceContract;
        }
        boolean compatible = false;
        if (interfaceContract != null && interfaceContract.getInterface() != null && (interfaze = interfaceContract.getInterface()) instanceof JavaInterface && (cls = ((JavaInterface)interfaze).getJavaClass()) != null && businessInterface.isAssignableFrom(cls)) {
            compatible = true;
        }
        if (!compatible) {
            interfaceContract = javaInterfaceFactory.createJavaInterfaceContract();
            JavaInterface callInterface = javaInterfaceFactory.createJavaInterface(businessInterface);
            interfaceContract.setInterface(callInterface);
            if (callInterface.getCallbackClass() != null) {
                interfaceContract.setCallbackInterface(javaInterfaceFactory.createJavaInterface(callInterface.getCallbackClass()));
            }
        }
        return interfaceContract;
    }
}

