/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.builder.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.Contract;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.assembly.builder.BuilderContext;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilder;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilderException;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.definitions.Definitions;
import org.apache.tuscany.sca.monitor.Monitor;

public class StructuralURIBuilderImpl
implements CompositeBuilder {
    public StructuralURIBuilderImpl(ExtensionPointRegistry registry) {
    }

    @Override
    public String getID() {
        return "org.apache.tuscany.sca.assembly.builder.StructualURIBuilder";
    }

    @Override
    public Composite build(Composite composite, BuilderContext context) throws CompositeBuilderException {
        this.configureStructuralURIs(composite, null, context.getDefinitions(), context.getBindingBaseURIs(), context.getMonitor());
        return composite;
    }

    private void constructBindingNames(Contract contract, Monitor monitor) {
        Binding existed;
        List<Binding> bindings = contract.getBindings();
        HashMap<String, Binding> bindingMap = new HashMap<String, Binding>();
        for (Binding binding : bindings) {
            if (binding.getName() == null) {
                binding.setName(contract.getName());
            }
            if ((existed = bindingMap.put(binding.getName(), binding)) == null || existed == binding) continue;
            if (contract instanceof Service) {
                Monitor.error(monitor, (Object)this, "org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", "MultipleBindingsForService", contract.getName(), binding.getName());
                continue;
            }
            Monitor.error(monitor, (Object)this, "org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", "MultipleBindingsForReference", contract.getName(), binding.getName());
        }
        if (contract.getCallback() != null) {
            bindings = contract.getCallback().getBindings();
            bindingMap.clear();
            for (Binding binding : bindings) {
                if (binding.getName() == null) {
                    binding.setName(contract.getName());
                }
                if ((existed = bindingMap.put(binding.getName(), binding)) == null || existed == binding) continue;
                if (contract instanceof Service) {
                    Monitor.error(monitor, (Object)this, "org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", "MultipleBindingsForServiceCallback", contract.getName(), binding.getName());
                    continue;
                }
                Monitor.error(monitor, (Object)this, "org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", "MultipleBindingsForReferenceCallback", contract.getName(), binding.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureStructuralURIs(Composite composite, String parentComponentURI, Definitions definitions, Map<QName, List<String>> defaultBindings, Monitor monitor) throws CompositeBuilderException {
        monitor.pushContext("Composite: " + composite.getName().toString());
        try {
            for (Service service : composite.getServices()) {
                this.constructBindingNames(service, monitor);
            }
            for (Reference reference : composite.getReferences()) {
                this.constructBindingNames(reference, monitor);
            }
            for (Component component : composite.getComponents()) {
                String componentURI = parentComponentURI == null ? component.getName() : parentComponentURI + '/' + component.getName();
                component.setURI(componentURI);
                monitor.pushContext("Component: " + component.getName());
                try {
                    for (ComponentService componentService : component.getServices()) {
                        this.constructBindingNames(componentService, monitor);
                    }
                    for (ComponentReference componentReference : component.getReferences()) {
                        this.constructBindingNames(componentReference, monitor);
                    }
                }
                finally {
                    monitor.popContext();
                }
                Implementation implementation = component.getImplementation();
                if (!(implementation instanceof Composite)) continue;
                this.configureStructuralURIs((Composite)implementation, componentURI, definitions, defaultBindings, monitor);
            }
        }
        finally {
            monitor.popContext();
        }
    }
}

