/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.builder.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.builder.BuilderContext;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilderException;
import org.apache.tuscany.sca.builder.impl.PolicyAttachmentBuilderImpl;
import org.apache.tuscany.sca.context.CompositeContext;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.definitions.Definitions;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.PolicySubject;
import org.apache.tuscany.sca.runtime.RuntimeComponent;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PolicyAppliesToBuilderImpl
extends PolicyAttachmentBuilderImpl {
    public PolicyAppliesToBuilderImpl(ExtensionPointRegistry registry) {
        super(registry);
    }

    @Override
    public String getID() {
        return "org.apache.tuscany.sca.policy.builder.PolicyAppliesToBuilder";
    }

    @Override
    public Composite build(Composite composite, BuilderContext context) throws CompositeBuilderException {
        try {
            Definitions definitions = context.getDefinitions();
            if (definitions == null || definitions.getPolicySets().isEmpty() && definitions.getExternalAttachments().isEmpty()) {
                return composite;
            }
            Document document = this.saveAsDOM(composite);
            HashMap<PolicySet, List<PolicySubject>> appliesToSubjects = new HashMap<PolicySet, List<PolicySubject>>();
            return this.checkAppliesTo(document, appliesToSubjects, composite, context);
        }
        catch (Exception e) {
            throw new CompositeBuilderException(e);
        }
    }

    public void build(EndpointReference epr) throws CompositeBuilderException {
        try {
            CompositeContext compositeContext = ((RuntimeComponent)epr.getComponent()).getComponentContext().getCompositeContext();
            Composite domainComposite = compositeContext.getDomainComposite();
            Definitions systemDefinitions = compositeContext.getSystemDefinitions();
            if (systemDefinitions == null || systemDefinitions.getPolicySets().isEmpty() && systemDefinitions.getExternalAttachments().isEmpty()) {
                return;
            }
            epr.getReference().getBindings().add(epr.getTargetEndpoint().getBinding());
            Document document = this.saveAsDOM(domainComposite);
            epr.getReference().getBindings().remove(epr.getTargetEndpoint().getBinding());
            HashMap<PolicySet, List<PolicySubject>> appliesToSubjects = new HashMap<PolicySet, List<PolicySubject>>();
            for (PolicySet ps : new ArrayList<PolicySet>(epr.getPolicySets())) {
                if (epr.getBinding() instanceof PolicySubject && this.isApplicableToSubject(document, appliesToSubjects, domainComposite, (PolicySubject)((Object)epr.getBinding()), ps) || this.isApplicableToSubject(document, appliesToSubjects, domainComposite, epr.getReference(), ps) || epr.getReference().getInterfaceContract() != null && this.isApplicableToSubject(document, appliesToSubjects, domainComposite, epr.getReference().getInterfaceContract().getInterface(), ps) || this.isApplicableToSubject(document, appliesToSubjects, domainComposite, epr.getComponent(), ps) || this.isApplicableToSubject(document, appliesToSubjects, domainComposite, domainComposite, ps)) continue;
                epr.getPolicySets().remove(ps);
            }
        }
        catch (Exception e) {
            throw new CompositeBuilderException(e);
        }
    }

    private Composite checkAppliesTo(Document document, Map<PolicySet, List<PolicySubject>> appliesToSubjects, Composite topComposite, BuilderContext context) throws Exception {
        for (Component component : topComposite.getComponents()) {
            if (!(component.getImplementation() instanceof Composite)) continue;
            Composite nested = (Composite)component.getImplementation();
            this.checkAppliesTo(this.saveAsDOM(nested), new HashMap<PolicySet, List<PolicySubject>>(), nested, context);
        }
        for (Component component : topComposite.getComponents()) {
            for (ComponentService componentService : component.getServices()) {
                for (Endpoint ep : componentService.getEndpoints()) {
                    for (PolicySet ps : new ArrayList<PolicySet>(ep.getPolicySets())) {
                        if (ep.getBinding() instanceof PolicySubject && this.isApplicableToSubject(document, appliesToSubjects, topComposite, (PolicySubject)((Object)ep.getBinding()), ps) || this.isApplicableToSubject(document, appliesToSubjects, topComposite, componentService, ps) || componentService.getInterfaceContract() != null && this.isApplicableToSubject(document, appliesToSubjects, topComposite, componentService.getInterfaceContract().getInterface(), ps) || this.isApplicableToSubject(document, appliesToSubjects, topComposite, component, ps) || this.isApplicableToSubject(document, appliesToSubjects, topComposite, topComposite, ps)) continue;
                        ep.getPolicySets().remove(ps);
                    }
                }
            }
            for (ComponentReference componentReference : component.getReferences()) {
                for (EndpointReference epr : componentReference.getEndpointReferences()) {
                    if (epr.getStatus() == EndpointReference.Status.WIRED_TARGET_NOT_FOUND || epr.getBinding() == null) continue;
                    for (PolicySet ps : new ArrayList<PolicySet>(epr.getPolicySets())) {
                        if (epr.getBinding() instanceof PolicySubject && this.isApplicableToSubject(document, appliesToSubjects, topComposite, (PolicySubject)((Object)epr.getBinding()), ps) || this.isApplicableToSubject(document, appliesToSubjects, topComposite, componentReference, ps) || componentReference.getInterfaceContract() != null && this.isApplicableToSubject(document, appliesToSubjects, topComposite, componentReference.getInterfaceContract().getInterface(), ps) || this.isApplicableToSubject(document, appliesToSubjects, topComposite, component, ps) || this.isApplicableToSubject(document, appliesToSubjects, topComposite, topComposite, ps)) continue;
                        epr.getPolicySets().remove(ps);
                    }
                }
            }
            Implementation implementation = component.getImplementation();
            if (implementation == null || !(implementation instanceof PolicySubject)) continue;
            for (PolicySet ps : new ArrayList<PolicySet>(implementation.getPolicySets())) {
                if (this.isApplicableToSubject(document, appliesToSubjects, topComposite, implementation, ps)) continue;
                implementation.getPolicySets().remove(ps);
            }
        }
        return topComposite;
    }

    private boolean isApplicableToSubject(Document document, Map<PolicySet, List<PolicySubject>> appliesToSubjects, Composite composite, PolicySubject policySubject, PolicySet policySet) throws XPathExpressionException {
        XPathExpression appliesTo;
        List<PolicySubject> subjects = appliesToSubjects.get(policySet);
        if (subjects == null && (appliesTo = policySet.getAppliesToXPathExpression()) != null) {
            NodeList nodes = (NodeList)appliesTo.evaluate(document, XPathConstants.NODESET);
            if (nodes.getLength() > 0) {
                subjects = new ArrayList<PolicySubject>();
                appliesToSubjects.put(policySet, subjects);
            }
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                String index = PolicyAppliesToBuilderImpl.getStructuralURI(node);
                PolicySubject subject = this.lookup(composite, index);
                if (subject == null) continue;
                subjects.add(subject);
            }
        }
        if (subjects != null) {
            return subjects.contains(policySubject);
        }
        return false;
    }
}

