/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.builder.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.Wire;
import org.apache.tuscany.sca.assembly.builder.BuilderContext;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilder;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilderException;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.interfacedef.InterfaceContractMapper;
import org.apache.tuscany.sca.monitor.Monitor;

public class CompositeWireApplierImpl
implements CompositeBuilder {
    private InterfaceContractMapper interfaceContractMapper;

    public CompositeWireApplierImpl(ExtensionPointRegistry registry) {
        UtilityExtensionPoint utilities = registry.getExtensionPoint(UtilityExtensionPoint.class);
        this.interfaceContractMapper = utilities.getUtility(InterfaceContractMapper.class);
    }

    @Override
    public String getID() {
        return "org.apache.tuscany.sca.assembly.builder.CompositeWireApplierImpl";
    }

    @Override
    public Composite build(Composite composite, BuilderContext context) throws CompositeBuilderException {
        this.processComposite(composite, context);
        return composite;
    }

    private void processComposite(Composite composite, BuilderContext context) {
        HashMap<String, Component> components = new HashMap<String, Component>();
        HashMap<String, ComponentService> componentServices = new HashMap<String, ComponentService>();
        HashMap<String, ComponentReference> componentReferences = new HashMap<String, ComponentReference>();
        this.indexComponentsServicesAndReferences(composite, components, componentServices, componentReferences);
        this.connectWires(composite, componentServices, componentReferences, context.getMonitor());
        for (Component component : composite.getComponents()) {
            Implementation implementation = component.getImplementation();
            if (!(implementation instanceof Composite)) continue;
            this.processComposite((Composite)implementation, context);
        }
    }

    protected void indexComponentsServicesAndReferences(Composite composite, Map<String, Component> components, Map<String, ComponentService> componentServices, Map<String, ComponentReference> componentReferences) {
        for (Component component : composite.getComponents()) {
            String uri;
            components.put(component.getName(), component);
            ComponentService nonCallbackService = null;
            int nonCallbackServices = 0;
            for (ComponentService componentService : component.getServices()) {
                uri = component.getName() + '/' + componentService.getName();
                componentServices.put(uri, componentService);
                if (componentService.isForCallback()) continue;
                if (nonCallbackServices == 0) {
                    nonCallbackService = componentService;
                }
                ++nonCallbackServices;
            }
            if (nonCallbackServices == 1) {
                componentServices.put(component.getName(), nonCallbackService);
            }
            for (ComponentReference componentReference : component.getReferences()) {
                uri = component.getName() + '/' + componentReference.getName();
                componentReferences.put(uri, componentReference);
            }
        }
    }

    private void connectWires(Composite composite, Map<String, ComponentService> componentServices, Map<String, ComponentReference> componentReferences, Monitor monitor) {
        List<Wire> wires = composite.getWires();
        int n = wires.size();
        for (int i = 0; i < n; ++i) {
            ComponentService resolvedService;
            ComponentReference resolvedReference;
            Wire wire = wires.get(i);
            ComponentReference source = wire.getSource();
            if (source != null && source.isUnresolved()) {
                resolvedReference = componentReferences.get(source.getName());
                if (resolvedReference != null) {
                    wire.setSource(resolvedReference);
                } else {
                    Monitor.warning(monitor, (Object)this, "org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", "WireSourceNotFound", source.getName());
                }
            } else {
                resolvedReference = wire.getSource();
            }
            ComponentService target = wire.getTarget();
            if (target != null && target.isUnresolved()) {
                resolvedService = componentServices.get(target.getName());
                if (resolvedService != null) {
                    wire.setTarget(target);
                } else {
                    Monitor.warning(monitor, (Object)this, "org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", "WireTargetNotFound", target.getName());
                }
            } else {
                resolvedService = wire.getTarget();
            }
            if (resolvedReference == null || resolvedService == null) continue;
            if (resolvedReference.getInterfaceContract() == null || this.interfaceContractMapper.isCompatibleSubset(resolvedReference.getInterfaceContract(), resolvedService.getInterfaceContract())) {
                if (wire.isReplace()) {
                    resolvedReference.getTargets().clear();
                }
                resolvedReference.getTargets().add(wire.getTarget());
                continue;
            }
            Monitor.warning(monitor, (Object)this, "org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", "WireIncompatibleInterface", source.getName(), target.getName());
        }
        composite.getWires().clear();
    }
}

