/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.builder.impl;

import java.io.InputStream;
import java.io.StringReader;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentProperty;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.CompositeReference;
import org.apache.tuscany.sca.assembly.CompositeService;
import org.apache.tuscany.sca.assembly.Contract;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.Multiplicity;
import org.apache.tuscany.sca.assembly.Property;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.SCABinding;
import org.apache.tuscany.sca.assembly.SCABindingFactory;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.assembly.builder.BuilderContext;
import org.apache.tuscany.sca.assembly.builder.BuilderExtensionPoint;
import org.apache.tuscany.sca.assembly.builder.ContractBuilder;
import org.apache.tuscany.sca.assembly.builder.ImplementationBuilder;
import org.apache.tuscany.sca.builder.impl.ComponentPolicyBuilderImpl;
import org.apache.tuscany.sca.builder.impl.CompositeComponentTypeBuilderImpl;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.databinding.Mediator;
import org.apache.tuscany.sca.databinding.impl.MediatorImpl;
import org.apache.tuscany.sca.databinding.jaxb.JAXBDataBinding;
import org.apache.tuscany.sca.databinding.xml.DOMDataBinding;
import org.apache.tuscany.sca.definitions.Definitions;
import org.apache.tuscany.sca.interfacedef.Compatibility;
import org.apache.tuscany.sca.interfacedef.IncompatibleInterfaceContractException;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.InterfaceContractMapper;
import org.apache.tuscany.sca.interfacedef.impl.DataTypeImpl;
import org.apache.tuscany.sca.interfacedef.java.JavaInterfaceContract;
import org.apache.tuscany.sca.interfacedef.util.XMLType;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.policy.BindingType;
import org.apache.tuscany.sca.policy.PolicySubject;
import org.apache.tuscany.sca.xsd.XSDefinition;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class ComponentBuilderImpl {
    protected static final String SCA11_NS = "http://docs.oasis-open.org/ns/opencsa/sca/200912";
    protected static final String BINDING_SCA = "binding.sca";
    protected static final QName BINDING_SCA_QNAME = new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "binding.sca");
    private CompositeComponentTypeBuilderImpl componentTypeBuilder;
    protected ComponentPolicyBuilderImpl policyBuilder;
    private AssemblyFactory assemblyFactory;
    private SCABindingFactory scaBindingFactory;
    private DocumentBuilderFactory documentBuilderFactory;
    protected TransformerFactory transformerFactory;
    private InterfaceContractMapper interfaceContractMapper;
    private BuilderExtensionPoint builders;
    private Mediator mediator;
    private ContractBuilder contractBuilder;

    public ComponentBuilderImpl(ExtensionPointRegistry registry) {
        UtilityExtensionPoint utilities = registry.getExtensionPoint(UtilityExtensionPoint.class);
        FactoryExtensionPoint modelFactories = registry.getExtensionPoint(FactoryExtensionPoint.class);
        this.assemblyFactory = modelFactories.getFactory(AssemblyFactory.class);
        this.scaBindingFactory = modelFactories.getFactory(SCABindingFactory.class);
        this.documentBuilderFactory = modelFactories.getFactory(DocumentBuilderFactory.class);
        this.transformerFactory = modelFactories.getFactory(TransformerFactory.class);
        this.interfaceContractMapper = utilities.getUtility(InterfaceContractMapper.class);
        this.policyBuilder = new ComponentPolicyBuilderImpl(registry);
        this.builders = registry.getExtensionPoint(BuilderExtensionPoint.class);
        this.mediator = new MediatorImpl(registry);
        this.contractBuilder = this.builders.getContractBuilder();
    }

    public void setComponentTypeBuilder(CompositeComponentTypeBuilderImpl componentTypeBuilder) {
        this.componentTypeBuilder = componentTypeBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configureComponentFromComponentType(Component outerComponent, Composite parentComposite, Component component, BuilderContext context) {
        Monitor monitor = context.getMonitor();
        monitor.pushContext("Component: " + component.getName().toString());
        try {
            ImplementationBuilder<Implementation> builder;
            if (!this.isComponentImplementationPresent(component, monitor)) {
                return;
            }
            Implementation impl = component.getImplementation();
            if (impl != null && (builder = this.builders.getImplementationBuilder(impl.getType())) != null) {
                builder.build(component, impl, context);
            }
            this.configureProperties(outerComponent, parentComposite, component, monitor);
            this.createComponentType(component, context);
            this.configureServices(component, context);
            this.configureReferences(component, context);
            this.policyBuilder.configure(component, context);
        }
        finally {
            monitor.popContext();
        }
    }

    private boolean isComponentImplementationPresent(Component component, Monitor monitor) {
        Implementation implementation = component.getImplementation();
        if (implementation == null) {
            Monitor.error(monitor, (Object)this, "org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", "NoComponentImplementation", component.getName());
            return false;
        }
        if (implementation.isUnresolved()) {
            Monitor.error(monitor, (Object)this, "org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", "UnresolvedComponentImplementation", component, component.getName(), implementation.getURI());
            return false;
        }
        return true;
    }

    private void createComponentType(Component component, BuilderContext context) {
        Implementation implementation = component.getImplementation();
        if (implementation instanceof Composite) {
            this.componentTypeBuilder.createComponentType(component, (Composite)implementation, context);
        }
    }

    private void configureServices(Component component, BuilderContext context) {
        Monitor monitor = context.getMonitor();
        this.addServicesFromComponentType(component, monitor);
        this.connectServicesToComponentType(component, monitor);
        for (ComponentService componentService : component.getServices()) {
            Service componentTypeService = componentService.getService();
            if (componentTypeService == null) continue;
            this.calculateServiceInterfaceContract(component, componentService, componentTypeService, context);
            this.calculateBindings(component, componentService, componentTypeService, context);
            this.createCallbackReference(component, componentService, monitor);
        }
    }

    private void configureReferences(Component component, BuilderContext context) {
        Monitor monitor = context.getMonitor();
        this.addReferencesFromComponentType(component, monitor);
        this.connectReferencesToComponentType(component, monitor);
        for (ComponentReference componentReference : component.getReferences()) {
            Reference componentTypeReference = componentReference.getReference();
            if (componentTypeReference == null) continue;
            this.reconcileReferenceMultiplicity(component, componentReference, componentTypeReference, monitor);
            this.calculateReferenceInterfaceContract(component, componentReference, componentTypeReference, context);
            this.calculateBindings(componentReference, componentTypeReference);
            this.createCallbackService(component, componentReference, monitor);
            if (componentReference.getAutowire() != null) continue;
            componentReference.setAutowire(component.getAutowire());
        }
    }

    private void configureProperties(Component outerComponent, Composite parentComposite, Component component, Monitor monitor) {
        this.addPropertiesFromComponentType(component, monitor);
        this.connectPropertiesToComponentType(component, monitor);
        for (ComponentProperty componentProperty : component.getProperties()) {
            this.reconcileComponentPropertyWithComponentType(component, componentProperty, monitor);
            this.processPropertySourceAttribute(outerComponent, parentComposite, component, componentProperty, monitor);
            this.processPropertyFileAttribute(component, componentProperty, monitor);
            if (componentProperty.getXSDElement() == null && componentProperty.getXSDType() == null) {
                Monitor.error(monitor, (Object)this, "org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", "NoTypeForComponentProperty", component.getName(), componentProperty.getName());
            }
            if (componentProperty.isMustSupply() && !this.isPropertyValueSet(componentProperty)) {
                Monitor.error(monitor, (Object)this, "org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", "PropertyMustSupplyNull", component.getName(), componentProperty.getName());
            }
            if (!componentProperty.isMany() && this.isPropertyManyValued(componentProperty)) {
                Monitor.error(monitor, (Object)this, "org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", "PropertyHasManyValues", component.getName(), componentProperty.getName());
            }
            this.checkComponentPropertyType(component, componentProperty, monitor);
        }
    }

    private void addServicesFromComponentType(Component component, Monitor monitor) {
        if (component.getImplementation() != null) {
            for (Service service : component.getImplementation().getServices()) {
                ComponentService componentService;
                if (service != component.getImplementation().getService(service.getName())) {
                    Monitor.error(monitor, (Object)this, "org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", "DuplicateImplementationServiceName", component.getName(), service.getName());
                }
                if ((componentService = component.getService(service.getName())) != null) continue;
                componentService = this.assemblyFactory.createComponentService();
                componentService.setForCallback(service.isForCallback());
                String name = service.getName();
                componentService.setName(name);
                component.getServices().add(componentService);
            }
        }
    }

    private void addReferencesFromComponentType(Component component, Monitor monitor) {
        if (component.getImplementation() != null) {
            for (Reference reference : component.getImplementation().getReferences()) {
                ComponentReference componentReference;
                if (reference != component.getImplementation().getReference(reference.getName())) {
                    Monitor.error(monitor, (Object)this, "org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", "DuplicateImplementationReferenceName", component.getName(), reference.getName());
                }
                if ((componentReference = component.getReference(reference.getName())) != null) continue;
                componentReference = this.assemblyFactory.createComponentReference();
                componentReference.setForCallback(reference.isForCallback());
                componentReference.setName(reference.getName());
                componentReference.setReference(reference);
                component.getReferences().add(componentReference);
            }
        }
    }

    private void addPropertiesFromComponentType(Component component, Monitor monitor) {
        if (component.getImplementation() != null) {
            for (Property property : component.getImplementation().getProperties()) {
                ComponentProperty componentProperty;
                if (property != component.getImplementation().getProperty(property.getName())) {
                    Monitor.error(monitor, (Object)this, "org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", "DuplicateImplementationPropertyName", component.getName(), property.getName());
                }
                if ((componentProperty = component.getProperty(property.getName())) != null) continue;
                componentProperty = this.assemblyFactory.createComponentProperty();
                componentProperty.setName(property.getName());
                componentProperty.setValue(property.getValue());
                componentProperty.setMany(property.isMany());
                componentProperty.setMustSupply(property.isMustSupply());
                componentProperty.setXSDElement(property.getXSDElement());
                componentProperty.setXSDType(property.getXSDType());
                componentProperty.setProperty(property);
                component.getProperties().add(componentProperty);
            }
        }
    }

    private void connectServicesToComponentType(Component component, Monitor monitor) {
        for (ComponentService componentService : component.getServices()) {
            if (componentService != component.getService(componentService.getName())) {
                Monitor.error(monitor, (Object)this, "org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", "DuplicateComponentServiceName", component.getName(), componentService.getName());
            }
            if (componentService.getService() != null || componentService.isForCallback() || component.getImplementation() == null) continue;
            Service service = component.getImplementation().getService(componentService.getName());
            if (service != null) {
                componentService.setService(service);
                continue;
            }
            Monitor.error(monitor, (Object)this, "org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", "ServiceNotFoundForComponentService", component.getName(), componentService.getName());
        }
    }

    private void connectReferencesToComponentType(Component component, Monitor monitor) {
        for (ComponentReference componentReference : component.getReferences()) {
            if (componentReference != component.getReference(componentReference.getName())) {
                Monitor.error(monitor, (Object)this, "org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", "DuplicateComponentReferenceName", component.getName(), componentReference.getName());
            }
            if (componentReference.getReference() != null || componentReference.isForCallback() || component.getImplementation() == null) continue;
            Reference reference = component.getImplementation().getReference(componentReference.getName());
            if (reference != null) {
                componentReference.setReference(reference);
                continue;
            }
            Monitor.error(monitor, (Object)this, "org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", "ReferenceNotFoundForComponentReference", component.getName(), componentReference.getName());
        }
    }

    private void connectPropertiesToComponentType(Component component, Monitor monitor) {
        for (ComponentProperty componentProperty : component.getProperties()) {
            Property property;
            if (componentProperty != component.getProperty(componentProperty.getName())) {
                Monitor.error(monitor, (Object)this, "org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", "DuplicateComponentPropertyName", component.getName(), componentProperty.getName());
            }
            if ((property = component.getImplementation().getProperty(componentProperty.getName())) != null) {
                componentProperty.setProperty(property);
                if (componentProperty.getXSDElement() == null) {
                    componentProperty.setXSDElement(property.getXSDElement());
                }
                if (componentProperty.getXSDType() != null) continue;
                componentProperty.setXSDType(property.getXSDType());
                continue;
            }
            Monitor.error(monitor, (Object)this, "org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", "PropertyNotFound", component.getName(), componentProperty.getName());
        }
    }

    private void reconcileReferenceMultiplicity(Component component, Reference componentReference, Reference componentTypeReference, Monitor monitor) {
        if (componentReference.getMultiplicity() != null) {
            if (!this.isValidMultiplicityOverride(componentTypeReference.getMultiplicity(), componentReference.getMultiplicity())) {
                Monitor.error(monitor, (Object)this, "org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", "ReferenceIncompatibleMultiplicity", component.getName(), componentReference.getName());
            }
        } else {
            componentReference.setMultiplicity(componentTypeReference.getMultiplicity());
        }
    }

    private void reconcileComponentPropertyWithComponentType(Component component, ComponentProperty componentProperty, Monitor monitor) {
        Property componentTypeProperty = componentProperty.getProperty();
        if (componentTypeProperty != null) {
            if (!componentTypeProperty.isMustSupply() && componentProperty.isMustSupply()) {
                Monitor.error(monitor, (Object)this, "org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", "PropertyMustSupplyIncompatible", component.getName(), componentProperty.getName());
            }
            if (!componentProperty.isMustSupply()) {
                componentProperty.setMustSupply(componentTypeProperty.isMustSupply());
            }
            if (!this.isPropertyValueSet(componentProperty)) {
                componentProperty.setValue(componentTypeProperty.getValue());
            }
            if (component.getImplementation() instanceof Composite) {
                componentTypeProperty.setValue(componentProperty.getValue());
            }
            if (!componentTypeProperty.isMany() && componentProperty.isMany()) {
                Monitor.error(monitor, (Object)this, "org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", "PropertyOverrideManyAttribute", component.getName(), componentProperty.getName());
            }
            componentProperty.setMany(componentTypeProperty.isMany());
            if (componentProperty.getXSDType() == null) {
                componentProperty.setXSDType(componentTypeProperty.getXSDType());
            }
            if (componentProperty.getXSDElement() == null) {
                componentProperty.setXSDElement(componentTypeProperty.getXSDElement());
            }
            if (componentProperty.getXSDElement() != null && componentTypeProperty.getXSDElement() != null && !componentProperty.getXSDElement().equals(componentTypeProperty.getXSDElement())) {
                Monitor.error(monitor, (Object)this, "org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", "PropertXSDElementsDontMatch", component.getName(), componentProperty.getName(), componentProperty.getXSDElement(), componentTypeProperty.getXSDElement());
            }
            if (componentProperty.getXSDType() != null && componentTypeProperty.getXSDType() != null && !componentProperty.getXSDType().equals(componentTypeProperty.getXSDType())) {
                Monitor.error(monitor, (Object)this, "org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", "PropertXSDTypesDontMatch", component.getName(), componentProperty.getName(), componentProperty.getXSDType(), componentTypeProperty.getXSDType());
            }
        }
    }

    private void checkComponentPropertyType(Component component, ComponentProperty componentProperty, Monitor monitor) {
        QName propertyXSDType = componentProperty.getXSDType();
        QName propertyElementType = componentProperty.getXSDElement();
        if (propertyXSDType != null) {
            if (propertyXSDType.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
                Document doc = (Document)componentProperty.getValue();
                Node source = doc == null ? null : doc.getDocumentElement().getFirstChild();
                DataTypeImpl<XMLType> sourceDataType = new DataTypeImpl<XMLType>(DOMDataBinding.NAME, Node.class, new XMLType(null, componentProperty.getXSDType()));
                DataTypeImpl<XMLType> targetDataType = new DataTypeImpl<XMLType>(JAXBDataBinding.NAME, Object.class, new XMLType(null, componentProperty.getXSDType()));
                try {
                    this.mediator.mediate(source, sourceDataType, targetDataType, null);
                }
                catch (Exception ex) {
                    Monitor.error(monitor, (Object)this, "org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", "PropertyValueDoesNotMatchSimpleType", componentProperty.getName(), component.getName(), componentProperty.getXSDType().toString());
                }
            } else {
                XSDefinition xsdDefinition = (XSDefinition)componentProperty.getXSDDefinition();
                if (xsdDefinition != null) {
                    try {
                        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
                        Document schemaDom = xsdDefinition.getSchema().getSchemaDocument();
                        String valueSchema = null;
                        Schema schema = null;
                        if (componentProperty.getXSDType().getNamespaceURI().equals(SCA11_NS)) {
                            valueSchema = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> <schema xmlns=\"http://www.w3.org/2001/XMLSchema\" xmlns:sca=\"http://docs.oasis-open.org/ns/opencsa/sca/200912\" xmlns:__tmp=\"" + componentProperty.getXSDType().getNamespaceURI() + "\" " + "targetNamespace=\"http://docs.oasis-open.org/ns/opencsa/sca/200912\" " + "elementFormDefault=\"qualified\">" + "<include schemaLocation=\"" + xsdDefinition.getLocation() + "\"/>" + "</schema>";
                            Source[] sources = new Source[]{new DOMSource(schemaDom)};
                            schema = factory.newSchema(sources);
                            return;
                        }
                        valueSchema = "<?xml version=\"1.0\" encoding=\"UTF-8\"?> <schema xmlns=\"http://www.w3.org/2001/XMLSchema\" xmlns:sca=\"http://docs.oasis-open.org/ns/opencsa/sca/200912\" xmlns:__tmp=\"" + componentProperty.getXSDType().getNamespaceURI() + "\" " + "targetNamespace=\"http://docs.oasis-open.org/ns/opencsa/sca/200912\" " + "elementFormDefault=\"qualified\">" + "<import namespace=\"" + componentProperty.getXSDType().getNamespaceURI() + "\"/>" + "<element name=\"value\" type=\"" + "__tmp:" + componentProperty.getXSDType().getLocalPart() + "\"/>" + "</schema>";
                        Source[] sources = new Source[]{new DOMSource(schemaDom), new StreamSource(new StringReader(valueSchema))};
                        schema = factory.newSchema(sources);
                        Document property = (Document)componentProperty.getValue();
                        Element value = (Element)property.getDocumentElement().getFirstChild();
                        Validator validator = schema.newValidator();
                        validator.validate(new DOMSource(value));
                    }
                    catch (Exception e) {
                        Monitor.error(monitor, (Object)this, "org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", "PropertyValueDoesNotMatchComplexType", componentProperty.getName(), component.getName(), componentProperty.getXSDType().toString(), e.getMessage());
                    }
                }
            }
        } else if (propertyElementType != null) {
            // empty if block
        }
    }

    private void processPropertySourceAttribute(Component outerComponent, Composite parentComposite, Component component, ComponentProperty componentProperty, Monitor monitor) {
        block9: {
            String source = componentProperty.getSource();
            if (source == null) {
                return;
            }
            try {
                String sourceName = this.extractSourcePropertyName(source);
                Property sourceProp = null;
                sourceProp = outerComponent != null ? outerComponent.getProperty(sourceName) : parentComposite.getProperty(sourceName);
                if (sourceProp == null) {
                    Monitor.error(monitor, (Object)this, "org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", "PropertySourceNotFound", source, componentProperty.getName(), component.getName());
                    break block9;
                }
                Document sourcePropValue = (Document)sourceProp.getValue();
                try {
                    Document node = this.evaluateXPath2(sourcePropValue, componentProperty.getSourceXPathExpression(), this.documentBuilderFactory);
                    if (node != null) {
                        componentProperty.setValue(node);
                        if (componentProperty.getXSDElement() == null) {
                            componentProperty.setXSDElement(sourceProp.getXSDElement());
                        }
                        if (componentProperty.getXSDType() == null) {
                            componentProperty.setXSDType(sourceProp.getXSDType());
                        }
                        break block9;
                    }
                    Monitor.warning(monitor, (Object)this, "org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", "PropertyXpathExpressionReturnedNull", component.getName(), componentProperty.getName(), componentProperty.getSource());
                }
                catch (Exception ex) {
                    Monitor.error(monitor, (Object)this, "org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", "PropertySourceXpathInvalid", source, componentProperty.getName(), component.getName(), ex);
                }
            }
            catch (IllegalArgumentException e) {
                Monitor.error(monitor, (Object)this, "org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", "PropertySourceValueInvalid", source, componentProperty.getName(), component.getName());
            }
        }
    }

    private String extractSourcePropertyName(String source) throws IllegalArgumentException {
        String propertyName = null;
        if (source.charAt(0) != '$') {
            throw new IllegalArgumentException("Source value does not start with '$'");
        }
        int index = source.indexOf(47);
        int bracket = source.indexOf(91);
        propertyName = index == -1 && bracket == -1 ? source.substring(1) : (bracket == -1 ? source.substring(1, index) : (index == -1 ? source.substring(1, bracket) : (bracket < index ? source.substring(1, bracket) : source.substring(1, index))));
        return propertyName;
    }

    private void processPropertyFileAttribute(Component component, ComponentProperty componentProperty, Monitor monitor) {
        String file = componentProperty.getFile();
        if (file == null) {
            return;
        }
        try {
            Document document = this.readPropertyFileData(file);
            Element docElement = document.getDocumentElement();
            if (docElement == null) {
                throw new Exception("Property File has no XML document element");
            }
            if (!"values".equals(docElement.getLocalName())) {
                throw new Exception("Property File does not start with <values/> element");
            }
            NodeList values = docElement.getChildNodes();
            Document newdoc = this.documentBuilderFactory.newDocumentBuilder().newDocument();
            Element newProperty = newdoc.createElementNS(SCA11_NS, "property");
            newdoc.appendChild(newProperty);
            int count = 0;
            for (int i = 0; i < values.getLength(); ++i) {
                Node valueNode = values.item(i);
                if (valueNode.getNodeType() != 1) continue;
                newProperty.appendChild(newdoc.importNode(values.item(i), true));
                ++count;
            }
            if (count == 0) {
                throw new Exception("Property File has no property values");
            }
            componentProperty.setValue(newdoc);
        }
        catch (Exception ex) {
            Monitor.error(monitor, (Object)this, "org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", "PropertyFileValueInvalid", file, componentProperty.getName(), component.getName(), ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Document readPropertyFileData(String file) throws Exception {
        Document doc = null;
        URI uri = URI.create(file);
        URL url = uri.toURL();
        URLConnection connection = url.openConnection();
        connection.setUseCaches(false);
        InputStream is = null;
        try {
            is = connection.getInputStream();
            SAXSource streamSource = new SAXSource(new InputSource(is));
            DOMResult result = new DOMResult();
            Transformer transformer = this.transformerFactory.newTransformer();
            transformer.transform(streamSource, result);
            doc = (Document)result.getNode();
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
        return doc;
    }

    private Document evaluateXPath(Document node, XPathExpression expression, DocumentBuilderFactory documentBuilderFactory) throws XPathExpressionException, ParserConfigurationException {
        Element property = node.getDocumentElement();
        Node value = property.getFirstChild();
        Node result = (Node)expression.evaluate(value, XPathConstants.NODE);
        if (result == null) {
            return null;
        }
        if (result instanceof Document) {
            return (Document)result;
        }
        Document document = documentBuilderFactory.newDocumentBuilder().newDocument();
        Element newProperty = document.createElementNS(SCA11_NS, "property");
        if (result.getNodeType() == 1) {
            newProperty.appendChild(document.importNode(result, true));
        } else {
            Element newValue = document.createElementNS(SCA11_NS, "value");
            newValue.appendChild(document.importNode(result, true));
            newProperty.appendChild(newValue);
        }
        document.appendChild(newProperty);
        return document;
    }

    private Document evaluateXPath2(Document node, XPathExpression expression, DocumentBuilderFactory documentBuilderFactory) throws XPathExpressionException, ParserConfigurationException {
        Element property = node.getDocumentElement();
        NodeList result = (NodeList)expression.evaluate(property, XPathConstants.NODESET);
        if (result == null || result.getLength() == 0) {
            return null;
        }
        if (result instanceof Document) {
            return (Document)((Object)result);
        }
        Document document = documentBuilderFactory.newDocumentBuilder().newDocument();
        Element newProperty = document.createElementNS(SCA11_NS, "property");
        for (int i = 0; i < result.getLength(); ++i) {
            if (result.item(i).getNodeType() == 1) {
                newProperty.appendChild(document.importNode(result.item(i), true));
                continue;
            }
            Element newValue = document.createElementNS(SCA11_NS, "value");
            newValue.appendChild(document.importNode(result.item(i), true));
            newProperty.appendChild(newValue);
        }
        document.appendChild(newProperty);
        return document;
    }

    private void createCallbackReference(Component component, ComponentService service, Monitor monitor) {
        if (service.getInterfaceContract() != null && service.getInterfaceContract().getCallbackInterface() != null) {
            ComponentReference callbackReference = this.assemblyFactory.createComponentReference();
            callbackReference.setForCallback(true);
            callbackReference.setName(service.getName());
            callbackReference.setMultiplicity(Multiplicity.ZERO_N);
            try {
                InterfaceContract contract = (InterfaceContract)service.getInterfaceContract().clone();
                contract.setInterface(contract.getCallbackInterface());
                contract.setCallbackInterface(null);
                contract.setNormalizedWSDLContract(null);
                callbackReference.setInterfaceContract(contract);
            }
            catch (CloneNotSupportedException e) {
                // empty catch block
            }
            Service implService = service.getService();
            if (implService != null) {
                Reference implReference;
                if (implService instanceof CompositeService) {
                    CompositeReference implCompReference = this.assemblyFactory.createCompositeReference();
                    implCompReference.getPromotedComponents().add(((CompositeService)implService).getPromotedComponent());
                    if (!((CompositeService)implService).getPromotedService().isUnresolved()) {
                        String referenceName = ((CompositeService)implService).getPromotedService().getName();
                        ComponentReference promotedReference = ((CompositeService)implService).getPromotedComponent().getReference(referenceName);
                        if (promotedReference != null) {
                            implCompReference.getPromotedReferences().add(promotedReference);
                        } else {
                            Monitor.error(monitor, (Object)this, "org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", "PromotedCallbackReferenceNotFound", component.getName(), service.getName(), ((CompositeService)implService).getPromotedComponent().getName(), referenceName);
                        }
                    }
                    implReference = implCompReference;
                    Implementation implementation = component.getImplementation();
                    if (implementation != null && implementation instanceof Composite) {
                        ((Composite)implementation).getReferences().add(implCompReference);
                    }
                } else {
                    implReference = this.assemblyFactory.createReference();
                }
                implReference.setName(implService.getName());
                implReference.setMultiplicity(Multiplicity.ZERO_N);
                try {
                    InterfaceContract implContract = (InterfaceContract)implService.getInterfaceContract().clone();
                    implContract.setInterface(implContract.getCallbackInterface());
                    implContract.setCallbackInterface(null);
                    implContract.setNormalizedWSDLContract(null);
                    implReference.setInterfaceContract(implContract);
                }
                catch (CloneNotSupportedException e) {
                    // empty catch block
                }
                callbackReference.setReference(implReference);
            }
            component.getReferences().add(callbackReference);
            if (callbackReference.getBindings().isEmpty()) {
                if (service.getCallback() != null && service.getCallback().getBindings().size() > 0) {
                    callbackReference.getBindings().addAll(service.getCallback().getBindings());
                } else {
                    List<Binding> serviceBindings = service.getBindings();
                    for (Binding serviceBinding : serviceBindings) {
                        try {
                            Binding referenceBinding = (Binding)serviceBinding.clone();
                            referenceBinding.setURI(null);
                            callbackReference.getBindings().add(referenceBinding);
                        }
                        catch (CloneNotSupportedException e) {}
                    }
                    if (serviceBindings.size() == 0) {
                        this.createSCABinding(callbackReference, null);
                    }
                }
            }
            service.setCallbackReference(callbackReference);
        }
    }

    private void createCallbackService(Component component, ComponentReference reference, Monitor monitor) {
        if (reference.getInterfaceContract() != null && reference.getInterfaceContract().getCallbackInterface() != null) {
            ComponentService callbackService = this.assemblyFactory.createComponentService();
            callbackService.setForCallback(true);
            callbackService.setName(reference.getName());
            try {
                InterfaceContract contract = (InterfaceContract)reference.getInterfaceContract().clone();
                contract.setInterface(contract.getCallbackInterface());
                contract.setCallbackInterface(null);
                contract.setNormalizedWSDLContract(null);
                callbackService.setInterfaceContract(contract);
            }
            catch (CloneNotSupportedException e) {
                // empty catch block
            }
            Reference implReference = reference.getReference();
            if (implReference != null) {
                Service implService;
                if (implReference instanceof CompositeReference) {
                    CompositeService implCompService = this.assemblyFactory.createCompositeService();
                    implCompService.setPromotedComponent(((CompositeReference)implReference).getPromotedComponents().get(0));
                    implCompService.setForCallback(true);
                    if (!((CompositeReference)implReference).getPromotedReferences().get(0).isUnresolved()) {
                        String serviceName = ((CompositeReference)implReference).getPromotedReferences().get(0).getName();
                        ComponentService promotedService = ((CompositeReference)implReference).getPromotedComponents().get(0).getService(serviceName);
                        if (promotedService != null) {
                            implCompService.setPromotedService(promotedService);
                        } else {
                            Monitor.error(monitor, (Object)this, "org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", "PromotedCallbackServiceNotFound", component.getName(), reference.getName(), ((CompositeReference)implReference).getPromotedComponents().get(0).getName(), serviceName);
                        }
                    }
                    implService = implCompService;
                    Implementation implementation = component.getImplementation();
                    if (implementation != null && implementation instanceof Composite) {
                        ((Composite)implementation).getServices().add(implCompService);
                    }
                } else {
                    implService = this.assemblyFactory.createService();
                }
                implService.setName(implReference.getName());
                try {
                    InterfaceContract implContract = (InterfaceContract)implReference.getInterfaceContract().clone();
                    implContract.setInterface(implContract.getCallbackInterface());
                    implContract.setCallbackInterface(null);
                    implContract.setNormalizedWSDLContract(null);
                    implService.setInterfaceContract(implContract);
                }
                catch (CloneNotSupportedException e) {
                    // empty catch block
                }
                callbackService.setService(implService);
            }
            component.getServices().add(callbackService);
            if (callbackService.getBindings().isEmpty()) {
                if (reference.getCallback() != null && reference.getCallback().getBindings().size() > 0) {
                    callbackService.getBindings().addAll(reference.getCallback().getBindings());
                } else if (reference.getBindings().size() > 0) {
                    for (Binding binding : reference.getBindings()) {
                        try {
                            Binding clonedBinding = (Binding)binding.clone();
                            clonedBinding.setURI(null);
                            callbackService.getBindings().add(clonedBinding);
                        }
                        catch (CloneNotSupportedException ex) {}
                    }
                } else {
                    this.createSCABinding(callbackService, null);
                }
            }
            reference.setCallbackService(callbackService);
        }
    }

    protected void createSCABinding(Contract contract, Definitions definitions) {
        SCABinding scaBinding = this.scaBindingFactory.createSCABinding();
        scaBinding.setName(contract.getName());
        if (definitions != null) {
            for (BindingType attachPointType : definitions.getBindingTypes()) {
                if (!attachPointType.getType().equals(BINDING_SCA_QNAME)) continue;
                ((PolicySubject)((Object)scaBinding)).setExtensionType(attachPointType);
            }
        }
        contract.getBindings().add(scaBinding);
        contract.setOverridingBindings(false);
    }

    private boolean isPropertyValueSet(Property property) {
        Document value = (Document)property.getValue();
        if (value == null) {
            return false;
        }
        if (value.getDocumentElement() == null) {
            return false;
        }
        return value.getDocumentElement().getChildNodes().getLength() != 0;
    }

    private boolean isPropertyManyValued(Property property) {
        Document value;
        return this.isPropertyValueSet(property) && (value = (Document)property.getValue()).getDocumentElement().getChildNodes().getLength() > 1;
    }

    private boolean isValidMultiplicityOverride(Multiplicity definedMul, Multiplicity overridenMul) {
        if (definedMul != overridenMul) {
            switch (definedMul) {
                case ZERO_N: {
                    return overridenMul == Multiplicity.ZERO_ONE || overridenMul == Multiplicity.ONE_ONE || overridenMul == Multiplicity.ONE_N;
                }
                case ONE_N: {
                    return overridenMul == Multiplicity.ONE_ONE;
                }
                case ZERO_ONE: {
                    return overridenMul == Multiplicity.ONE_ONE;
                }
            }
            return false;
        }
        return true;
    }

    private void calculateServiceInterfaceContract(Component component, Service topContract, Service bottomContract, BuilderContext context) {
        InterfaceContract topInterfaceContract = topContract.getInterfaceContract();
        InterfaceContract bottomInterfaceContract = bottomContract.getInterfaceContract();
        if (topInterfaceContract == null) {
            topContract.setInterfaceContract(bottomInterfaceContract);
        } else if (bottomInterfaceContract != null) {
            if (topInterfaceContract.getInterface().isRemotableSetFromSCDL() && !bottomInterfaceContract.getInterface().isRemotable() && topInterfaceContract.getInterface().isRemotable()) {
                bottomInterfaceContract.getInterface().setRemotable(true);
            }
            boolean isCompatible = true;
            String incompatibilityReason = "";
            try {
                isCompatible = this.checkSubsetCompatibility(topInterfaceContract, bottomInterfaceContract, context);
            }
            catch (IncompatibleInterfaceContractException ex) {
                isCompatible = false;
                incompatibilityReason = ex.getMessage();
            }
            if (!isCompatible) {
                Monitor.error(context.getMonitor(), (Object)this, "org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", "ServiceIncompatibleComponentInterface", component.getName(), topContract.getName(), incompatibilityReason);
            }
            if (topInterfaceContract.getInterface() == null) {
                topInterfaceContract.setInterface(bottomInterfaceContract.getInterface());
            }
            if (topInterfaceContract.getCallbackInterface() == null) {
                topInterfaceContract.setCallbackInterface(bottomInterfaceContract.getCallbackInterface());
            }
        }
    }

    private void calculateReferenceInterfaceContract(Component component, Reference topContract, Reference bottomContract, BuilderContext context) {
        InterfaceContract topInterfaceContract = topContract.getInterfaceContract();
        InterfaceContract bottomInterfaceContract = bottomContract.getInterfaceContract();
        if (topInterfaceContract == null) {
            topContract.setInterfaceContract(bottomInterfaceContract);
        } else if (bottomInterfaceContract != null) {
            if (topInterfaceContract.getInterface().isRemotableSetFromSCDL() && !bottomInterfaceContract.getInterface().isRemotable() && topInterfaceContract.getInterface().isRemotable()) {
                bottomInterfaceContract.getInterface().setRemotable(true);
            }
            boolean isCompatible = true;
            String incompatibilityReason = "";
            try {
                isCompatible = this.checkSubsetCompatibility(bottomInterfaceContract, topInterfaceContract, context);
            }
            catch (IncompatibleInterfaceContractException ex) {
                isCompatible = false;
                incompatibilityReason = ex.getMessage();
            }
            if (!isCompatible) {
                Monitor.error(context.getMonitor(), (Object)this, "org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", "ReferenceIncompatibleComponentInterface", component.getName(), topContract.getName(), incompatibilityReason);
            }
            if (topInterfaceContract.getInterface() == null) {
                topInterfaceContract.setInterface(bottomInterfaceContract.getInterface());
            }
            if (topInterfaceContract.getCallbackInterface() == null) {
                topInterfaceContract.setCallbackInterface(bottomInterfaceContract.getCallbackInterface());
            }
        }
    }

    private void calculateBindings(Component component, Service componentService, Service componentTypeService, BuilderContext context) {
        Monitor monitor = context.getMonitor();
        if (componentService.getBindings().isEmpty()) {
            componentService.getBindings().addAll(componentTypeService.getBindings());
        }
        if (componentService.getBindings().isEmpty()) {
            this.createSCABinding(componentService, context.getDefinitions());
        }
        if (componentService.getCallback() == null) {
            componentService.setCallback(componentTypeService.getCallback());
            if (componentService.getCallback() == null) {
                componentService.setCallback(this.assemblyFactory.createCallback());
            }
        } else if (componentService.getCallback().getBindings().isEmpty() && componentTypeService.getCallback() != null) {
            componentService.getCallback().getBindings().addAll(componentTypeService.getCallback().getBindings());
        }
        for (Binding binding : componentService.getBindings()) {
            if (!(binding instanceof SCABinding) || binding.getURI() == null || binding.getURI().length() <= 0) continue;
            Monitor.error(monitor, (Object)this, "org.apache.tuscany.sca.assembly.builder.assembly-validation-messages", "URIFoundOnServiceSCABinding", binding.getName(), component.getName(), componentService.getName(), binding.getURI());
        }
    }

    private void calculateBindings(Reference componentReference, Reference componentTypeReference) {
        if (componentReference.getBindings().isEmpty()) {
            componentReference.getBindings().addAll(componentTypeReference.getBindings());
        }
        if (componentReference.getCallback() == null) {
            componentReference.setCallback(componentTypeReference.getCallback());
        } else if (componentReference.getCallback().getBindings().isEmpty() && componentTypeReference.getCallback() != null) {
            componentReference.getCallback().getBindings().addAll(componentTypeReference.getCallback().getBindings());
        }
    }

    private boolean checkSubsetCompatibility(InterfaceContract contractA, InterfaceContract contractB, BuilderContext context) throws IncompatibleInterfaceContractException {
        if (contractA.getClass() != contractB.getClass()) {
            if (contractA instanceof JavaInterfaceContract) {
                this.contractBuilder.build(contractA, context);
                contractA = ((JavaInterfaceContract)contractA).getNormalizedWSDLContract();
            }
            if (contractB instanceof JavaInterfaceContract) {
                this.contractBuilder.build(contractB, context);
                contractB = ((JavaInterfaceContract)contractB).getNormalizedWSDLContract();
            }
        }
        return this.interfaceContractMapper.checkCompatibility(contractA, contractB, Compatibility.SUBSET, false, false);
    }
}

