/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.ws.jaxws;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.wsdl.Binding;
import javax.wsdl.BindingOperation;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.OperationType;
import javax.wsdl.PortType;
import javax.wsdl.extensions.AttributeExtensible;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.extensions.soap.SOAPBody;
import javax.wsdl.extensions.soap.SOAPOperation;
import javax.wsdl.extensions.soap12.SOAP12Address;
import javax.wsdl.extensions.soap12.SOAP12Operation;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.DetailEntry;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.SOAPFaultException;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.binding.ws.WebServiceBinding;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.util.FaultException;
import org.apache.tuscany.sca.interfacedef.wsdl.WSDLInterface;
import org.apache.tuscany.sca.invocation.DataExchangeSemantics;
import org.apache.tuscany.sca.invocation.Invoker;
import org.apache.tuscany.sca.invocation.Message;
import org.apache.tuscany.sca.runtime.RuntimeEndpointReference;
import org.oasisopen.sca.ServiceRuntimeException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JAXWSBindingInvoker
implements Invoker,
DataExchangeSemantics {
    private static final String SCA11_TUSCANY_NS = "http://tuscany.apache.org/xmlns/sca/1.1";
    public static final String WSA_FINAL_NAMESPACE = "http://www.w3.org/2005/08/addressing";
    public static final QName QNAME_WSA_ADDRESS = new QName("http://www.w3.org/2005/08/addressing", "Address", "wsa");
    public static final QName QNAME_WSA_FROM = new QName("http://www.w3.org/2005/08/addressing", "From", "wsa");
    public static final QName QNAME_WSA_MESSAGEID = new QName("http://www.w3.org/2005/08/addressing", "MessageID", "wsa");
    public static final QName QNAME_WSA_TO = new QName("http://www.w3.org/2005/08/addressing", "To", "wsa");
    public static final QName QNAME_WSA_ACTION = new QName("http://www.w3.org/2005/08/addressing", "Action", "wsa");
    public static final QName QNAME_WSA_RELATESTO = new QName("http://www.w3.org/2005/08/addressing", "RelatesTo", "wsa");
    private static final QName submissionWSAWNS = new QName("http://schemas.xmlsoap.org/ws/2004/08/addressing", QNAME_WSA_ACTION.getLocalPart());
    private static final QName finalWSANS = new QName("http://www.w3.org/2005/08/addressing", QNAME_WSA_ACTION.getLocalPart());
    private static final QName finalWSAWNS = new QName("http://www.w3.org/2006/05/addressing/wsdl", QNAME_WSA_ACTION.getLocalPart());
    private static final QName finalWSAMNS = new QName("http://www.w3.org/2007/05/addressing/metadata", QNAME_WSA_ACTION.getLocalPart());
    public static final String TUSCANY_PREFIX = "tuscany";
    public static final QName CALLBACK_ID_REFPARM_QN = new QName("http://tuscany.apache.org/xmlns/sca/1.1", "CallbackID", "tuscany");
    public static final QName CONVERSATION_ID_REFPARM_QN = new QName("http://tuscany.apache.org/xmlns/sca/1.1", "ConversationID", "tuscany");
    private boolean dynamicDispatchForCallback = false;
    protected Dispatch<SOAPMessage> staticDispatch;
    private MessageFactory messageFactory;
    private Operation operation;
    protected WebServiceBinding wsBinding;
    private RuntimeEndpointReference endpointReference;
    private static String WS_REF_PARMS = "WS_REFERENCE_PARAMETERS";
    protected static String SCA_CALLBACK_REL = "http://docs.oasis-open.org/opencsa/sca-bindings/ws/callback";
    private static final String URN = "urn";
    private static final String SLASH = "/";
    private static final String COLON = ":";
    private static final String REQUEST = "Request";
    private static final String RESPONSE = "Response";

    public JAXWSBindingInvoker(Operation operation, WebServiceFeature[] features, MessageFactory messageFactory, WebServiceBinding wsBinding, RuntimeEndpointReference endpointReference) {
        this.messageFactory = messageFactory;
        this.operation = operation;
        this.wsBinding = wsBinding;
        this.endpointReference = endpointReference;
        if (endpointReference.getReference().isForCallback()) {
            this.dynamicDispatchForCallback = true;
        } else {
            this.staticDispatch = this.createStaticDispatch();
        }
    }

    protected Dispatch<SOAPMessage> createDynamicDispatch() {
        QName serviceName = this.wsBinding.getService().getQName();
        QName portName = new QName(serviceName.getNamespaceURI(), this.wsBinding.getPort().getName());
        Service service = Service.create((QName)serviceName);
        service.addPort(portName, "http://schemas.xmlsoap.org/wsdl/soap/http", this.endpointReference.getDeployedURI());
        return service.createDispatch(portName, SOAPMessage.class, Service.Mode.MESSAGE);
    }

    protected Dispatch<SOAPMessage> createStaticDispatch() {
        URL wsdlLocation = null;
        try {
            if (this.wsBinding.getGeneratedWSDLDocument() != null && this.wsBinding.getGeneratedWSDLDocument().getDocumentBaseURI() != null) {
                wsdlLocation = new URL(this.wsBinding.getGeneratedWSDLDocument().getDocumentBaseURI());
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.wsBinding.getUserSpecifiedWSDLDefinition().getLocation() != null) {
                wsdlLocation = this.wsBinding.getUserSpecifiedWSDLDefinition().getLocation().toURL();
            }
        }
        catch (MalformedURLException e1) {
            e1.printStackTrace();
        }
        if (wsdlLocation != null) {
            return this.createDispatchFromWSDL(wsdlLocation);
        }
        return this.createDispatchFromURI(this.endpointReference.getDeployedURI());
    }

    protected Dispatch<SOAPMessage> createDynamicDispatch(String uri) {
        return this.createDispatchFromURI(uri);
    }

    private Dispatch<SOAPMessage> createDispatchFromWSDL(URL wsdlLocation) {
        QName serviceName = this.wsBinding.getServiceName();
        QName portName = new QName(serviceName.getNamespaceURI(), this.wsBinding.getPortName());
        Service service = Service.create((URL)wsdlLocation, (QName)serviceName);
        return service.createDispatch(portName, SOAPMessage.class, Service.Mode.MESSAGE);
    }

    protected Dispatch<SOAPMessage> createDispatchFromURI(String uri) {
        QName serviceName = this.wsBinding.getService().getQName();
        QName portName = new QName(serviceName.getNamespaceURI(), this.wsBinding.getPort().getName());
        Service service = Service.create((QName)serviceName);
        service.addPort(portName, "http://schemas.xmlsoap.org/wsdl/soap/http", uri);
        return service.createDispatch(portName, SOAPMessage.class, Service.Mode.MESSAGE);
    }

    @Override
    public Message invoke(Message msg) {
        try {
            SOAPFault fault;
            javax.xml.soap.SOAPBody body;
            SOAPMessage resp = this.invokeTarget(msg);
            if (resp != null && (body = resp.getSOAPBody()) != null && (fault = body.getFault()) == null) {
                Element payload = (Element)body.getChildElements().next();
                if (this.wsBinding.isRpcLiteral()) {
                    Element unwrappedPayload = null;
                    NodeList children = payload.getChildNodes();
                    for (int i = 0; i < children.getLength(); ++i) {
                        Node nextChild = children.item(i);
                        if (!(nextChild instanceof Element)) continue;
                        unwrappedPayload = (Element)nextChild;
                        break;
                    }
                    msg.setBody(unwrappedPayload);
                } else {
                    msg.setBody(payload);
                }
            }
        }
        catch (SOAPFaultException e) {
            this.setFault(msg, e);
        }
        catch (WebServiceException e) {
            msg.setFaultBody(e);
        }
        catch (SOAPException e) {
            msg.setFaultBody(e);
        }
        catch (Throwable e) {
            msg.setFaultBody(e);
        }
        return msg;
    }

    private void setFault(Message msg, SOAPFaultException e) {
        SOAPFault fault = e.getFault();
        Detail detail = fault.getDetail();
        if (detail != null) {
            Iterator i = detail.getDetailEntries();
            while (i.hasNext()) {
                DetailEntry entry = (DetailEntry)i.next();
                FaultException fe = new FaultException(e.getMessage(), entry, e);
                fe.setFaultName(entry.getElementQName());
                msg.setFaultBody(fe);
            }
        } else {
            msg.setFaultBody(e);
        }
    }

    protected String getSOAPAction(String operationName) {
        Binding binding = this.wsBinding.getBinding();
        if (binding != null) {
            for (Object o : binding.getBindingOperations()) {
                BindingOperation bop = (BindingOperation)o;
                if (!bop.getName().equalsIgnoreCase(operationName)) continue;
                for (Object o2 : bop.getExtensibilityElements()) {
                    if (o2 instanceof SOAPOperation) {
                        return ((SOAPOperation)o2).getSoapActionURI();
                    }
                    if (!(o2 instanceof SOAP12Operation)) continue;
                    return ((SOAP12Operation)o2).getSoapActionURI();
                }
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected SOAPMessage invokeTarget(Message msg) throws SOAPException {
        SOAPMessage soapMessage = this.messageFactory.createMessage();
        SOAPPart soapPart = soapMessage.getSOAPPart();
        SOAPEnvelope envelope = soapPart.getEnvelope();
        String action = this.getSOAPAction(this.operation.getName());
        this.setHeaders(envelope.getHeader(), msg, action);
        javax.xml.soap.SOAPBody body = envelope.getBody();
        Object[] args = (Object[])msg.getBody();
        if (this.wsBinding.isRpcLiteral()) {
            String wrapperNamespace = null;
            if (this.wsBinding.getBinding() != null) {
                block0: for (BindingOperation bOp : this.wsBinding.getBinding().getBindingOperations()) {
                    if (!bOp.getName().equals(msg.getOperation().getName())) continue;
                    for (Object ext : bOp.getBindingInput().getExtensibilityElements()) {
                        if (!(ext instanceof SOAPBody)) continue;
                        wrapperNamespace = ((SOAPBody)ext).getNamespaceURI();
                        break block0;
                    }
                }
            }
            if (wrapperNamespace == null) {
                wrapperNamespace = this.wsBinding.getUserSpecifiedWSDLDefinition().getNamespace();
            }
            Element rpcOperationWrapper = body.getOwnerDocument().createElementNS(wrapperNamespace, msg.getOperation().getName());
            for (Object arg : args) {
                Node next = (Node)arg;
                Node nextImported = body.getOwnerDocument().importNode(next, true);
                rpcOperationWrapper.appendChild(nextImported);
            }
            body.appendChild((Node)rpcOperationWrapper);
        } else {
            if (this.wsBinding.isRpcEncoded()) {
                throw new ServiceRuntimeException("rpc/encoded WSDL style not supported for endpoint reference " + this.endpointReference);
            }
            if (this.wsBinding.isDocEncoded()) {
                throw new ServiceRuntimeException("doc/encoded WSDL style not supported for endpoint reference " + this.endpointReference);
            }
            Node msgNode = body.getOwnerDocument().importNode((Node)args[0], true);
            body.appendChild(msgNode);
        }
        soapMessage.saveChanges();
        Dispatch<SOAPMessage> invocationDispatch = null;
        if (this.dynamicDispatchForCallback) {
            Endpoint ep = msg.getTo();
            if (ep == null) throw new ServiceRuntimeException("[BWS20025] Unable to determine destination endpoint for endpoint reference " + this.endpointReference);
            if (ep.getBinding() == null) throw new ServiceRuntimeException("[BWS20025] Unable to determine destination endpoint for endpoint reference " + this.endpointReference);
            String address = ep.getDeployedURI();
            invocationDispatch = this.createDynamicDispatch(address);
        } else {
            invocationDispatch = this.staticDispatch;
        }
        if (this.operation.isNonBlocking()) {
            invocationDispatch.invokeOneWay((Object)soapMessage);
            return null;
        }
        if (action == null) return (SOAPMessage)invocationDispatch.invoke((Object)soapMessage);
        invocationDispatch.getRequestContext().put("javax.xml.ws.soap.http.soapaction.use", true);
        invocationDispatch.getRequestContext().put("javax.xml.ws.soap.http.soapaction.uri", action);
        return (SOAPMessage)invocationDispatch.invoke((Object)soapMessage);
    }

    protected void setHeaders(SOAPHeader sh, Message msg, String action) throws SOAPException {
        Endpoint callbackEndpoint = msg.getFrom().getCallbackEndpoint();
        if (callbackEndpoint != null) {
            SOAPHeaderElement fromH = sh.addHeaderElement(QNAME_WSA_FROM);
            SOAPElement fromAddress = fromH.addChildElement(QNAME_WSA_ADDRESS);
            fromAddress.setTextContent(callbackEndpoint.getDeployedURI());
            this.addWSAActionHeader(sh, action);
            if (!this.operation.isNonBlocking()) {
                String messageId = UUID.randomUUID().toString();
                SOAPHeaderElement msgIdHeader = sh.addHeaderElement(QNAME_WSA_MESSAGEID);
                msgIdHeader.setTextContent(messageId);
            }
        }
        String toAddress = this.getToAddress(msg);
        if (this.isInvocationForCallback(msg)) {
            this.addWSAToHeader(sh, toAddress, msg);
            this.addWSARefParms(sh, msg);
            this.addWSAActionHeader(sh, action);
            this.addWSARelatesTo(sh, msg);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getToAddress(Message msg) throws ServiceRuntimeException {
        String address = null;
        String to = this.getPortLocation();
        if (to != null) return to;
        Endpoint ep = msg.getTo();
        if (ep == null) throw new ServiceRuntimeException("[BWS20025] Unable to determine destination endpoint for endpoint reference " + this.endpointReference);
        if (ep.getBinding() == null) throw new ServiceRuntimeException("[BWS20025] Unable to determine destination endpoint for endpoint reference " + this.endpointReference);
        return ep.getDeployedURI();
    }

    protected String getPortLocation() {
        String ep = null;
        if (this.wsBinding.getPort() != null) {
            List wsdlPortExtensions = this.wsBinding.getPort().getExtensibilityElements();
            for (Object extension : wsdlPortExtensions) {
                if (extension instanceof SOAPAddress) {
                    ep = ((SOAPAddress)extension).getLocationURI();
                    break;
                }
                if (!(extension instanceof SOAP12Address)) continue;
                SOAP12Address address = (SOAP12Address)extension;
                ep = address.getLocationURI();
                break;
            }
        }
        if (ep == null || ep.equals("")) {
            ep = this.endpointReference.getDeployedURI();
        }
        return ep;
    }

    private void addWSAToHeader(SOAPHeader sh, String address, Message msg) throws SOAPException {
        SOAPHeaderElement toH = sh.addHeaderElement(QNAME_WSA_TO);
        toH.setTextContent(address);
    }

    protected void addWSARefParms(SOAPHeader sh, Message msg) throws SOAPException {
    }

    private void addWSAActionHeader(SOAPHeader sh, String action) throws SOAPException {
        if (action == null) {
            PortType portType = ((WSDLInterface)this.wsBinding.getBindingInterfaceContract().getInterface()).getPortType();
            javax.wsdl.Operation op = portType.getOperation(this.operation.getName(), null, null);
            action = JAXWSBindingInvoker.getActionFromInputElement(this.wsBinding.getGeneratedWSDLDocument(), portType, op, op.getInput());
        }
        SOAPHeaderElement actionH = sh.addHeaderElement(QNAME_WSA_ACTION);
        actionH.setTextContent(action == null ? "" : action);
    }

    private void addWSARelatesTo(SOAPHeader sh, Message msg) throws SOAPException {
        String idValue = (String)msg.getHeaders().get("RELATES_TO");
        if (idValue != null) {
            SOAPHeaderElement relatesToH = sh.addHeaderElement(QNAME_WSA_RELATESTO);
            relatesToH.addAttribute(new QName(null, "RelationshipType"), SCA_CALLBACK_REL);
            relatesToH.setTextContent(idValue);
        }
    }

    private boolean isInvocationForCallback(Message msg) {
        ComponentReference ref;
        EndpointReference fromEPR = msg.getFrom();
        if (fromEPR != null && (ref = fromEPR.getReference()) != null) {
            return ref.isForCallback();
        }
        return false;
    }

    public static String getActionFromInputElement(Definition def, PortType wsdl4jPortType, javax.wsdl.Operation op, Input input) {
        String result = JAXWSBindingInvoker.getWSAWActionExtensionAttribute((AttributeExtensible)input);
        if (result == null) {
            result = JAXWSBindingInvoker.generateActionFromInputElement(def, wsdl4jPortType, op, input);
        }
        return result;
    }

    private static String getWSAWActionExtensionAttribute(AttributeExtensible ae) {
        Object attribute = ae.getExtensionAttribute(submissionWSAWNS);
        if (attribute == null) {
            attribute = ae.getExtensionAttribute(finalWSAMNS);
        }
        if (attribute == null) {
            attribute = ae.getExtensionAttribute(finalWSAWNS);
        }
        if (attribute == null) {
            attribute = ae.getExtensionAttribute(finalWSANS);
        }
        if (attribute instanceof List) {
            List l = (List)attribute;
            attribute = l.size() > 0 ? l.get(0) : null;
        }
        if (attribute instanceof QName) {
            QName qn = (QName)attribute;
            attribute = qn.getLocalPart();
        }
        if (attribute instanceof String) {
            String result = (String)attribute;
            return result;
        }
        return null;
    }

    public static String generateActionFromInputElement(Definition def, PortType wsdl4jPortType, javax.wsdl.Operation op, Input input) {
        String targetNamespace = def.getTargetNamespace();
        String delimiter = SLASH;
        if (targetNamespace.toLowerCase().startsWith(URN)) {
            delimiter = COLON;
        }
        String portTypeName = wsdl4jPortType.getQName().getLocalPart();
        String inputName = JAXWSBindingInvoker.getNameFromInputElement(op, input);
        StringBuffer sb = new StringBuffer();
        sb.append(targetNamespace);
        if (!targetNamespace.endsWith(delimiter)) {
            sb.append(delimiter);
        }
        sb.append(portTypeName);
        sb.append(delimiter);
        sb.append(inputName);
        String result = sb.toString();
        return result;
    }

    private static String getNameFromInputElement(javax.wsdl.Operation op, Input input) {
        String result = input.getName();
        if (result == null) {
            OperationType operationType = op.getStyle();
            if (null != operationType) {
                if (operationType.equals(OperationType.REQUEST_RESPONSE)) {
                    result = op.getName() + REQUEST;
                } else if (operationType.equals(OperationType.SOLICIT_RESPONSE)) {
                    result = op.getName() + RESPONSE;
                }
            }
            if (result == null) {
                result = op.getName();
            }
        }
        return result;
    }

    @Override
    public boolean allowsPassByReference() {
        return true;
    }
}

