/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.sca.provider;

import org.apache.tuscany.sca.binding.local.LocalSCABindingInvocationInterceptor;
import org.apache.tuscany.sca.binding.sca.provider.DelegatingSCAServiceBindingProvider;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.invocation.InvocationChain;
import org.apache.tuscany.sca.invocation.InvokerAsyncResponse;
import org.apache.tuscany.sca.provider.EndpointAsyncProvider;
import org.apache.tuscany.sca.provider.EndpointProvider;
import org.apache.tuscany.sca.provider.OptimisingBindingProvider;
import org.apache.tuscany.sca.provider.SCABindingMapper;
import org.apache.tuscany.sca.provider.ServiceBindingProvider;
import org.apache.tuscany.sca.runtime.RuntimeEndpoint;

public class RuntimeSCAServiceBindingProvider
implements EndpointAsyncProvider,
OptimisingBindingProvider {
    private RuntimeEndpoint endpoint;
    private SCABindingMapper mapper;
    private ServiceBindingProvider delegatingBindingProvider;

    public RuntimeSCAServiceBindingProvider(SCABindingMapper scaBindingMapper, RuntimeEndpoint endpoint) {
        this.endpoint = endpoint;
        this.mapper = scaBindingMapper;
        this.getDelegatingProvider();
    }

    private ServiceBindingProvider getDelegatingProvider() {
        if (this.delegatingBindingProvider == null) {
            this.delegatingBindingProvider = new DelegatingSCAServiceBindingProvider(this.endpoint, this.mapper);
        }
        return this.delegatingBindingProvider;
    }

    @Override
    public InterfaceContract getBindingInterfaceContract() {
        return this.getDelegatingProvider().getBindingInterfaceContract();
    }

    @Override
    public boolean supportsOneWayInvocation() {
        return this.getDelegatingProvider().supportsOneWayInvocation();
    }

    @Override
    public void start() {
        this.getDelegatingProvider().start();
    }

    @Override
    public void stop() {
        this.endpoint.getBinding().setURI(null);
        this.getDelegatingProvider().stop();
    }

    @Override
    public void configure() {
        if (this.getDelegatingProvider() instanceof EndpointProvider) {
            ((EndpointProvider)this.getDelegatingProvider()).configure();
        }
    }

    @Override
    public boolean supportsNativeAsync() {
        return true;
    }

    @Override
    public InvokerAsyncResponse createAsyncResponseInvoker() {
        return ((EndpointAsyncProvider)this.getDelegatingProvider()).createAsyncResponseInvoker();
    }

    @Override
    public void optimiseBinding(RuntimeEndpoint ep) {
        for (InvocationChain chain : ep.getInvocationChains()) {
            chain.addHeadInterceptor("service.policy", new LocalSCABindingInvocationInterceptor());
        }
    }

    public RuntimeEndpoint getDelegateEndpoint() {
        return ((DelegatingSCAServiceBindingProvider)this.delegatingBindingProvider).getDelegateEndpoint();
    }
}

