/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.binding.corba.impl;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.xml.PolicySubjectProcessor;
import org.apache.tuscany.sca.binding.corba.CorbaBinding;
import org.apache.tuscany.sca.binding.corba.CorbaBindingFactory;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.policy.PolicyFactory;

public class CorbaBindingProcessor
implements StAXArtifactProcessor<CorbaBinding> {
    private CorbaBindingFactory factory;
    private PolicyFactory policyFactory;
    private PolicySubjectProcessor policyProcessor;

    public CorbaBindingProcessor(FactoryExtensionPoint modelFactories) {
        this.policyFactory = modelFactories.getFactory(PolicyFactory.class);
        this.factory = modelFactories.getFactory(CorbaBindingFactory.class);
        this.policyProcessor = new PolicySubjectProcessor(this.policyFactory);
    }

    @Override
    public QName getArtifactType() {
        return CorbaBinding.BINDING_CORBA_QNAME;
    }

    @Override
    public CorbaBinding read(XMLStreamReader reader, ProcessorContext context) throws ContributionReadException, XMLStreamException {
        String id;
        String uri;
        String name;
        CorbaBinding binding = this.factory.createCorbaBinding();
        this.policyProcessor.readPolicies(binding, reader);
        binding.setHost(reader.getAttributeValue(null, "host"));
        String port = reader.getAttributeValue(null, "port");
        if (port != null) {
            binding.setPort(Integer.parseInt(port));
        }
        if ((name = reader.getAttributeValue(null, "name")) != null) {
            binding.setName(name);
        }
        if ((uri = reader.getAttributeValue(null, "uri")) != null) {
            binding.setURI(uri);
        }
        if ((id = reader.getAttributeValue(null, "id")) != null) {
            binding.setId(id);
        }
        return binding;
    }

    @Override
    public void write(CorbaBinding model, XMLStreamWriter writer, ProcessorContext context) throws ContributionWriteException, XMLStreamException {
        writer.writeStartElement(CorbaBinding.BINDING_CORBA_QNAME.getNamespaceURI(), "binding.corba");
        if (model.getName() != null) {
            writer.writeAttribute("name", model.getName());
        }
        if (model.getURI() != null) {
            writer.writeAttribute("uri", model.getURI());
        }
        if (model.getHost() != null) {
            writer.writeAttribute("host", model.getHost());
        }
        if (model.getPort() != -1) {
            writer.writeAttribute("port", String.valueOf(model.getPort()));
        }
        if (model.getId() != null) {
            writer.writeAttribute("id", model.getId());
        }
        writer.writeEndElement();
    }

    @Override
    public Class<CorbaBinding> getModelType() {
        return CorbaBinding.class;
    }

    @Override
    public void resolve(CorbaBinding model, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
    }
}

