/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.xml;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.xml.BaseAssemblyProcessor;
import org.apache.tuscany.sca.assembly.xml.Constants;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.interfacedef.DataType;
import org.apache.tuscany.sca.interfacedef.Interface;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.interfacedef.impl.DataTypeImpl;
import org.apache.tuscany.sca.interfacedef.impl.InterfaceImpl;
import org.apache.tuscany.sca.interfacedef.impl.OperationImpl;
import org.apache.tuscany.sca.interfacedef.impl.TuscanyInterfaceContractImpl;
import org.apache.tuscany.sca.interfacedef.util.XMLType;

public class InterfaceContractProcessor
extends BaseAssemblyProcessor
implements StAXArtifactProcessor<InterfaceContract>,
Constants {
    String INTERFACE_CONTRACT = "interfaceContract";
    QName INTERFACE_CONTRACT_QNAME = new QName("http://tuscany.apache.org/xmlns/sca/1.1", this.INTERFACE_CONTRACT);
    String INTERFACE = "interface";
    QName INTERFACE_QNAME = new QName("http://tuscany.apache.org/xmlns/sca/1.1", this.INTERFACE);
    String CALLBACK_INTERFACE = "callbackInterface";
    QName CALLBACK_INTERFACE_QNAME = new QName("http://tuscany.apache.org/xmlns/sca/1.1", this.CALLBACK_INTERFACE);
    String OPERATION = "operation";
    QName OPERATION_QNAME = new QName("http://tuscany.apache.org/xmlns/sca/1.1", this.OPERATION);
    String INPUT = "input";
    QName INPUT_QNAME = new QName("http://tuscany.apache.org/xmlns/sca/1.1", this.INPUT);
    String OUTPUT = "output";
    QName OUTPUT_QNAME = new QName("http://tuscany.apache.org/xmlns/sca/1.1", this.OUTPUT);
    String FAULT = "fault";
    QName FAULT_QNAME = new QName("http://tuscany.apache.org/xmlns/sca/1.1", this.FAULT);
    String DATATYPE = "dataType";
    QName DATATYPE_QNAME = new QName("http://tuscany.apache.org/xmlns/sca/1.1", this.DATATYPE);
    String GENERIC = "generic";
    QName GENERIC_QNAME = new QName("http://tuscany.apache.org/xmlns/sca/1.1", this.GENERIC);
    String LOGICAL_COLLECTION = "logicalCollection";
    QName LOGICAL_COLLECTION_QNAME = new QName("http://tuscany.apache.org/xmlns/sca/1.1", this.LOGICAL_COLLECTION);
    String LOGICAL_XMLTYPE = "logicalXMLType";
    QName LOGICAL_XMLTYPE_QNAME = new QName("http://tuscany.apache.org/xmlns/sca/1.1", this.LOGICAL_XMLTYPE);
    String LOGICAL_TYPE = "logicalType";
    QName LOGICAL_TYPE_QNAME = new QName("http://tuscany.apache.org/xmlns/sca/1.1", this.LOGICAL_TYPE);
    String PHYSICAL = "physical";
    QName PHYSICAL_QNAME = new QName("http://tuscany.apache.org/xmlns/sca/1.1", this.PHYSICAL);
    String XMLTYPE = "xmlType";
    QName XMLTYPE_QNAME = new QName("http://tuscany.apache.org/xmlns/sca/1.1", this.XMLTYPE);
    String NO_TYPE = "NoType";

    public InterfaceContractProcessor(ExtensionPointRegistry registry) {
        super(registry.getExtensionPoint(FactoryExtensionPoint.class), null);
    }

    @Override
    public InterfaceContract read(XMLStreamReader reader, ProcessorContext context) throws ContributionReadException, XMLStreamException {
        TuscanyInterfaceContractImpl interfaceContract = new TuscanyInterfaceContractImpl();
        try {
            InterfaceImpl iface = null;
            QName name = null;
            OperationImpl operation = null;
            ArrayList<DataTypeImpl<Object>> inputs = null;
            ArrayList<DataTypeImpl<Object>> outputs = null;
            ArrayList<DataType> faults = null;
            XMLType logicalXMLType = null;
            Iof iof = Iof.UNSET;
            CharacterTarget characterTarget = CharacterTarget.UNSET;
            boolean logicalCollection = false;
            DataTypeImpl<Object> dataType = null;
            while (reader.hasNext()) {
                int event = reader.getEventType();
                switch (event) {
                    case 1: {
                        name = reader.getName();
                        if (this.INTERFACE_CONTRACT_QNAME.equals(name)) break;
                        if (this.INTERFACE_QNAME.equals(name)) {
                            iface = new InterfaceImpl();
                            interfaceContract.setInterface(iface);
                            iface.setRemotable(this.getBoolean(reader, "isRemotable"));
                            break;
                        }
                        if (this.CALLBACK_INTERFACE_QNAME.equals(name)) {
                            iface = new InterfaceImpl();
                            interfaceContract.setCallbackInterface(iface);
                            iface.setRemotable(this.getBoolean(reader, "isRemotable"));
                            break;
                        }
                        if (this.OPERATION_QNAME.equals(name)) {
                            operation = new OperationImpl();
                            iface.getOperations().add(operation);
                            operation.setName(this.getString(reader, "name"));
                            operation.setDynamic(this.getBoolean(reader, "isDynamic"));
                            operation.setNonBlocking(this.getBoolean(reader, "isNonBlocking"));
                            operation.setInputWrapperStyle(this.getBoolean(reader, "isInputWrapperStyle"));
                            operation.setOutputWrapperStyle(this.getBoolean(reader, "isOutputWrapperStyle"));
                            inputs = new ArrayList<DataTypeImpl<Object>>();
                            DataTypeImpl<Object> inputType = new DataTypeImpl<Object>(null, null);
                            inputType.setLogical(inputs);
                            operation.setInputType(inputType);
                            outputs = new ArrayList<DataTypeImpl<Object>>();
                            DataTypeImpl<Object> outputType = new DataTypeImpl<Object>(null, null);
                            outputType.setLogical(outputs);
                            operation.setOutputType(outputType);
                            faults = new ArrayList<DataType>();
                            operation.setFaultTypes(faults);
                            break;
                        }
                        if (this.INPUT_QNAME.equals(name)) {
                            iof = Iof.INPUT;
                            break;
                        }
                        if (this.OUTPUT_QNAME.equals(name)) {
                            iof = Iof.OUTPUT;
                            break;
                        }
                        if (this.FAULT_QNAME.equals(name)) {
                            iof = Iof.FAULT;
                            break;
                        }
                        if (this.DATATYPE_QNAME.equals(name)) {
                            DataTypeImpl<Object> newDataType = new DataTypeImpl<Object>(null, null);
                            newDataType.setDataBinding(this.getString(reader, "dataBinding"));
                            if (logicalCollection) {
                                dataType.setLogical(newDataType);
                                dataType = newDataType;
                                break;
                            }
                            if (iof == Iof.INPUT) {
                                inputs.add(newDataType);
                                dataType = newDataType;
                                break;
                            }
                            if (iof == Iof.OUTPUT) {
                                outputs.add(newDataType);
                                dataType = newDataType;
                                break;
                            }
                            if (iof != Iof.FAULT) break;
                            faults.add(newDataType);
                            dataType = newDataType;
                            break;
                        }
                        if (this.GENERIC_QNAME.equals(name)) {
                            characterTarget = CharacterTarget.GENERIC;
                            break;
                        }
                        if (this.PHYSICAL_QNAME.equals(name)) {
                            characterTarget = CharacterTarget.PHYSICAL;
                            break;
                        }
                        if (this.LOGICAL_COLLECTION_QNAME.equals(name)) {
                            logicalCollection = true;
                            break;
                        }
                        if (this.LOGICAL_XMLTYPE_QNAME.equals(name)) {
                            characterTarget = CharacterTarget.XMLTYPE;
                            logicalXMLType = new XMLType(null, null);
                            dataType.setLogical(logicalXMLType);
                            break;
                        }
                        if (this.LOGICAL_TYPE_QNAME.equals(name) || this.XMLTYPE_QNAME.equals(name)) break;
                        System.out.println("Unexpected element " + name);
                        break;
                    }
                    case 4: {
                        String xmlType;
                        if (characterTarget == CharacterTarget.GENERIC) {
                            String generic = reader.getText();
                        } else if (characterTarget == CharacterTarget.PHYSICAL) {
                            String physical = reader.getText();
                        } else if (characterTarget == CharacterTarget.XMLTYPE && !(xmlType = reader.getText()).equals(this.NO_TYPE)) {
                            int splitPoint = xmlType.indexOf("}");
                            String namespace = xmlType.substring(1, splitPoint);
                            String localname = xmlType.substring(splitPoint + 1);
                            QName typeName = new QName(namespace, localname);
                            logicalXMLType.setTypeName(typeName);
                        }
                        characterTarget = CharacterTarget.UNSET;
                        break;
                    }
                    case 2: {
                        name = reader.getName();
                        if (this.INPUT_QNAME.equals(name) || this.OUTPUT_QNAME.equals(name) || this.FAULT_QNAME.equals(name)) {
                            iof = Iof.UNSET;
                            break;
                        }
                        if (!this.LOGICAL_COLLECTION_QNAME.equals(name)) break;
                        logicalCollection = false;
                    }
                }
                if (!reader.hasNext()) continue;
                reader.next();
            }
        }
        catch (XMLStreamException e) {
            ContributionReadException ex = new ContributionReadException(e);
        }
        return interfaceContract;
    }

    @Override
    public void write(InterfaceContract interfaceContract, XMLStreamWriter writer, ProcessorContext context) throws ContributionWriteException, XMLStreamException {
        if (interfaceContract == null || interfaceContract.getInterface() == null) {
            return;
        }
        writer.writeStartElement("http://tuscany.apache.org/xmlns/sca/1.1", this.INTERFACE_CONTRACT);
        writer.writeStartElement("http://tuscany.apache.org/xmlns/sca/1.1", this.INTERFACE);
        this.writeInterface(interfaceContract.getInterface(), writer, context);
        if (interfaceContract.getCallbackInterface() != null) {
            writer.writeStartElement("http://tuscany.apache.org/xmlns/sca/1.1", this.CALLBACK_INTERFACE);
            this.writeInterface(interfaceContract.getCallbackInterface(), writer, context);
        }
        writer.writeEndElement();
    }

    private void writeInterface(Interface iface, XMLStreamWriter writer, ProcessorContext context) throws XMLStreamException {
        writer.writeAttribute("isRemotable", String.valueOf(iface.isRemotable()));
        for (Operation operation : iface.getOperations()) {
            writer.writeStartElement("http://tuscany.apache.org/xmlns/sca/1.1", this.OPERATION);
            writer.writeAttribute("name", operation.getName());
            writer.writeAttribute("isDynamic", String.valueOf(operation.isDynamic()));
            writer.writeAttribute("isNonBlocking", String.valueOf(operation.isNonBlocking()));
            writer.writeAttribute("isInputWrapperStyle", String.valueOf(operation.isInputWrapperStyle()));
            writer.writeAttribute("isOutputWrapperStyle", String.valueOf(operation.isOutputWrapperStyle()));
            List<DataType> outputTypes = operation.getOutputType().getLogical();
            List<DataType> inputTypes = operation.getInputType().getLogical();
            List<DataType> faultTypes = operation.getFaultTypes();
            if (operation.isInputWrapperStyle() && operation.getInputWrapper() != null) {
                inputTypes = operation.getInputWrapper().getUnwrappedType().getLogical();
            }
            if (operation.isOutputWrapperStyle() && operation.getOutputWrapper() != null) {
                outputTypes = operation.getOutputWrapper().getUnwrappedType().getLogical();
            }
            writer.writeStartElement("http://tuscany.apache.org/xmlns/sca/1.1", this.INPUT);
            this.writeDataTypes(inputTypes, writer);
            writer.writeEndElement();
            writer.writeStartElement("http://tuscany.apache.org/xmlns/sca/1.1", this.OUTPUT);
            this.writeDataTypes(outputTypes, writer);
            writer.writeEndElement();
            writer.writeStartElement("http://tuscany.apache.org/xmlns/sca/1.1", this.FAULT);
            this.writeDataTypes(faultTypes, writer);
            writer.writeEndElement();
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    private void writeDataTypes(List<DataType> dataTypes, XMLStreamWriter writer) throws XMLStreamException {
        for (DataType dataType : dataTypes) {
            this.writeDataType(dataType, writer);
        }
    }

    private void writeDataType(DataType<?> dataType, XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("http://tuscany.apache.org/xmlns/sca/1.1", this.DATATYPE);
        if (dataType.getDataBinding() != null) {
            writer.writeAttribute("dataBinding", dataType.getDataBinding());
        }
        if (dataType.getGenericType() != null) {
            writer.writeStartElement("http://tuscany.apache.org/xmlns/sca/1.1", this.GENERIC);
            writer.writeCharacters(dataType.getGenericType().toString());
            writer.writeEndElement();
        }
        if (dataType.getLogical() instanceof DataType) {
            writer.writeStartElement("http://tuscany.apache.org/xmlns/sca/1.1", this.LOGICAL_COLLECTION);
            this.writeDataType((DataType)dataType.getLogical(), writer);
        } else if (dataType.getLogical() instanceof XMLType) {
            writer.writeStartElement("http://tuscany.apache.org/xmlns/sca/1.1", this.LOGICAL_XMLTYPE);
            writer.writeStartElement("http://tuscany.apache.org/xmlns/sca/1.1", this.XMLTYPE);
            XMLType xmlType = (XMLType)dataType.getLogical();
            if (xmlType.getTypeName() != null) {
                writer.writeCharacters(xmlType.getTypeName().toString());
            } else {
                writer.writeCharacters("NoType");
            }
            writer.writeEndElement();
        } else {
            writer.writeStartElement("http://tuscany.apache.org/xmlns/sca/1.1", this.LOGICAL_TYPE);
            writer.writeCharacters(dataType.getLogical().toString());
        }
        writer.writeEndElement();
        if (dataType.getPhysical() != null) {
            writer.writeStartElement("http://tuscany.apache.org/xmlns/sca/1.1", this.PHYSICAL);
            writer.writeCharacters(dataType.getPhysical().getName());
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }

    @Override
    public void resolve(InterfaceContract interfaceContract, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
    }

    @Override
    public QName getArtifactType() {
        return null;
    }

    @Override
    public Class<InterfaceContract> getModelType() {
        return InterfaceContract.class;
    }

    static enum CharacterTarget {
        UNSET,
        GENERIC,
        PHYSICAL,
        XMLTYPE;

    }

    static enum Iof {
        UNSET,
        INPUT,
        OUTPUT,
        FAULT;

    }
}

