/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stream.StreamSource;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.xml.BaseAssemblyProcessor;
import org.apache.tuscany.sca.common.java.io.IOHelper;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ValidatingXMLInputFactory;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.monitor.Monitor;

public class CompositeDocumentProcessor
extends BaseAssemblyProcessor
implements URLArtifactProcessor<Composite>,
XMLStreamConstants {
    private ValidatingXMLInputFactory inputFactory;

    public CompositeDocumentProcessor(FactoryExtensionPoint modelFactories, StAXArtifactProcessor<?> staxProcessor) {
        super(modelFactories, staxProcessor);
        this.inputFactory = modelFactories.getFactory(ValidatingXMLInputFactory.class);
    }

    @Override
    public Composite read(URL contributionURL, URI uri, URL url, ProcessorContext context) throws ContributionReadException {
        if (uri == null || url == null) {
            throw new ContributionReadException(context.getMonitor().getMessageString(CompositeDocumentProcessor.class.getName(), "org.apache.tuscany.sca.assembly.xml.assembly-xml-validation-messages", "NullURL"));
        }
        InputStream scdlStream = null;
        try {
            scdlStream = IOHelper.openStream(url);
        }
        catch (IOException e) {
            ContributionReadException ce = new ContributionReadException(context.getMonitor().getMessageString(CompositeDocumentProcessor.class.getName(), "org.apache.tuscany.sca.assembly.xml.assembly-xml-validation-messages", "ReadException") + " " + uri, e);
            this.error(context.getMonitor(), "ContributionReadException", (Object)url, ce);
            throw ce;
        }
        return this.read(uri, url, scdlStream, context);
    }

    public Composite read(URI uri, URL url, InputStream scdlStream, ProcessorContext context) throws ContributionReadException {
        try {
            Composite composite = null;
            Monitor monitor = context.getMonitor();
            if (monitor != null) {
                monitor.setArtifactName(uri.toString());
            }
            StreamSource scdlSource = new StreamSource(scdlStream, url.toString());
            XMLStreamReader reader = this.inputFactory.createXMLStreamReader(scdlSource);
            ValidatingXMLInputFactory.setMonitor(reader, context.getMonitor());
            this.readCompositeFileHeader(reader);
            composite = (Composite)this.extensionProcessor.read(reader, context);
            if (composite != null) {
                composite.setURI(uri.toString());
            }
            Composite composite2 = composite;
            return composite2;
        }
        catch (XMLStreamException e) {
            ContributionReadException ce = new ContributionReadException(context.getMonitor().getMessageString(CompositeDocumentProcessor.class.getName(), "org.apache.tuscany.sca.assembly.xml.assembly-xml-validation-messages", "ReadException") + " " + uri, e);
            this.error(context.getMonitor(), "ContributionReadException", (Object)this.inputFactory, ce);
            throw ce;
        }
        finally {
            try {
                if (scdlStream != null) {
                    scdlStream.close();
                    scdlStream = null;
                }
            }
            catch (IOException ioe) {}
        }
    }

    private void readCompositeFileHeader(XMLStreamReader reader) throws XMLStreamException {
        int event;
        while ((event = reader.next()) == 4 || event == 12 || event == 6 || event == 3 || event == 5 || event == 11 || event == 15 || event != 1 && event != 2) {
        }
    }

    @Override
    public void resolve(Composite composite, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        try {
            if (composite != null) {
                this.extensionProcessor.resolve(composite, resolver, context);
            }
        }
        catch (Throwable e) {
            String newMessage = context.getMonitor().getMessageString(CompositeDocumentProcessor.class.getName(), "org.apache.tuscany.sca.assembly.xml.assembly-xml-validation-messages", "ProcessingComposite") + " " + composite.getName() + ": " + e.getMessage();
            throw new ContributionResolveException(newMessage, e);
        }
    }

    @Override
    public String getArtifactType() {
        return ".composite";
    }

    @Override
    public Class<Composite> getModelType() {
        return Composite.class;
    }
}

