/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.xml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Callback;
import org.apache.tuscany.sca.assembly.ComponentType;
import org.apache.tuscany.sca.assembly.Contract;
import org.apache.tuscany.sca.assembly.Extensible;
import org.apache.tuscany.sca.assembly.Property;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.assembly.xml.BaseAssemblyProcessor;
import org.apache.tuscany.sca.assembly.xml.Constants;
import org.apache.tuscany.sca.common.xml.stax.StAXHelper;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXAttributeProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.interfacedef.impl.OperationImpl;
import org.apache.tuscany.sca.policy.PolicySubject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ComponentTypeProcessor
extends BaseAssemblyProcessor
implements StAXArtifactProcessor<ComponentType> {
    private StAXHelper staxHelper;

    public ComponentTypeProcessor(ExtensionPointRegistry extensionPoints, StAXArtifactProcessor extensionProcessor, StAXAttributeProcessor extensionAttributeProcessor) {
        super(ComponentTypeProcessor.modelFactories(extensionPoints), extensionProcessor);
        this.staxHelper = StAXHelper.getInstance(extensionPoints);
    }

    @Override
    public ComponentType read(XMLStreamReader reader, ProcessorContext context) throws ContributionReadException {
        ComponentType componentType = null;
        Service service = null;
        Reference reference = null;
        Contract contract = null;
        Property property = null;
        Callback callback = null;
        QName name = null;
        try {
            while (reader.hasNext()) {
                int event = reader.getEventType();
                switch (event) {
                    case 1: {
                        Object extension;
                        name = reader.getName();
                        if (Constants.COMPONENT_TYPE_QNAME.equals(name)) {
                            componentType = this.assemblyFactory.createComponentType();
                            break;
                        }
                        if (Constants.SERVICE_QNAME.equals(name)) {
                            service = this.assemblyFactory.createService();
                            contract = service;
                            service.setName(this.getString(reader, "name"));
                            componentType.getServices().add(service);
                            this.policyProcessor.readPolicies(service, reader);
                            break;
                        }
                        if (Constants.REFERENCE_QNAME.equals(name)) {
                            reference = this.assemblyFactory.createReference();
                            contract = reference;
                            reference.setName(this.getString(reader, "name"));
                            reference.setWiredByImpl(this.getBoolean(reader, "wiredByImpl"));
                            this.readMultiplicity(reference, reader);
                            this.readTargets(reference, reader);
                            componentType.getReferences().add(reference);
                            this.policyProcessor.readPolicies(reference, reader);
                            break;
                        }
                        if (Constants.PROPERTY_QNAME.equals(name)) {
                            property = this.assemblyFactory.createProperty();
                            this.readAbstractProperty(property, reader, context);
                            this.policyProcessor.readPolicies(property, reader);
                            Document value = this.readPropertyValue(property.getXSDElement(), property.getXSDType(), property.isMany(), reader, context);
                            property.setValue(value);
                            componentType.getProperties().add(property);
                            break;
                        }
                        if (Constants.IMPLEMENTATION_QNAME.equals(name)) {
                            this.policyProcessor.readPolicies(componentType, reader);
                            break;
                        }
                        if (Constants.CALLBACK_QNAME.equals(name)) {
                            callback = this.assemblyFactory.createCallback();
                            contract.setCallback(callback);
                            this.policyProcessor.readPolicies(callback, reader);
                            break;
                        }
                        if (Constants.OPERATION_QNAME.equals(name)) {
                            OperationImpl operation = new OperationImpl();
                            operation.setName(this.getString(reader, "name"));
                            operation.setUnresolved(true);
                            if (callback != null) {
                                this.policyProcessor.readPolicies(callback, operation, reader);
                                break;
                            }
                            this.policyProcessor.readPolicies(contract, operation, reader);
                            break;
                        }
                        if (Constants.EXTENSION_QNAME.equals(name) || (extension = this.extensionProcessor.read(reader, context)) == null) break;
                        if (extension instanceof InterfaceContract) {
                            contract.setInterfaceContract((InterfaceContract)extension);
                            break;
                        }
                        if (extension instanceof Binding) {
                            if (callback != null) {
                                callback.getBindings().add((Binding)extension);
                                break;
                            }
                            contract.getBindings().add((Binding)extension);
                            break;
                        }
                        if (callback != null) {
                            callback.getExtensions().add(extension);
                            break;
                        }
                        if (contract != null) {
                            contract.getExtensions().add(extension);
                            break;
                        }
                        if (property != null) {
                            property.getExtensions().add(extension);
                            break;
                        }
                        if (!(componentType instanceof Extensible)) break;
                        ((Extensible)((Object)componentType)).getExtensions().add(extension);
                        break;
                    }
                    case 2: {
                        name = reader.getName();
                        if (Constants.SERVICE_QNAME.equals(name)) {
                            service = null;
                            contract = null;
                            break;
                        }
                        if (Constants.REFERENCE_QNAME.equals(name)) {
                            reference = null;
                            contract = null;
                            break;
                        }
                        if (Constants.PROPERTY_QNAME.equals(name)) {
                            property = null;
                            break;
                        }
                        if (!Constants.CALLBACK_QNAME.equals(name)) break;
                        callback = null;
                    }
                }
                if (!reader.hasNext()) continue;
                reader.next();
            }
        }
        catch (XMLStreamException e) {
            ContributionReadException ex = new ContributionReadException(e);
            this.error(context.getMonitor(), "XMLStreamException", (Object)reader, ex);
        }
        return componentType;
    }

    @Override
    public void write(ComponentType componentType, XMLStreamWriter writer, ProcessorContext context) throws ContributionWriteException, XMLStreamException {
        Callback callback;
        this.writeStartDocument(writer, "componentType", new BaseStAXArtifactProcessor.XAttr[0]);
        for (Service service : componentType.getServices()) {
            this.writeStart(writer, "service", new BaseStAXArtifactProcessor.XAttr("name", service.getName()), this.policyProcessor.writePolicies(service));
            if (service.getInterfaceContract() != null) {
                this.extensionProcessor.write(service.getInterfaceContract(), writer, context);
            }
            for (Binding binding : service.getBindings()) {
                this.extensionProcessor.write(binding, writer, context);
            }
            if (service.getCallback() != null) {
                callback = service.getCallback();
                this.writeStart(writer, "callback", this.policyProcessor.writePolicies(callback));
                for (Binding binding : callback.getBindings()) {
                    this.extensionProcessor.write(binding, writer, context);
                }
                for (Object extension : callback.getExtensions()) {
                    this.extensionProcessor.write(extension, writer, context);
                }
                this.writeEnd(writer);
            }
            this.writeExtendedElements(writer, service, this.extensionProcessor, context);
            this.writeEnd(writer);
        }
        for (Reference reference : componentType.getReferences()) {
            this.writeStart(writer, "reference", new BaseStAXArtifactProcessor.XAttr("name", reference.getName()), this.writeMultiplicity(reference), this.writeTargets(reference), this.policyProcessor.writePolicies(reference));
            this.extensionProcessor.write(reference.getInterfaceContract(), writer, context);
            for (Binding binding : reference.getBindings()) {
                this.extensionProcessor.write(binding, writer, context);
            }
            if (reference.getCallback() != null) {
                callback = reference.getCallback();
                this.writeStart(writer, "callback", this.policyProcessor.writePolicies(callback));
                for (Binding binding : callback.getBindings()) {
                    this.extensionProcessor.write(binding, writer, context);
                }
                for (Object extension : callback.getExtensions()) {
                    this.extensionProcessor.write(extension, writer, context);
                }
                this.writeEnd(writer);
            }
            this.writeExtendedElements(writer, reference, this.extensionProcessor, context);
            this.writeEnd(writer);
        }
        for (Property property : componentType.getProperties()) {
            this.writeStart(writer, "property", new BaseStAXArtifactProcessor.XAttr("name", property.getName()), new BaseStAXArtifactProcessor.XAttr("mustSupply", property.isMustSupply()), new BaseStAXArtifactProcessor.XAttr("many", property.isMany()), new BaseStAXArtifactProcessor.XAttr("type", property.getXSDType()), new BaseStAXArtifactProcessor.XAttr("element", property.getXSDElement()), this.policyProcessor.writePolicies(property));
            this.writePropertyValue(property.getValue(), property.getXSDElement(), property.getXSDType(), writer);
            for (Object extension : property.getExtensions()) {
                this.extensionProcessor.write(extension, writer, context);
            }
            this.writeEnd(writer);
        }
        if (componentType instanceof Extensible) {
            for (Object extension : ((Extensible)((Object)componentType)).getExtensions()) {
                this.extensionProcessor.write(extension, writer, context);
            }
        }
        boolean writeImplementation = false;
        if (componentType instanceof PolicySubject && !componentType.getRequiredIntents().isEmpty()) {
            writeImplementation = true;
        }
        if (componentType instanceof PolicySubject && !componentType.getPolicySets().isEmpty()) {
            writeImplementation = true;
        }
        if (writeImplementation) {
            this.writeStart(writer, "implementation", this.policyProcessor.writePolicies(componentType));
        }
        this.writeEndDocument(writer);
    }

    protected void writePropertyValue(Object propertyValue, QName element, QName type, XMLStreamWriter writer) throws XMLStreamException {
        if (propertyValue instanceof Document) {
            Document document = (Document)propertyValue;
            NodeList nodeList = document.getDocumentElement().getChildNodes();
            for (int item = 0; item < nodeList.getLength(); ++item) {
                Node node = nodeList.item(item);
                short nodeType = node.getNodeType();
                if (nodeType == 1) {
                    XMLStreamReader reader = this.staxHelper.createXMLStreamReader(node);
                    block7: while (reader.hasNext()) {
                        switch (reader.next()) {
                            case 1: {
                                int i;
                                QName name = reader.getName();
                                writer.writeStartElement(name.getPrefix(), name.getLocalPart(), name.getNamespaceURI());
                                int namespaces = reader.getNamespaceCount();
                                for (i = 0; i < namespaces; ++i) {
                                    String prefix = reader.getNamespacePrefix(i);
                                    String ns = reader.getNamespaceURI(i);
                                    writer.writeNamespace(prefix, ns);
                                }
                                if (!"".equals(name.getNamespaceURI())) {
                                    writer.writeNamespace(name.getPrefix(), name.getNamespaceURI());
                                }
                                namespaces = reader.getAttributeCount();
                                for (i = 0; i < namespaces; ++i) {
                                    String ns = reader.getAttributeNamespace(i);
                                    String prefix = reader.getAttributePrefix(i);
                                    String qname = reader.getAttributeLocalName(i);
                                    String value = reader.getAttributeValue(i);
                                    writer.writeAttribute(prefix, ns, qname, value);
                                }
                                continue block7;
                            }
                            case 12: {
                                writer.writeCData(reader.getText());
                                break;
                            }
                            case 4: {
                                writer.writeCharacters(reader.getText());
                                break;
                            }
                            case 2: {
                                writer.writeEndElement();
                            }
                        }
                    }
                    continue;
                }
                writer.writeCharacters(node.getTextContent());
            }
        }
    }

    @Override
    public void resolve(ComponentType componentType, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        this.resolveContracts(componentType.getServices(), resolver, context);
        this.resolveContracts(componentType.getReferences(), resolver, context);
    }

    @Override
    public QName getArtifactType() {
        return Constants.COMPONENT_TYPE_QNAME;
    }

    @Override
    public Class<ComponentType> getModelType() {
        return ComponentType.class;
    }

    private static FactoryExtensionPoint modelFactories(ExtensionPointRegistry extensionPoints) {
        return extensionPoints.getExtensionPoint(FactoryExtensionPoint.class);
    }
}

