/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.tuscany.sca.assembly.ComponentType;
import org.apache.tuscany.sca.assembly.xml.BaseAssemblyProcessor;
import org.apache.tuscany.sca.common.java.io.IOHelper;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.URLArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.ValidatingXMLInputFactory;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.monitor.Monitor;

public class ComponentTypeDocumentProcessor
extends BaseAssemblyProcessor
implements URLArtifactProcessor<ComponentType> {
    private ValidatingXMLInputFactory inputFactory;

    public ComponentTypeDocumentProcessor(FactoryExtensionPoint modelFactories, StAXArtifactProcessor staxProcessor) {
        super(modelFactories, staxProcessor);
        this.inputFactory = modelFactories.getFactory(ValidatingXMLInputFactory.class);
    }

    @Override
    public ComponentType read(URL contributionURL, URI uri, URL url, ProcessorContext context) throws ContributionReadException {
        InputStream urlStream = null;
        Monitor monitor = context.getMonitor();
        try {
            urlStream = IOHelper.openStream(url);
            XMLStreamReader reader = this.inputFactory.createXMLStreamReader(url.toString(), urlStream);
            ValidatingXMLInputFactory.setMonitor(reader, monitor);
            reader.nextTag();
            ComponentType componentType = (ComponentType)this.extensionProcessor.read(reader, context);
            if (componentType != null) {
                componentType.setURI(uri.toString());
            }
            ComponentType componentType2 = componentType;
            return componentType2;
        }
        catch (XMLStreamException e) {
            ContributionReadException ce = new ContributionReadException(e);
            this.error(monitor, "ContributionReadException", (Object)this.inputFactory, ce);
            throw ce;
        }
        catch (IOException e) {
            ContributionReadException ce = new ContributionReadException(e);
            this.error(monitor, "ContributionReadException", (Object)this.inputFactory, ce);
            throw ce;
        }
        finally {
            try {
                if (urlStream != null) {
                    urlStream.close();
                    urlStream = null;
                }
            }
            catch (IOException ioe) {}
        }
    }

    @Override
    public void resolve(ComponentType componentType, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
        this.extensionProcessor.resolve(componentType, resolver, context);
    }

    @Override
    public String getArtifactType() {
        return ".componentType";
    }

    @Override
    public Class<ComponentType> getModelType() {
        return ComponentType.class;
    }
}

