/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Callback;
import org.apache.tuscany.sca.assembly.Endpoint;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.assembly.impl.AbstractServiceImpl;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;

public class ServiceImpl
extends AbstractServiceImpl
implements Service,
Cloneable {
    private List<Binding> bindings = new ArrayList<Binding>();
    private boolean overridingBindings;
    private Callback callback;
    private List<Endpoint> endpoints = new ArrayList<Endpoint>();
    private boolean isJAXWSService = false;

    protected ServiceImpl() {
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ServiceImpl clone = (ServiceImpl)super.clone();
        clone.bindings = new ArrayList<Binding>();
        for (Binding binding : this.getBindings()) {
            clone.bindings.add((Binding)binding.clone());
        }
        return clone;
    }

    @Override
    public List<Binding> getBindings() {
        return this.bindings;
    }

    @Override
    public Binding getBinding(String name) {
        for (Binding binding : this.bindings) {
            if (!binding.getName().equals(name)) continue;
            return binding;
        }
        return null;
    }

    @Override
    public <B> B getBinding(Class<B> bindingClass) {
        for (Binding binding : this.bindings) {
            if (!bindingClass.isInstance(binding)) continue;
            return bindingClass.cast(binding);
        }
        return null;
    }

    @Override
    public <B> B getCallbackBinding(Class<B> bindingClass) {
        if (this.callback != null) {
            for (Binding binding : this.callback.getBindings()) {
                if (!bindingClass.isInstance(binding)) continue;
                return bindingClass.cast(binding);
            }
        }
        return null;
    }

    @Override
    public Callback getCallback() {
        return this.callback;
    }

    @Override
    public void setCallback(Callback callback) {
        this.callback = callback;
    }

    @Override
    public InterfaceContract getInterfaceContract(Binding binding) {
        return this.getInterfaceContract();
    }

    @Override
    public List<Endpoint> getEndpoints() {
        return this.endpoints;
    }

    @Override
    public boolean isOverridingBindings() {
        return this.overridingBindings;
    }

    @Override
    public void setOverridingBindings(boolean overridingBindings) {
        this.overridingBindings = overridingBindings;
    }

    @Override
    public boolean isJAXWSService() {
        return this.isJAXWSService;
    }

    @Override
    public void setJAXWSService(boolean isJAXWSService) {
        this.isJAXWSService = isJAXWSService;
    }
}

