/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Callback;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.EndpointReference;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.impl.AbstractReferenceImpl;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;

public class ReferenceImpl
extends AbstractReferenceImpl
implements Reference,
Cloneable {
    private List<Binding> bindings = new ArrayList<Binding>();
    private boolean wiredByImpl;
    private List<ComponentService> targets = new ArrayList<ComponentService>();
    private Callback callback;
    private boolean overridingBindings;
    private boolean allowsPassByReference;
    private List<EndpointReference> endpointReferences = new ArrayList<EndpointReference>();

    protected ReferenceImpl() {
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ReferenceImpl clone = (ReferenceImpl)super.clone();
        clone.bindings = new ArrayList<Binding>();
        for (Binding binding : this.getBindings()) {
            clone.bindings.add((Binding)binding.clone());
        }
        clone.targets = new ArrayList<ComponentService>(this.targets);
        clone.endpointReferences = new ArrayList<EndpointReference>();
        for (EndpointReference epr : this.endpointReferences) {
            EndpointReference eprClone = (EndpointReference)epr.clone();
            eprClone.setReference((ComponentReference)((Object)clone));
            clone.endpointReferences.add(eprClone);
        }
        return clone;
    }

    @Override
    public List<Binding> getBindings() {
        return this.bindings;
    }

    @Override
    public Binding getBinding(String name) {
        for (Binding binding : this.bindings) {
            if (!binding.getName().equals(name)) continue;
            return binding;
        }
        return null;
    }

    @Override
    public <B> B getBinding(Class<B> bindingClass) {
        for (Binding binding : this.bindings) {
            if (!bindingClass.isInstance(binding)) continue;
            return bindingClass.cast(binding);
        }
        return null;
    }

    @Override
    public <B> B getCallbackBinding(Class<B> bindingClass) {
        if (this.callback != null) {
            for (Binding binding : this.callback.getBindings()) {
                if (!bindingClass.isInstance(binding)) continue;
                return bindingClass.cast(binding);
            }
        }
        return null;
    }

    @Override
    public boolean isWiredByImpl() {
        return this.wiredByImpl;
    }

    @Override
    public void setWiredByImpl(boolean wiredByImpl) {
        this.wiredByImpl = wiredByImpl;
    }

    @Override
    public List<ComponentService> getTargets() {
        return this.targets;
    }

    @Override
    public Callback getCallback() {
        return this.callback;
    }

    @Override
    public void setCallback(Callback callback) {
        this.callback = callback;
    }

    @Override
    public InterfaceContract getInterfaceContract(Binding binding) {
        return this.getInterfaceContract();
    }

    @Override
    public List<EndpointReference> getEndpointReferences() {
        return this.endpointReferences;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public boolean isOverridingBindings() {
        return this.overridingBindings;
    }

    @Override
    public void setOverridingBindings(boolean overridingBindings) {
        this.overridingBindings = overridingBindings;
    }

    @Override
    public boolean isAllowsPassByReference() {
        return this.allowsPassByReference;
    }

    @Override
    public void setAllowsPassByReference(boolean allowsPassByReference) {
        this.allowsPassByReference = allowsPassByReference;
    }
}

