/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import javax.xml.stream.XMLStreamException;
import org.apache.tuscany.sca.Node;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.common.java.io.IOHelper;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.core.DefaultExtensionPointRegistry;
import org.apache.tuscany.sca.core.ExtensionPointRegistry;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.core.ModuleActivatorExtensionPoint;
import org.apache.tuscany.sca.core.UtilityExtensionPoint;
import org.apache.tuscany.sca.core.assembly.RuntimeAssemblyFactory;
import org.apache.tuscany.sca.deployment.Deployer;
import org.apache.tuscany.sca.impl.NodeImpl;
import org.apache.tuscany.sca.monitor.ValidationException;
import org.apache.tuscany.sca.node.configuration.ContributionConfiguration;
import org.apache.tuscany.sca.node.configuration.NodeConfiguration;
import org.apache.tuscany.sca.runtime.ActivationException;
import org.apache.tuscany.sca.runtime.CompositeActivator;
import org.apache.tuscany.sca.runtime.DomainRegistry;
import org.apache.tuscany.sca.runtime.ExtensibleDomainRegistryFactory;
import org.apache.tuscany.sca.runtime.RuntimeProperties;
import org.apache.tuscany.sca.work.WorkScheduler;
import org.oasisopen.sca.ServiceRuntimeException;

public class TuscanyRuntime {
    public static final String DEFAUL_DOMAIN_NAME = "default";
    private Deployer deployer;
    private ExtensionPointRegistry extensionPointRegistry;
    private CompositeActivator compositeActivator;
    private ExtensibleDomainRegistryFactory domainRegistryFactory;
    private RuntimeAssemblyFactory assemblyFactory;

    public static TuscanyRuntime newInstance() {
        return new TuscanyRuntime(null);
    }

    public static TuscanyRuntime newInstance(Properties config) {
        return new TuscanyRuntime(config);
    }

    public static Node runComposite(String compositeURI, String contributionURL, String ... dependentContributionURLs) {
        return TuscanyRuntime.runComposite(null, compositeURI, contributionURL, dependentContributionURLs);
    }

    public static Node runComposite(URI domainURI, String compositeURI, String contributionURL, String ... dependentContributionURLs) {
        try {
            TuscanyRuntime runtime = TuscanyRuntime.newInstance();
            String domain = domainURI == null ? DEFAUL_DOMAIN_NAME : domainURI.toString();
            DomainRegistry domainRegistry = runtime.domainRegistryFactory.getEndpointRegistry(domain, null);
            NodeImpl node = new NodeImpl(runtime.deployer, runtime.compositeActivator, domainRegistry, runtime.extensionPointRegistry, runtime);
            if (dependentContributionURLs != null) {
                for (int i = dependentContributionURLs.length - 1; i > -1; --i) {
                    node.installContribution(null, dependentContributionURLs[i], null, null);
                }
            }
            String curi = node.installContribution(null, contributionURL, null, null);
            if (compositeURI != null) {
                node.startComposite(curi, compositeURI);
            } else {
                for (String compURI : node.getDeployableCompositeURIs(curi)) {
                    node.startComposite(curi, compURI);
                }
            }
            return node;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected TuscanyRuntime(Properties config) {
        this.init(config);
    }

    public Node createNode() {
        return this.createNode((String)null);
    }

    public Node createNode(String domainURI) {
        if (domainURI == null) {
            domainURI = DEFAUL_DOMAIN_NAME;
        }
        DomainRegistry domainRegistry = this.domainRegistryFactory.getEndpointRegistry(domainURI, null);
        return new NodeImpl(this.deployer, this.compositeActivator, domainRegistry, this.extensionPointRegistry, null);
    }

    public Node createNode(File directory) throws ContributionReadException, ValidationException, ActivationException, XMLStreamException, IOException {
        if (!directory.isDirectory()) {
            return this.createNodeFromXML(directory.toURI().toURL().toString());
        }
        File nodeXML = new File(directory, "node.xml");
        if (nodeXML.exists()) {
            return this.createNodeFromXML(nodeXML.toURI().toURL().toString());
        }
        Properties domainProps = new Properties();
        File propsFile = new File(directory, "domain.properties");
        if (propsFile.exists()) {
            domainProps.load(new FileInputStream(propsFile));
        }
        String domainName = domainProps.getProperty("domainName", directory.getName());
        String domainURI = domainProps.getProperty("domainURI", domainName);
        DomainRegistry domainRegistry = this.domainRegistryFactory.getEndpointRegistry(domainURI, domainName);
        NodeImpl node = new NodeImpl(this.deployer, this.compositeActivator, domainRegistry, this.extensionPointRegistry, null);
        ArrayList<String> installed = new ArrayList<String>();
        for (File f : directory.listFiles()) {
            String fn;
            if (!f.getName().endsWith(".jar") && !f.getName().endsWith(".zip") && (!f.isDirectory() || f.getName().startsWith("."))) continue;
            String string = fn = f.getName().lastIndexOf(46) == -1 ? f.getName() : f.getName().substring(0, f.getName().lastIndexOf(46));
            if (!f.isDirectory() && new File(f.getParent(), fn).isDirectory()) continue;
            String metaData = null;
            for (File f2 : directory.listFiles()) {
                if (!f2.getName().startsWith(fn) || !f2.getName().endsWith(".xml")) continue;
                metaData = f2.getPath();
                break;
            }
            ArrayList<String> dependencyURIs = new ArrayList<String>();
            File dependencyFile = new File(directory, fn + ".dependencies");
            if (dependencyFile.exists()) {
                String s;
                BufferedReader br = new BufferedReader(new FileReader(dependencyFile));
                while ((s = br.readLine()) != null) {
                    if (s.startsWith("#") || s.trim().length() <= 0) continue;
                    dependencyURIs.addAll(Arrays.asList(s.trim().split("[ ,]+")));
                }
                br.close();
            }
            String curi = node.installContribution(null, f.getPath(), metaData, dependencyURIs);
            installed.add(curi);
            for (File f2 : directory.listFiles()) {
                if (!f2.getName().startsWith(fn) || !f2.getName().endsWith(".composite")) continue;
                node.addDeploymentComposite(curi, new FileReader(f2));
            }
        }
        for (String curi : installed) {
            node.startDeployables(curi);
        }
        return node;
    }

    public Node createNodeFromXML(String configURL) throws ContributionReadException, ActivationException, ValidationException {
        NodeConfiguration configuration = this.loadConfiguration(configURL);
        NodeImpl node = (NodeImpl)this.createNode(configuration.getDomainURI());
        for (ContributionConfiguration c : configuration.getContributions()) {
            String curi = node.installContribution(c.getURI(), c.getLocation(), c.getMetaDataURL(), c.getDependentContributionURIs());
            if (!c.isStartDeployables()) continue;
            for (String compURI : node.getDeployableCompositeURIs(curi)) {
                node.startComposite(curi, compURI);
            }
        }
        return node;
    }

    public void stop() {
        this.extensionPointRegistry.stop();
    }

    protected void init(Properties config) {
        if (config == null) {
            config = new Properties();
        }
        this.extensionPointRegistry = new DefaultExtensionPointRegistry();
        this.extensionPointRegistry.start();
        FactoryExtensionPoint modelFactories = this.extensionPointRegistry.getExtensionPoint(FactoryExtensionPoint.class);
        this.assemblyFactory = new RuntimeAssemblyFactory(this.extensionPointRegistry);
        modelFactories.addFactory(this.assemblyFactory);
        UtilityExtensionPoint utilities = this.extensionPointRegistry.getExtensionPoint(UtilityExtensionPoint.class);
        this.compositeActivator = utilities.getUtility(CompositeActivator.class);
        this.deployer = utilities.getUtility(Deployer.class);
        utilities.getUtility(RuntimeProperties.class).setProperties(config);
        utilities.getUtility(WorkScheduler.class);
        this.extensionPointRegistry.getExtensionPoint(ModuleActivatorExtensionPoint.class);
        this.domainRegistryFactory = ExtensibleDomainRegistryFactory.getInstance(this.extensionPointRegistry);
    }

    public ExtensionPointRegistry getExtensionPointRegistry() {
        return this.extensionPointRegistry;
    }

    public Deployer getDeployer() {
        return this.deployer;
    }

    public AssemblyFactory getAssemblyFactory() {
        return this.assemblyFactory;
    }

    protected NodeConfiguration loadConfiguration(String configURL) {
        InputStream xml = null;
        try {
            URL base = IOHelper.getLocationAsURL(configURL);
            xml = IOHelper.openStream(base);
            InputStreamReader reader = new InputStreamReader(xml, "UTF-8");
            ProcessorContext context = this.deployer.createProcessorContext();
            NodeConfiguration config = (NodeConfiguration)this.deployer.loadXMLDocument(reader, context.getMonitor());
            if (base != null && config != null) {
                for (ContributionConfiguration c : config.getContributions()) {
                    String location = c.getLocation();
                    if (location == null) continue;
                    URL url = new URL(base, location);
                    url = IOHelper.normalize(url);
                    c.setLocation(url.toString());
                }
            }
            NodeConfiguration nodeConfiguration = config;
            return nodeConfiguration;
        }
        catch (Throwable e) {
            throw new ServiceRuntimeException(e);
        }
        finally {
            try {
                if (xml != null) {
                    xml.close();
                }
            }
            catch (IOException e) {
                throw new ServiceRuntimeException(e);
            }
        }
    }
}

