/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.xml;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.ConfiguredOperation;
import org.apache.tuscany.sca.assembly.xml.Constants;
import org.apache.tuscany.sca.assembly.xml.PolicySubjectProcessor;
import org.apache.tuscany.sca.contribution.processor.ContributionReadException;
import org.apache.tuscany.sca.contribution.processor.ContributionResolveException;
import org.apache.tuscany.sca.contribution.processor.ContributionWriteException;
import org.apache.tuscany.sca.contribution.processor.ProcessorContext;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.core.FactoryExtensionPoint;
import org.apache.tuscany.sca.policy.PolicyFactory;

public class ConfiguredOperationProcessor
implements StAXArtifactProcessor<ConfiguredOperation>,
Constants {
    private AssemblyFactory assemblyFactory;
    private PolicySubjectProcessor policyProcessor;
    private PolicyFactory policyFactory;

    public ConfiguredOperationProcessor(FactoryExtensionPoint modelFactories) {
        this.assemblyFactory = (AssemblyFactory)modelFactories.getFactory(AssemblyFactory.class);
        this.policyFactory = (PolicyFactory)modelFactories.getFactory(PolicyFactory.class);
        this.policyProcessor = new PolicySubjectProcessor(this.policyFactory);
    }

    public ConfiguredOperation read(XMLStreamReader reader, ProcessorContext context) throws ContributionReadException, XMLStreamException {
        ConfiguredOperation configuredOp = this.assemblyFactory.createConfiguredOperation();
        configuredOp.setName(reader.getAttributeValue(null, "name"));
        configuredOp.setContractName(reader.getAttributeValue(null, "service"));
        configuredOp.setUnresolved(true);
        this.policyProcessor.readPolicies(configuredOp, reader);
        while (reader.hasNext() && (reader.next() != 2 || !OPERATION_QNAME.equals(reader.getName()))) {
        }
        return configuredOp;
    }

    public void write(ConfiguredOperation configuredOperation, XMLStreamWriter writer, ProcessorContext context) throws ContributionWriteException, XMLStreamException {
        writer.writeStartElement("http://docs.oasis-open.org/ns/opencsa/sca/200912", "operation");
        this.policyProcessor.writePolicyAttributes(configuredOperation, writer);
        writer.writeAttribute("name", configuredOperation.getName());
        if (configuredOperation.getContractName() != null) {
            writer.writeAttribute("service", configuredOperation.getContractName());
        }
        writer.writeEndElement();
    }

    public void resolve(ConfiguredOperation configuredOperation, ModelResolver resolver, ProcessorContext context) throws ContributionResolveException {
    }

    public QName getArtifactType() {
        return OPERATION_QNAME;
    }

    public Class<ConfiguredOperation> getModelType() {
        return ConfiguredOperation.class;
    }
}

