/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.dom.DOMSource;
import org.apache.tuscany.sca.assembly.AbstractContract;
import org.apache.tuscany.sca.assembly.AbstractProperty;
import org.apache.tuscany.sca.assembly.AbstractReference;
import org.apache.tuscany.sca.assembly.AssemblyFactory;
import org.apache.tuscany.sca.assembly.Base;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.ComponentType;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.ConfiguredOperation;
import org.apache.tuscany.sca.assembly.ConstrainingType;
import org.apache.tuscany.sca.assembly.Contract;
import org.apache.tuscany.sca.assembly.Extensible;
import org.apache.tuscany.sca.assembly.ExtensionFactory;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.Multiplicity;
import org.apache.tuscany.sca.assembly.OperationsConfigurator;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.Service;
import org.apache.tuscany.sca.assembly.builder.impl.ProblemImpl;
import org.apache.tuscany.sca.assembly.xml.Constants;
import org.apache.tuscany.sca.assembly.xml.PolicyAttachPointProcessor;
import org.apache.tuscany.sca.contribution.ContributionFactory;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.processor.StAXAttributeProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.contribution.service.ContributionReadException;
import org.apache.tuscany.sca.contribution.service.ContributionResolveException;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.monitor.Monitor;
import org.apache.tuscany.sca.monitor.Problem;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.IntentAttachPoint;
import org.apache.tuscany.sca.policy.IntentAttachPointType;
import org.apache.tuscany.sca.policy.IntentAttachPointTypeFactory;
import org.apache.tuscany.sca.policy.PolicyFactory;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.PolicySetAttachPoint;
import org.apache.tuscany.sca.policy.impl.IntentAttachPointTypeFactoryImpl;
import org.apache.tuscany.sca.policy.util.PolicyValidationException;
import org.apache.tuscany.sca.policy.util.PolicyValidationUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BaseAssemblyProcessor
extends BaseStAXArtifactProcessor
implements Constants {
    protected ContributionFactory contributionFactory;
    protected AssemblyFactory assemblyFactory;
    protected ExtensionFactory extensionFactory;
    protected PolicyFactory policyFactory;
    protected StAXArtifactProcessor<Object> extensionProcessor;
    protected StAXAttributeProcessor<Object> extensionAttributeProcessor;
    protected PolicyAttachPointProcessor policyProcessor;
    private DocumentBuilderFactory documentBuilderFactory;
    protected IntentAttachPointTypeFactory intentAttachPointTypeFactory;
    private Monitor monitor;

    public BaseAssemblyProcessor(ContributionFactory contribFactory, AssemblyFactory assemblyFactory, ExtensionFactory extensionFactory, PolicyFactory policyFactory, StAXArtifactProcessor extensionProcessor, StAXAttributeProcessor extensionAttributeProcessor, Monitor monitor) {
        this.contributionFactory = contribFactory;
        this.assemblyFactory = assemblyFactory;
        this.extensionFactory = extensionFactory;
        this.policyFactory = policyFactory;
        this.extensionProcessor = extensionProcessor;
        this.extensionAttributeProcessor = extensionAttributeProcessor;
        this.policyProcessor = new PolicyAttachPointProcessor(policyFactory);
        this.intentAttachPointTypeFactory = new IntentAttachPointTypeFactoryImpl();
        this.monitor = monitor;
    }

    public BaseAssemblyProcessor(AssemblyFactory assemblyfactory, ExtensionFactory extensionFactory, PolicyFactory policyFactory, StAXArtifactProcessor extensionProcessor, StAXAttributeProcessor extensionAttributeProcessor, Monitor monitor) {
        this.assemblyFactory = assemblyfactory;
        this.extensionFactory = extensionFactory;
        this.policyFactory = policyFactory;
        this.extensionProcessor = extensionProcessor;
        this.extensionAttributeProcessor = extensionAttributeProcessor;
        this.policyProcessor = new PolicyAttachPointProcessor(policyFactory);
        this.monitor = monitor;
    }

    protected void warning(String message, Object model, String ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "assembly-xml-validation-messages", Problem.Severity.WARNING, model, message, (Object[])messageParameters);
            this.monitor.problem((Problem)problem);
        }
    }

    protected void error(String message, Object model, Object ... messageParameters) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "assembly-xml-validation-messages", Problem.Severity.ERROR, model, message, messageParameters);
            this.monitor.problem((Problem)problem);
        }
    }

    protected void error(String message, Object model, Exception ex) {
        if (this.monitor != null) {
            ProblemImpl problem = new ProblemImpl(this.getClass().getName(), "assembly-xml-validation-messages", Problem.Severity.ERROR, model, message, ex);
            this.monitor.problem((Problem)problem);
        }
    }

    protected void writeStart(XMLStreamWriter writer, String name, BaseStAXArtifactProcessor.XAttr ... attrs) throws XMLStreamException {
        this.writeStart(writer, "http://www.osoa.org/xmlns/sca/1.0", name, attrs);
    }

    protected void writeStartDocument(XMLStreamWriter writer, String name, BaseStAXArtifactProcessor.XAttr ... attrs) throws XMLStreamException {
        writer.writeStartDocument();
        writer.setDefaultNamespace("http://www.osoa.org/xmlns/sca/1.0");
        this.writeStart(writer, "http://www.osoa.org/xmlns/sca/1.0", name, attrs);
        writer.writeDefaultNamespace("http://www.osoa.org/xmlns/sca/1.0");
    }

    protected void readTargets(Reference reference, XMLStreamReader reader) {
        String value = reader.getAttributeValue(null, "target");
        ComponentService target = null;
        if (value != null) {
            StringTokenizer tokens = new StringTokenizer(value);
            while (tokens.hasMoreTokens()) {
                target = this.assemblyFactory.createComponentService();
                target.setUnresolved(true);
                target.setName(tokens.nextToken());
                reference.getTargets().add(target);
            }
        }
    }

    protected BaseStAXArtifactProcessor.XAttr writeTargets(Reference reference) {
        ArrayList<String> targets = new ArrayList<String>();
        for (ComponentService target : reference.getTargets()) {
            targets.add(target.getName());
        }
        return new BaseStAXArtifactProcessor.XAttr("target", targets);
    }

    protected void readMultiplicity(AbstractReference reference, XMLStreamReader reader) {
        String value = reader.getAttributeValue(null, "multiplicity");
        if ("0..1".equals(value)) {
            reference.setMultiplicity(Multiplicity.ZERO_ONE);
        } else if ("1..n".equals(value)) {
            reference.setMultiplicity(Multiplicity.ONE_N);
        } else if ("0..n".equals(value)) {
            reference.setMultiplicity(Multiplicity.ZERO_N);
        } else if ("1..1".equals(value)) {
            reference.setMultiplicity(Multiplicity.ONE_ONE);
        }
    }

    protected BaseStAXArtifactProcessor.XAttr writeMultiplicity(AbstractReference reference) {
        Multiplicity multiplicity = reference.getMultiplicity();
        if (multiplicity != null) {
            String value = null;
            if (Multiplicity.ZERO_ONE.equals((Object)multiplicity)) {
                value = "0..1";
            } else if (Multiplicity.ONE_N.equals((Object)multiplicity)) {
                value = "1..n";
            } else if (Multiplicity.ZERO_N.equals((Object)multiplicity)) {
                value = "0..n";
            } else if (Multiplicity.ONE_ONE.equals((Object)multiplicity)) {
                value = "1..1";
                return null;
            }
            return new BaseStAXArtifactProcessor.XAttr("multiplicity", value);
        }
        return null;
    }

    protected ConstrainingType readConstrainingType(XMLStreamReader reader) {
        QName constrainingTypeName = this.getQName(reader, "constrainingType");
        if (constrainingTypeName != null) {
            ConstrainingType constrainingType = this.assemblyFactory.createConstrainingType();
            constrainingType.setName(constrainingTypeName);
            constrainingType.setUnresolved(true);
            return constrainingType;
        }
        return null;
    }

    protected void readAbstractProperty(AbstractProperty property, XMLStreamReader reader) throws XMLStreamException, ContributionReadException {
        property.setName(this.getString(reader, "name"));
        property.setMany(this.getBoolean(reader, "many"));
        property.setMustSupply(this.getBoolean(reader, "mustSupply"));
        property.setXSDElement(this.getQName(reader, "element"));
        property.setXSDType(this.getQName(reader, "type"));
    }

    protected Implementation resolveImplementation(Implementation implementation, ModelResolver resolver) throws ContributionResolveException, PolicyValidationException {
        if (implementation != null) {
            if (implementation.isUnresolved() && (implementation = (Implementation)resolver.resolveModel(Implementation.class, (Object)implementation)).isUnresolved()) {
                this.extensionProcessor.resolve((Object)implementation, resolver);
                if (!implementation.isUnresolved()) {
                    if (implementation instanceof PolicySetAttachPoint) {
                        PolicySetAttachPoint policiedImpl = (PolicySetAttachPoint)implementation;
                        this.resolveIntents(policiedImpl.getRequiredIntents(), resolver);
                        PolicyValidationUtils.validateIntents((IntentAttachPoint)policiedImpl, (IntentAttachPointType)policiedImpl.getType());
                        this.resolvePolicySets(policiedImpl.getPolicySets(), resolver);
                        PolicyValidationUtils.validatePolicySets((PolicySetAttachPoint)policiedImpl);
                        if (implementation instanceof OperationsConfigurator) {
                            OperationsConfigurator opsConfigurator = (OperationsConfigurator)implementation;
                            for (ConfiguredOperation implOp : opsConfigurator.getConfiguredOperations()) {
                                this.resolveIntents(implOp.getRequiredIntents(), resolver);
                                PolicyValidationUtils.validateIntents((IntentAttachPoint)implOp, (IntentAttachPointType)policiedImpl.getType());
                                this.resolvePolicySets(implOp.getPolicySets(), resolver);
                                PolicyValidationUtils.validatePolicySets((PolicySetAttachPoint)implOp, (IntentAttachPointType)policiedImpl.getType(), (List)policiedImpl.getApplicablePolicySets());
                            }
                        }
                        for (Service service : implementation.getServices()) {
                            this.resolveIntents(service.getRequiredIntents(), resolver);
                            this.resolvePolicySets(service.getPolicySets(), resolver);
                            for (ConfiguredOperation svcOp : service.getConfiguredOperations()) {
                                this.resolveIntents(svcOp.getRequiredIntents(), resolver);
                                this.resolvePolicySets(svcOp.getPolicySets(), resolver);
                            }
                        }
                        for (Reference reference : implementation.getReferences()) {
                            this.resolveIntents(reference.getRequiredIntents(), resolver);
                            this.resolvePolicySets(reference.getPolicySets(), resolver);
                        }
                    }
                    resolver.addModel((Object)implementation);
                }
            }
            if (implementation instanceof IntentAttachPoint && ((IntentAttachPoint)implementation).getType() != null && ((IntentAttachPoint)implementation).getType().isUnresolved()) {
                ((IntentAttachPoint)implementation).setType((IntentAttachPointType)resolver.resolveModel(IntentAttachPointType.class, (Object)((IntentAttachPoint)implementation).getType()));
            }
        }
        return implementation;
    }

    protected <C extends Contract> void resolveContracts(List<C> contracts, ModelResolver resolver) throws ContributionResolveException {
        this.resolveContracts(null, contracts, resolver);
    }

    protected <C extends Contract> void resolveContracts(Base parent, List<C> contracts, ModelResolver resolver) throws ContributionResolveException {
        String parentName = parent instanceof Composite ? ((Composite)parent).getName().toString() : (parent instanceof Component ? ((Component)parent).getName() : "UNKNOWN");
        for (Contract contract : contracts) {
            try {
                OperationsConfigurator opConfigurator;
                IntentAttachPointType resolved;
                IntentAttachPoint policiedBinding;
                Binding binding;
                int i;
                this.resolveIntents(contract.getRequiredIntents(), resolver);
                this.resolvePolicySets(contract.getPolicySets(), resolver);
                this.resolvePolicySets(contract.getApplicablePolicySets(), resolver);
                if (parent != null && parent instanceof PolicySetAttachPoint) {
                    this.addInheritedPolicySets(((PolicySetAttachPoint)parent).getApplicablePolicySets(), contract.getApplicablePolicySets());
                }
                for (ConfiguredOperation confOp : contract.getConfiguredOperations()) {
                    this.resolveIntents(confOp.getRequiredIntents(), resolver);
                    this.resolvePolicySets(confOp.getPolicySets(), resolver);
                    this.resolvePolicySets(confOp.getApplicablePolicySets(), resolver);
                    this.addInheritedPolicySets(contract.getApplicablePolicySets(), confOp.getApplicablePolicySets());
                }
                InterfaceContract interfaceContract = contract.getInterfaceContract();
                if (interfaceContract != null) {
                    this.extensionProcessor.resolve((Object)interfaceContract, resolver);
                }
                int n = contract.getBindings().size();
                for (i = 0; i < n; ++i) {
                    binding = (Binding)contract.getBindings().get(i);
                    this.extensionProcessor.resolve((Object)binding, resolver);
                    if (binding instanceof IntentAttachPoint) {
                        policiedBinding = (IntentAttachPoint)binding;
                        if (policiedBinding.getType() != null && policiedBinding.getType().isUnresolved()) {
                            resolved = (IntentAttachPointType)resolver.resolveModel(IntentAttachPointType.class, (Object)policiedBinding.getType());
                            policiedBinding.setType(resolved);
                        }
                        this.resolveIntents(policiedBinding.getRequiredIntents(), resolver);
                        PolicyValidationUtils.validateIntents((IntentAttachPoint)policiedBinding, (IntentAttachPointType)policiedBinding.getType());
                    }
                    if (binding instanceof PolicySetAttachPoint) {
                        policiedBinding = (PolicySetAttachPoint)binding;
                        this.resolvePolicySets(policiedBinding.getPolicySets(), resolver);
                        this.resolvePolicySets(policiedBinding.getApplicablePolicySets(), resolver);
                        this.addInheritedPolicySets(contract.getApplicablePolicySets(), policiedBinding.getApplicablePolicySets());
                        PolicyValidationUtils.validatePolicySets((PolicySetAttachPoint)policiedBinding);
                    }
                    if (!(binding instanceof OperationsConfigurator)) continue;
                    opConfigurator = (OperationsConfigurator)binding;
                    for (ConfiguredOperation confOp : opConfigurator.getConfiguredOperations()) {
                        this.resolveIntents(confOp.getRequiredIntents(), resolver);
                        PolicyValidationUtils.validateIntents((IntentAttachPoint)confOp, (IntentAttachPointType)((PolicySetAttachPoint)binding).getType());
                        this.resolvePolicySets(confOp.getPolicySets(), resolver);
                        this.resolvePolicySets(confOp.getApplicablePolicySets(), resolver);
                        this.addInheritedPolicySets(((PolicySetAttachPoint)binding).getApplicablePolicySets(), confOp.getApplicablePolicySets());
                        PolicyValidationUtils.validatePolicySets((PolicySetAttachPoint)confOp, (IntentAttachPointType)((PolicySetAttachPoint)binding).getType());
                    }
                }
                if (contract.getCallback() == null) continue;
                this.resolveIntents(contract.getCallback().getRequiredIntents(), resolver);
                this.resolvePolicySets(contract.getCallback().getPolicySets(), resolver);
                this.resolvePolicySets(contract.getCallback().getApplicablePolicySets(), resolver);
                this.addInheritedPolicySets(contract.getApplicablePolicySets(), contract.getCallback().getApplicablePolicySets());
                n = contract.getCallback().getBindings().size();
                for (i = 0; i < n; ++i) {
                    binding = (Binding)contract.getCallback().getBindings().get(i);
                    this.extensionProcessor.resolve((Object)binding, resolver);
                    if (binding instanceof IntentAttachPoint) {
                        policiedBinding = (IntentAttachPoint)binding;
                        if (policiedBinding.getType().isUnresolved()) {
                            resolved = (IntentAttachPointType)resolver.resolveModel(IntentAttachPointType.class, (Object)policiedBinding.getType());
                            policiedBinding.setType(resolved);
                        }
                        this.resolveIntents(policiedBinding.getRequiredIntents(), resolver);
                        PolicyValidationUtils.validateIntents((IntentAttachPoint)policiedBinding, (IntentAttachPointType)policiedBinding.getType());
                    }
                    if (binding instanceof PolicySetAttachPoint) {
                        policiedBinding = (PolicySetAttachPoint)binding;
                        this.resolvePolicySets(policiedBinding.getPolicySets(), resolver);
                        this.resolvePolicySets(policiedBinding.getApplicablePolicySets(), resolver);
                        this.addInheritedPolicySets(contract.getApplicablePolicySets(), policiedBinding.getApplicablePolicySets());
                        PolicyValidationUtils.validatePolicySets((PolicySetAttachPoint)policiedBinding);
                    }
                    if (!(binding instanceof OperationsConfigurator)) continue;
                    opConfigurator = (OperationsConfigurator)binding;
                    for (ConfiguredOperation confOp : opConfigurator.getConfiguredOperations()) {
                        this.resolveIntents(confOp.getRequiredIntents(), resolver);
                        PolicyValidationUtils.validateIntents((IntentAttachPoint)confOp, (IntentAttachPointType)((PolicySetAttachPoint)binding).getType());
                        this.resolvePolicySets(confOp.getPolicySets(), resolver);
                        this.resolvePolicySets(confOp.getApplicablePolicySets(), resolver);
                        this.addInheritedPolicySets(((PolicySetAttachPoint)binding).getApplicablePolicySets(), confOp.getApplicablePolicySets());
                        PolicyValidationUtils.validatePolicySets((PolicySetAttachPoint)confOp, (IntentAttachPointType)((PolicySetAttachPoint)binding).getType());
                    }
                }
            }
            catch (PolicyValidationException e) {
                this.error("PolicyServiceValidationException", (Object)contract, contract.getName(), parentName, e.getMessage());
            }
        }
    }

    protected <C extends AbstractContract> void resolveAbstractContracts(List<C> contracts, ModelResolver resolver) throws ContributionResolveException {
        for (AbstractContract contract : contracts) {
            InterfaceContract interfaceContract = contract.getInterfaceContract();
            if (interfaceContract == null) continue;
            this.extensionProcessor.resolve((Object)interfaceContract, resolver);
        }
    }

    protected BaseStAXArtifactProcessor.XAttr writeConstrainingType(ComponentType componentType) {
        ConstrainingType constrainingType = componentType.getConstrainingType();
        if (constrainingType != null) {
            return new BaseStAXArtifactProcessor.XAttr("constrainingType", constrainingType.getName());
        }
        return null;
    }

    protected Document readPropertyValue(QName element, QName type, XMLStreamReader reader) throws XMLStreamException, ContributionReadException {
        Document document;
        try {
            if (this.documentBuilderFactory == null) {
                this.documentBuilderFactory = DocumentBuilderFactory.newInstance();
                this.documentBuilderFactory.setNamespaceAware(true);
            }
            document = this.documentBuilderFactory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            ContributionReadException ce = new ContributionReadException((Throwable)e);
            this.error("ContributionReadException", (Object)this.documentBuilderFactory, (Exception)ce);
            throw ce;
        }
        Element root = document.createElementNS(null, "value");
        if (type != null) {
            Attr xsi = document.createAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi");
            xsi.setValue("http://www.w3.org/2001/XMLSchema-instance");
            root.setAttributeNodeNS(xsi);
            String prefix = type.getPrefix();
            if (prefix == null || prefix.length() == 0) {
                prefix = "ns";
            }
            this.declareNamespace(root, prefix, type.getNamespaceURI());
            Attr xsiType = document.createAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type");
            xsiType.setValue(prefix + ":" + type.getLocalPart());
            root.setAttributeNodeNS(xsiType);
        }
        document.appendChild(root);
        this.loadElement(reader, root);
        return document;
    }

    private Element createElement(Document document, QName name) {
        String prefix = name.getPrefix();
        String qname = prefix != null && prefix.length() > 0 ? prefix + ":" + name.getLocalPart() : name.getLocalPart();
        return document.createElementNS(name.getNamespaceURI(), qname);
    }

    private void declareNamespace(Element element, String prefix, String ns) {
        NamedNodeMap attrs;
        if (ns == null) {
            ns = "";
        }
        if (prefix == null) {
            prefix = "";
        }
        String qname = null;
        qname = "".equals(prefix) ? "xmlns" : "xmlns:" + prefix;
        boolean declared = false;
        for (Node node = element; node != null && node.getNodeType() == 1 && (attrs = node.getAttributes()) != null; node = node.getParentNode()) {
            Node attr = attrs.getNamedItem(qname);
            if (attr == null) continue;
            declared = ns.equals(attr.getNodeValue());
            break;
        }
        if (!declared) {
            Attr attr = element.getOwnerDocument().createAttributeNS("http://www.w3.org/2000/xmlns/", qname);
            attr.setValue(ns);
            element.setAttributeNodeNS(attr);
        }
    }

    private void loadElement(XMLStreamReader reader, Element root) throws XMLStreamException {
        Document document = root.getOwnerDocument();
        Node current = root;
        block6: while (true) {
            switch (reader.next()) {
                case 1: {
                    int i;
                    QName name = reader.getName();
                    Element child = this.createElement(document, name);
                    current.appendChild(child);
                    current = child;
                    int count = reader.getNamespaceCount();
                    for (i = 0; i < count; ++i) {
                        String prefix = reader.getNamespacePrefix(i);
                        String ns = reader.getNamespaceURI(i);
                        this.declareNamespace(child, prefix, ns);
                    }
                    if (!"".equals(name.getNamespaceURI())) {
                        this.declareNamespace(child, name.getPrefix(), name.getNamespaceURI());
                    }
                    count = reader.getAttributeCount();
                    i = 0;
                    while (true) {
                        if (i >= count) continue block6;
                        String ns = reader.getAttributeNamespace(i);
                        String prefix = reader.getAttributePrefix(i);
                        String qname = reader.getAttributeLocalName(i);
                        String value = reader.getAttributeValue(i);
                        if (prefix != null && prefix.length() != 0) {
                            qname = prefix + ":" + qname;
                        }
                        child.setAttributeNS(ns, qname, value);
                        if (ns != null) {
                            this.declareNamespace(child, prefix, ns);
                        }
                        ++i;
                    }
                }
                case 12: {
                    current.appendChild(document.createCDATASection(reader.getText()));
                    break;
                }
                case 4: {
                    current.appendChild(document.createTextNode(reader.getText()));
                    break;
                }
                case 2: {
                    if (current == root) {
                        return;
                    }
                    current = current.getParentNode();
                }
            }
        }
    }

    protected void resolveIntents(List<Intent> policyIntents, ModelResolver resolver) {
        ArrayList<Intent> requiredIntents = new ArrayList<Intent>();
        Intent resolvedIntent = null;
        for (Intent intent : policyIntents) {
            resolvedIntent = (Intent)resolver.resolveModel(Intent.class, (Object)intent);
            requiredIntents.add(resolvedIntent);
        }
        policyIntents.clear();
        policyIntents.addAll(requiredIntents);
    }

    protected void resolvePolicySets(List<PolicySet> policySets, ModelResolver resolver) {
        ArrayList<PolicySet> resolvedPolicySets = new ArrayList<PolicySet>();
        PolicySet resolvedPolicySet = null;
        for (PolicySet policySet : policySets) {
            if (policySet.isUnresolved()) {
                resolvedPolicySet = (PolicySet)resolver.resolveModel(PolicySet.class, (Object)policySet);
                resolvedPolicySets.add(resolvedPolicySet);
                continue;
            }
            resolvedPolicySets.add(policySet);
        }
        policySets.clear();
        policySets.addAll(resolvedPolicySets);
    }

    protected void writePropertyValue(Object propertyValue, QName element, QName type, XMLStreamWriter writer) throws XMLStreamException {
        if (propertyValue instanceof Document) {
            Document document = (Document)propertyValue;
            NodeList nodeList = document.getDocumentElement().getChildNodes();
            for (int item = 0; item < nodeList.getLength(); ++item) {
                Node node = nodeList.item(item);
                short nodeType = node.getNodeType();
                if (nodeType == 1) {
                    XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(new DOMSource(node));
                    block7: while (reader.hasNext()) {
                        switch (reader.next()) {
                            case 1: {
                                int i;
                                QName name = reader.getName();
                                writer.writeStartElement(name.getPrefix(), name.getLocalPart(), name.getNamespaceURI());
                                int namespaces = reader.getNamespaceCount();
                                for (i = 0; i < namespaces; ++i) {
                                    String prefix = reader.getNamespacePrefix(i);
                                    String ns = reader.getNamespaceURI(i);
                                    writer.writeNamespace(prefix, ns);
                                }
                                if (!"".equals(name.getNamespaceURI())) {
                                    writer.writeNamespace(name.getPrefix(), name.getNamespaceURI());
                                }
                                namespaces = reader.getAttributeCount();
                                for (i = 0; i < namespaces; ++i) {
                                    String ns = reader.getAttributeNamespace(i);
                                    String prefix = reader.getAttributePrefix(i);
                                    String qname = reader.getAttributeLocalName(i);
                                    String value = reader.getAttributeValue(i);
                                    writer.writeAttribute(prefix, ns, qname, value);
                                }
                                continue block7;
                            }
                            case 12: {
                                writer.writeCData(reader.getText());
                                break;
                            }
                            case 4: {
                                writer.writeCharacters(reader.getText());
                                break;
                            }
                            case 2: {
                                writer.writeEndElement();
                            }
                        }
                    }
                    continue;
                }
                writer.writeCharacters(node.getTextContent());
            }
        }
    }

    protected void addInheritedIntents(List<Intent> sourceList, List<Intent> targetList) {
        if (sourceList != null) {
            targetList.addAll(sourceList);
        }
    }

    protected void addInheritedPolicySets(List<PolicySet> sourceList, List<PolicySet> targetList) {
        if (sourceList != null) {
            targetList.addAll(sourceList);
        }
    }

    protected void readExtendedAttributes(XMLStreamReader reader, Extensible extensible) throws ContributionReadException, XMLStreamException {
        super.readExtendedAttributes(reader, extensible, this.extensionAttributeProcessor, this.extensionFactory);
    }
}

