/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.xml;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.tuscany.sca.assembly.xml.Constants;
import org.apache.tuscany.sca.contribution.processor.BaseStAXArtifactProcessor;
import org.apache.tuscany.sca.contribution.resolver.ModelResolver;
import org.apache.tuscany.sca.interfacedef.Operation;
import org.apache.tuscany.sca.policy.Intent;
import org.apache.tuscany.sca.policy.IntentAttachPoint;
import org.apache.tuscany.sca.policy.PolicyFactory;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.PolicySetAttachPoint;

public class PolicyAttachPointProcessor
extends BaseStAXArtifactProcessor
implements Constants {
    private PolicyFactory policyFactory;

    public PolicyAttachPointProcessor(PolicyFactory policyFactory) {
        this.policyFactory = policyFactory;
    }

    private void readIntents(Object attachPoint, Operation operation, XMLStreamReader reader) {
        if (!(attachPoint instanceof IntentAttachPoint)) {
            return;
        }
        IntentAttachPoint intentAttachPoint = (IntentAttachPoint)attachPoint;
        String value = reader.getAttributeValue(null, "requires");
        if (value != null) {
            List requiredIntents = intentAttachPoint.getRequiredIntents();
            StringTokenizer tokens = new StringTokenizer(value);
            while (tokens.hasMoreTokens()) {
                QName qname = this.getQNameValue(reader, tokens.nextToken());
                Intent intent = this.policyFactory.createIntent();
                intent.setName(qname);
                if (operation != null) {
                    // empty if block
                }
                requiredIntents.add(intent);
            }
        }
    }

    public void readPolicies(Object attachPoint, Operation operation, XMLStreamReader reader) {
        this.readIntents(attachPoint, operation, reader);
        this.readPolicySets(attachPoint, operation, reader);
    }

    public void readPolicies(Object attachPoint, XMLStreamReader reader) {
        this.readPolicies(attachPoint, null, reader);
    }

    private void readPolicySets(Object attachPoint, Operation operation, XMLStreamReader reader) {
        PolicySet policySet;
        QName qname;
        StringTokenizer tokens;
        if (!(attachPoint instanceof PolicySetAttachPoint)) {
            return;
        }
        PolicySetAttachPoint policySetAttachPoint = (PolicySetAttachPoint)attachPoint;
        String value = reader.getAttributeValue(null, "policySets");
        if (value != null) {
            List policySets = policySetAttachPoint.getPolicySets();
            tokens = new StringTokenizer(value);
            while (tokens.hasMoreTokens()) {
                qname = this.getQNameValue(reader, tokens.nextToken());
                policySet = this.policyFactory.createPolicySet();
                policySet.setName(qname);
                if (operation != null) {
                    // empty if block
                }
                policySets.add(policySet);
            }
        }
        if ((value = reader.getAttributeValue("http://tuscany.apache.org/xmlns/sca/1.0", "applicablePolicySets")) != null) {
            List applicablePolicySets = policySetAttachPoint.getApplicablePolicySets();
            tokens = new StringTokenizer(value);
            while (tokens.hasMoreTokens()) {
                qname = this.getQNameValue(reader, tokens.nextToken());
                policySet = this.policyFactory.createPolicySet();
                policySet.setName(qname);
                if (operation != null) {
                    // empty if block
                }
                applicablePolicySets.add(policySet);
            }
        }
    }

    BaseStAXArtifactProcessor.XAttr writePolicies(Object attachPoint) throws XMLStreamException {
        return this.writePolicies(attachPoint, null);
    }

    public void writePolicyAttributes(Object attachPoint, XMLStreamWriter writer) throws XMLStreamException {
        this.writePolicyAttributes(attachPoint, null, writer);
    }

    public void writePolicyPrefixes(Object attachPoint, XMLStreamWriter writer) throws XMLStreamException {
        this.writePolicyPrefixes(attachPoint, null, writer);
    }

    BaseStAXArtifactProcessor.XAttr writePolicies(Object attachPoint, Operation operation) {
        ArrayList<BaseStAXArtifactProcessor.XAttr> attrs = new ArrayList<BaseStAXArtifactProcessor.XAttr>();
        attrs.add(this.writeIntents(attachPoint, operation));
        attrs.add(this.writePolicySets(attachPoint, operation));
        return new BaseStAXArtifactProcessor.XAttr(null, attrs);
    }

    public void writePolicyAttributes(Object attachPoint, Operation operation, XMLStreamWriter writer) throws XMLStreamException {
        BaseStAXArtifactProcessor.XAttr attr = this.writePolicies(attachPoint, operation);
        attr.write(writer);
    }

    public void writePolicyPrefixes(Object attachPoint, Operation operation, XMLStreamWriter writer) throws XMLStreamException {
        BaseStAXArtifactProcessor.XAttr attr = this.writePolicies(attachPoint, operation);
        attr.writePrefix(writer);
    }

    private BaseStAXArtifactProcessor.XAttr writeIntents(Object attachPoint, Operation operation) {
        if (!(attachPoint instanceof IntentAttachPoint)) {
            return null;
        }
        IntentAttachPoint intentAttachPoint = (IntentAttachPoint)attachPoint;
        ArrayList<QName> qnames = new ArrayList<QName>();
        for (Intent intent : intentAttachPoint.getRequiredIntents()) {
            qnames.add(intent.getName());
        }
        return new BaseStAXArtifactProcessor.XAttr("requires", qnames);
    }

    private BaseStAXArtifactProcessor.XAttr writePolicySets(Object attachPoint, Operation operation) {
        if (!(attachPoint instanceof PolicySetAttachPoint)) {
            return null;
        }
        PolicySetAttachPoint policySetAttachPoint = (PolicySetAttachPoint)attachPoint;
        ArrayList<QName> qnames = new ArrayList<QName>();
        for (PolicySet policySet : policySetAttachPoint.getPolicySets()) {
            qnames.add(policySet.getName());
        }
        return new BaseStAXArtifactProcessor.XAttr("policySets", qnames);
    }

    public void resolvePolicies(Object attachPoint, ModelResolver resolver) {
        if (attachPoint instanceof PolicySetAttachPoint) {
            PolicySetAttachPoint policySetAttachPoint = (PolicySetAttachPoint)attachPoint;
            ArrayList<Intent> requiredIntents = new ArrayList<Intent>();
            Intent resolvedIntent = null;
            if (policySetAttachPoint.getRequiredIntents() != null && policySetAttachPoint.getRequiredIntents().size() > 0) {
                for (Intent intent : policySetAttachPoint.getRequiredIntents()) {
                    resolvedIntent = (Intent)resolver.resolveModel(Intent.class, (Object)intent);
                    requiredIntents.add(resolvedIntent);
                }
                policySetAttachPoint.getRequiredIntents().clear();
                policySetAttachPoint.getRequiredIntents().addAll(requiredIntents);
            }
            if (policySetAttachPoint.getPolicySets() != null && policySetAttachPoint.getPolicySets().size() > 0) {
                ArrayList<PolicySet> resolvedPolicySets = new ArrayList<PolicySet>();
                PolicySet resolvedPolicySet = null;
                for (PolicySet policySet : policySetAttachPoint.getPolicySets()) {
                    resolvedPolicySet = (PolicySet)resolver.resolveModel(PolicySet.class, (Object)policySet);
                    resolvedPolicySets.add(resolvedPolicySet);
                }
                policySetAttachPoint.getPolicySets().clear();
                policySetAttachPoint.getPolicySets().addAll(resolvedPolicySets);
            }
        }
    }
}

