/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Callback;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.Reference;
import org.apache.tuscany.sca.assembly.impl.AbstractReferenceImpl;
import org.apache.tuscany.sca.interfacedef.InterfaceContract;
import org.apache.tuscany.sca.policy.PolicySet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferenceImpl
extends AbstractReferenceImpl
implements Reference,
Cloneable {
    private List<Binding> bindings = new ArrayList<Binding>();
    private boolean wiredByImpl;
    private List<PolicySet> policySets = new ArrayList<PolicySet>();
    private List<ComponentService> targets = new ArrayList<ComponentService>();
    private Callback callback;
    private List<PolicySet> applicablePolicySets = new ArrayList<PolicySet>();
    private boolean promotionOverride;

    public List<PolicySet> getApplicablePolicySets() {
        return this.applicablePolicySets;
    }

    protected ReferenceImpl() {
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        ReferenceImpl clone = (ReferenceImpl)super.clone();
        clone.bindings = new ArrayList<Binding>();
        clone.bindings.addAll(this.getBindings());
        clone.targets = new ArrayList<ComponentService>();
        clone.targets.addAll(this.getTargets());
        return clone;
    }

    @Override
    public List<Binding> getBindings() {
        return this.bindings;
    }

    @Override
    public <B> B getBinding(Class<B> bindingClass) {
        for (Binding binding : this.bindings) {
            if (!bindingClass.isInstance(binding)) continue;
            return bindingClass.cast(binding);
        }
        return null;
    }

    @Override
    public <B> B getCallbackBinding(Class<B> bindingClass) {
        if (this.callback != null) {
            for (Binding binding : this.callback.getBindings()) {
                if (!bindingClass.isInstance(binding)) continue;
                return bindingClass.cast(binding);
            }
        }
        return null;
    }

    @Override
    public boolean isWiredByImpl() {
        return this.wiredByImpl;
    }

    @Override
    public void setWiredByImpl(boolean wiredByImpl) {
        this.wiredByImpl = wiredByImpl;
    }

    @Override
    public boolean isPromotionOverride() {
        return this.promotionOverride;
    }

    @Override
    public void setPromotionOverride(boolean promotionOverride) {
        this.promotionOverride = promotionOverride;
    }

    public List<PolicySet> getPolicySets() {
        return this.policySets;
    }

    @Override
    public List<ComponentService> getTargets() {
        return this.targets;
    }

    @Override
    public Callback getCallback() {
        return this.callback;
    }

    @Override
    public void setCallback(Callback callback) {
        this.callback = callback;
    }

    public void setPolicySets(List<PolicySet> policySets) {
        this.policySets = policySets;
    }

    @Override
    public InterfaceContract getInterfaceContract(Binding binding) {
        return this.getInterfaceContract();
    }
}

