/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.builder.impl;

import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.Composite;
import org.apache.tuscany.sca.assembly.Implementation;
import org.apache.tuscany.sca.assembly.builder.BindingBuilderExtension;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilder;
import org.apache.tuscany.sca.assembly.builder.CompositeBuilderException;
import org.apache.tuscany.sca.monitor.Monitor;

public class ComponentReferenceBindingBuilderImpl
implements CompositeBuilder {
    private Monitor monitor;

    public ComponentReferenceBindingBuilderImpl(Monitor monitor) {
        this.monitor = monitor;
    }

    public void build(Composite composite) throws CompositeBuilderException {
        this.buildReferenceBindings(composite);
    }

    private void buildReferenceBindings(Composite composite) {
        for (Component component : composite.getComponents()) {
            for (ComponentReference componentReference : component.getReferences()) {
                for (Binding binding : componentReference.getBindings()) {
                    if (!(binding instanceof BindingBuilderExtension)) continue;
                    ((BindingBuilderExtension)((Object)binding)).getBuilder().build(component, componentReference, binding, this.monitor);
                }
            }
        }
        for (Component component : composite.getComponents()) {
            Implementation implementation = component.getImplementation();
            if (!(implementation instanceof Composite)) continue;
            this.buildReferenceBindings((Composite)implementation);
        }
    }
}

