/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuscany.sca.assembly.builder.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.tuscany.sca.assembly.Binding;
import org.apache.tuscany.sca.assembly.Component;
import org.apache.tuscany.sca.assembly.ComponentReference;
import org.apache.tuscany.sca.assembly.ComponentService;
import org.apache.tuscany.sca.assembly.OptimizableBinding;
import org.apache.tuscany.sca.assembly.SCABinding;
import org.apache.tuscany.sca.policy.PolicySet;
import org.apache.tuscany.sca.policy.PolicySetAttachPoint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class BindingConfigurationUtil {
    BindingConfigurationUtil() {
    }

    private static boolean hasCompatiblePolicySets(Binding refBinding, Binding svcBinding) {
        boolean isCompatible = true;
        if (refBinding instanceof PolicySetAttachPoint && svcBinding instanceof PolicySetAttachPoint) {
            for (PolicySet svcPolicySet : ((PolicySetAttachPoint)svcBinding).getPolicySets()) {
                isCompatible = false;
                for (PolicySet refPolicySet : ((PolicySetAttachPoint)refBinding).getPolicySets()) {
                    if (!svcPolicySet.equals(refPolicySet)) continue;
                    isCompatible = true;
                    break;
                }
                if (isCompatible) continue;
                return isCompatible;
            }
        }
        return isCompatible;
    }

    static Binding matchBinding(Component targetComponent, ComponentService targetComponentService, List<Binding> source, List<Binding> target, Map<Binding, Binding> bindingMap, boolean isCallback) {
        ArrayList<Binding> matched = new ArrayList<Binding>();
        block2: for (Binding binding : source) {
            for (Binding serviceBinding : target) {
                if (binding.getClass() != serviceBinding.getClass() || !BindingConfigurationUtil.hasCompatiblePolicySets(binding, serviceBinding)) continue;
                try {
                    if (bindingMap != null) {
                        Binding sourceNodeBinding = bindingMap.get(binding);
                        Binding targetNodeBinding = bindingMap.get(serviceBinding);
                        if (targetNodeBinding != null && sourceNodeBinding != null && targetNodeBinding != sourceNodeBinding) {
                            if (!isCallback) {
                                serviceBinding.setURI(targetNodeBinding.getURI() + serviceBinding.getURI());
                                bindingMap.remove(serviceBinding);
                            } else {
                                binding.setURI(sourceNodeBinding.getURI() + binding.getURI());
                                bindingMap.remove(binding);
                            }
                        }
                    }
                    Binding cloned = (Binding)binding.clone();
                    if (targetComponent != null) {
                        cloned.setName(binding.getName() + "--" + targetComponent.getName() + ".." + serviceBinding.getName());
                    } else {
                        cloned.setName(binding.getName() + "--" + serviceBinding.getName());
                    }
                    if (binding.getURI() == null) {
                        cloned.setURI(serviceBinding.getURI());
                    }
                    if (binding instanceof OptimizableBinding) {
                        OptimizableBinding endpoint = (OptimizableBinding)cloned;
                        endpoint.setTargetComponent(targetComponent);
                        endpoint.setTargetComponentService(targetComponentService);
                        endpoint.setTargetBinding(serviceBinding);
                    }
                    matched.add(cloned);
                    continue block2;
                }
                catch (Exception ex) {
                }
            }
        }
        if (matched.isEmpty()) {
            return null;
        }
        for (Binding binding : matched) {
            if (!SCABinding.class.isInstance(binding)) continue;
            return binding;
        }
        return (Binding)matched.get(0);
    }

    static Binding resolveBindings(ComponentReference reference, Component component, ComponentService service, Map<Binding, Binding> bindingMap) {
        List source = reference.getBindings();
        List target = service.getBindings();
        return BindingConfigurationUtil.matchBinding(component, service, source, target, bindingMap, false);
    }

    static Binding resolveCallbackBindings(ComponentReference reference, Component component, ComponentService service, Map<Binding, Binding> bindingMap) {
        List<Binding> source = reference.getCallback().getBindings();
        List<Binding> target = service.getCallback().getBindings();
        return BindingConfigurationUtil.matchBinding(component, service, source, target, bindingMap, true);
    }
}

